/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.AnnotationScanner;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.api.Globals;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;

public class GenericAnnotationDetector
extends AnnotationScanner {
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    @LogMessageInfo(message="Cannot find archive {0} referenced from archive {1}, it will be ignored for annotation scanning", level="WARNING")
    private static final String ARCHIVE_NOT_FOUND = "NCLS-DEPLOYMENT-00006";
    @LogMessageInfo(message="Exception caught {0}", level="WARNING")
    private static final String EXCEPTION_CAUGHT = "NCLS-DEPLOYMENT-00007";
    @LogMessageInfo(message="Error in jar entry {0}:  {1}", level="WARNING")
    private static final String JAR_ENTRY_ERROR = "NCLS-DEPLOYMENT-00008";
    @LogMessageInfo(message="Failed to scan archive for annotations: {0}", level="WARNING")
    private static final String FAILED_ANNOTATION_SCAN = "NCLS-DEPLOYMENT-00009";
    boolean found = false;
    List<String> annotations = new ArrayList<String>();

    public GenericAnnotationDetector(Class[] annotationClasses) {
        if (annotationClasses != null) {
            for (Class annClass : annotationClasses) {
                this.annotations.add(Type.getDescriptor(annClass));
            }
        }
    }

    public boolean hasAnnotationInArchive(ReadableArchive archive) {
        this.scanArchive(archive);
        if (this.found) {
            return this.found;
        }
        ArchiveFactory archiveFactory = null;
        if (Globals.getDefaultHabitat() != null) {
            archiveFactory = Globals.getDefaultHabitat().getService(ArchiveFactory.class, new Annotation[0]);
        }
        if (archiveFactory != null) {
            List<URI> externalLibs = DeploymentUtils.getExternalLibraries(archive);
            for (URI externalLib : externalLibs) {
                try {
                    this.scanArchive(archiveFactory.openArchive(new File(externalLib.getPath())));
                }
                catch (FileNotFoundException fnfe) {
                    Object[] args = new Object[]{externalLib.getPath(), archive.getName()};
                    deplLogger.log(Level.WARNING, ARCHIVE_NOT_FOUND, args);
                }
                catch (Exception e) {
                    LogRecord lr = new LogRecord(Level.WARNING, EXCEPTION_CAUGHT);
                    Object[] args = new Object[]{e.getMessage()};
                    lr.setParameters(args);
                    lr.setThrown(e);
                    deplLogger.log(lr);
                }
            }
        }
        return this.found;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String s, boolean b) {
        if (this.annotations.contains(s)) {
            this.found = true;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanArchive(ReadableArchive archive) {
        try {
            int crFlags = 7;
            Enumeration<String> entries = archive.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement();
                if (entryName.endsWith(".class")) {
                    InputStream is = archive.getEntry(entryName);
                    try {
                        ClassReader cr = new ClassReader(is);
                        cr.accept(this, crFlags);
                        if (!this.found) continue;
                        return;
                    }
                    finally {
                        is.close();
                        continue;
                    }
                }
                if (!entryName.endsWith(".jar") || entryName.indexOf(47) != -1) continue;
                try (ReadableArchive jarSubArchive = null;){
                    jarSubArchive = archive.getSubArchive(entryName);
                    Enumeration<String> jarEntries = jarSubArchive.entries();
                    while (jarEntries.hasMoreElements()) {
                        String jarEntryName = jarEntries.nextElement();
                        if (!jarEntryName.endsWith(".class")) continue;
                        try (InputStream is = jarSubArchive.getEntry(jarEntryName);){
                            ClassReader cr = new ClassReader(is);
                            cr.accept(this, crFlags);
                            if (!this.found) continue;
                            return;
                        }
                    }
                }
                catch (IOException ioe) {
                    Object[] args = new Object[]{entryName, ioe.getMessage()};
                    deplLogger.log(Level.WARNING, JAR_ENTRY_ERROR, args);
                }
            }
        }
        catch (Exception e) {
            deplLogger.log(Level.WARNING, FAILED_ANNOTATION_SCAN, e.getMessage());
        }
    }
}

