/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.server.DomainXmlPersistence;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.config.UnprocessedConfigListener;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="remove-library")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.DELETE, path="remove-library", description="Uninstall library")})
public class RemoveLibraryCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    @Param(primary=true, multiple=true)
    String[] names = null;
    @Param(optional=true, acceptableValues="common, ext, app")
    String type = "common";
    @Inject
    ServerEnvironment env;
    @Inject
    DomainXmlPersistence dxp;
    @Inject
    UnprocessedConfigListener ucl;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RemoveLibraryCommand.class);

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList accessChecks = new ArrayList();
        for (String libName : this.names) {
            accessChecks.add(new AccessRequired.AccessCheck("domain/libraries//" + this.type + "/" + libName, "delete"));
        }
        return accessChecks;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        File libDir = this.env.getLibPath();
        if (this.type.equals("ext")) {
            libDir = new File(libDir, "ext");
        } else if (this.type.equals("app")) {
            libDir = new File(libDir, "applibs");
        }
        try {
            ArrayList<UnprocessedChangeEvent> unprocessed = new ArrayList<UnprocessedChangeEvent>();
            StringBuffer msg = new StringBuffer();
            for (String libraryName : this.names) {
                File libraryFile = new File(libDir, libraryName);
                if (libraryFile.exists()) {
                    boolean isDeleted = FileUtils.deleteFile(libraryFile);
                    if (!isDeleted) {
                        msg.append(localStrings.getLocalString("lfnd", "Could not remove library file", libraryFile.getAbsolutePath()));
                        continue;
                    }
                    PropertyChangeEvent pe = new PropertyChangeEvent(libDir, "remove-library", libraryFile, null);
                    UnprocessedChangeEvent uce = new UnprocessedChangeEvent(pe, "remove-library");
                    unprocessed.add(uce);
                    continue;
                }
                msg.append(localStrings.getLocalString("lfnf", "Library file not found", libraryFile.getAbsolutePath()));
            }
            if (msg.length() > 0) {
                logger2.log(Level.WARNING, msg.toString());
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
                report.setMessage(msg.toString());
            }
            UnprocessedChangeEvents uces = new UnprocessedChangeEvents(unprocessed);
            ArrayList<UnprocessedChangeEvents> ucesList = new ArrayList<UnprocessedChangeEvents>();
            ucesList.add(uces);
            this.ucl.unprocessedTransactedEvents(ucesList);
            this.dxp.touch();
        }
        catch (Exception e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
    }
}

