/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.admin.InterceptorNotifier;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Service;

@Service(name="_postdeploy")
@Supplemental(value="deploy", ifFailure=FailurePolicy.Warn)
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_postdeploy", description="_postdeploy")})
@AccessRequired(resource={"domain/applications/application"}, action={"write"})
public class PostDeployCommand
extends DeployCommandParameters
implements AdminCommand {
    @Inject
    private ServiceLocator habitat;
    @Inject
    private Deployment deployment;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        DeployCommandSupplementalInfo suppInfo = context.getActionReport().getResultType(DeployCommandSupplementalInfo.class);
        ExtendedDeploymentContext dc = suppInfo.deploymentContext();
        DeployCommandParameters params = dc.getCommandParameters(DeployCommandParameters.class);
        InterceptorNotifier notifier = new InterceptorNotifier(this.habitat, dc);
        if (DeploymentUtils.isDASTarget(params.target)) {
            return;
        }
        try {
            ParameterMap paramMap = this.deployment.prepareInstanceDeployParamMap(dc);
            ArrayList<String> targets = new ArrayList<String>();
            if (!DeploymentUtils.isDomainTarget(params.target)) {
                targets.add(params.target);
            } else {
                targets = suppInfo.previousTargets();
            }
            ClusterOperationUtil.replicateCommand("_deploy", FailurePolicy.Warn, FailurePolicy.Warn, FailurePolicy.Ignore, targets, context, paramMap, this.habitat);
            notifier.ensureAfterReported(ExtendedDeploymentContext.Phase.REPLICATION);
        }
        catch (Exception e) {
            report.failure(logger2, e.getMessage());
        }
    }
}

