/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.sun.enterprise.util.StringUtils;
import java.io.File;
import java.util.Properties;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.admin.rest.provider.AbstractStaxProvider;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModel;

@Provider
@Produces(value={"application/xml", "text/xml", "application/json", "application/x-javascript"})
public class CommandModelStaxProvider
extends AbstractStaxProvider<CommandModel> {
    public CommandModelStaxProvider() {
        super(CommandModel.class, MediaType.APPLICATION_XML_TYPE, MediaType.TEXT_XML_TYPE, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    protected void writeContentToStream(CommandModel proxy, XMLStreamWriter wr) throws XMLStreamException {
        String usage;
        if (proxy == null) {
            return;
        }
        wr.writeStartDocument();
        wr.writeStartElement("command");
        wr.writeAttribute("name", proxy.getCommandName());
        if (proxy.unknownOptionsAreOperands()) {
            wr.writeAttribute("unknown-options-are-operands", "true");
        }
        if (proxy.isManagedJob()) {
            wr.writeAttribute("managed-job", "true");
        }
        if (StringUtils.ok(usage = proxy.getUsageText())) {
            wr.writeStartElement("usage");
            wr.writeCharacters(usage);
            wr.writeEndElement();
        }
        for (CommandModel.ParamModel p : proxy.getParameters()) {
            String str;
            Param par = p.getParam();
            wr.writeStartElement("option");
            wr.writeAttribute("name", p.getName());
            wr.writeAttribute("type", CommandModelStaxProvider.simplifiedTypeOf(p));
            if (par.primary()) {
                wr.writeAttribute("primary", "true");
            }
            if (par.multiple()) {
                wr.writeAttribute("multiple", "true");
            }
            if (par.optional()) {
                wr.writeAttribute("optional", "true");
            }
            if (par.obsolete()) {
                wr.writeAttribute("obsolete", "true");
            }
            if (StringUtils.ok(str = par.shortName())) {
                wr.writeAttribute("short", str);
            }
            if (StringUtils.ok(str = par.defaultValue())) {
                wr.writeAttribute("default", str);
            }
            if (StringUtils.ok(str = par.acceptableValues())) {
                wr.writeAttribute("acceptable-values", str);
            }
            if (StringUtils.ok(str = par.alias())) {
                wr.writeAttribute("alias", str);
            }
            if (StringUtils.ok(str = p.getLocalizedDescription())) {
                wr.writeAttribute("description", str);
            }
            if (StringUtils.ok(str = p.getLocalizedPrompt())) {
                wr.writeAttribute("prompt", str);
            }
            if (StringUtils.ok(str = p.getLocalizedPromptAgain())) {
                wr.writeAttribute("prompt-again", str);
            }
            wr.writeEndElement();
        }
        wr.writeEndElement();
        wr.writeEndDocument();
    }

    public static String simplifiedTypeOf(CommandModel.ParamModel p) {
        Class t = p.getType();
        if (t == Boolean.class || t == Boolean.TYPE) {
            return "BOOLEAN";
        }
        if (t == File.class || t == File[].class) {
            return "FILE";
        }
        if (t == Properties.class) {
            return "PROPERTIES";
        }
        if (p.getParam().password()) {
            return "PASSWORD";
        }
        return "STRING";
    }
}

