/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.admin.monitor.jvm.JVMClassLoadingStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMCompilationStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMGCStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMMemoryStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMOSStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMRuntimeStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMThreadInfoStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMThreadSystemStatsProvider;
import org.glassfish.admin.monitor.jvm.ServerRuntimeStatsProvider;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=20, mode=0)
public class JVMStatsProviderBootstrap
implements PostConstruct {
    private ServerRuntimeStatsProvider sRuntimeStatsProvider = new ServerRuntimeStatsProvider();
    private JVMClassLoadingStatsProvider clStatsProvider = new JVMClassLoadingStatsProvider();
    private JVMCompilationStatsProvider compileStatsProvider = new JVMCompilationStatsProvider();
    private JVMMemoryStatsProvider memoryStatsProvider = new JVMMemoryStatsProvider();
    private JVMOSStatsProvider osStatsProvider = new JVMOSStatsProvider();
    private JVMRuntimeStatsProvider runtimeStatsProvider = new JVMRuntimeStatsProvider();
    private JVMThreadSystemStatsProvider threadSysStatsProvider = new JVMThreadSystemStatsProvider();
    private List<JVMGCStatsProvider> jvmStatsProviderList = new ArrayList<JVMGCStatsProvider>();
    private ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    public static final String JVM = "jvm";

    @Override
    public void postConstruct() {
        StatsProviderManager.register(JVM, PluginPoint.SERVER, "", (Object)this.sRuntimeStatsProvider, "LOW");
        StatsProviderManager.register(JVM, PluginPoint.SERVER, "jvm/class-loading-system", (Object)this.clStatsProvider, "LOW");
        StatsProviderManager.register(JVM, PluginPoint.SERVER, "jvm/compilation-system", (Object)this.compileStatsProvider, "LOW");
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            JVMGCStatsProvider jvmStatsProvider = new JVMGCStatsProvider(gc.getName());
            this.jvmStatsProviderList.add(jvmStatsProvider);
            StatsProviderManager.register(JVM, PluginPoint.SERVER, "jvm/garbage-collectors/" + gc.getName(), (Object)jvmStatsProvider, "LOW");
        }
        StatsProviderManager.register(JVM, PluginPoint.SERVER, "jvm/memory", (Object)this.memoryStatsProvider, "LOW");
        StatsProviderManager.register(JVM, PluginPoint.SERVER, "jvm/operating-system", (Object)this.osStatsProvider, "LOW");
        StatsProviderManager.register(JVM, PluginPoint.SERVER, "jvm/runtime", (Object)this.runtimeStatsProvider, "LOW");
        StatsProviderManager.register(JVM, PluginPoint.SERVER, "jvm/thread-system", (Object)this.threadSysStatsProvider, "LOW");
        for (ThreadInfo t : this.threadBean.getThreadInfo(this.threadBean.getAllThreadIds(), 5)) {
            if (t == null) continue;
            JVMThreadInfoStatsProvider threadInfoStatsProvider = new JVMThreadInfoStatsProvider(t);
            StatsProviderManager.register(JVM, PluginPoint.SERVER, "jvm/thread-system/thread-" + t.getThreadId(), (Object)threadInfoStatsProvider, "HIGH");
        }
    }
}

