/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;

public class JavaModelInputImpl
implements JavaModelInput {
    private JavaClass[] jClasses;
    private JavaModel jModel;
    private boolean facets;

    public JavaModelInputImpl(Type[] types, JavaModel javaModel) {
        this.jModel = javaModel;
        this.jClasses = new JavaClass[types.length];
        int i = 0;
        while (i < types.length) {
            TypeMappingInfo typeMappingInfo = new TypeMappingInfo();
            Type type2 = types[i];
            typeMappingInfo.setType(type2);
            this.jClasses[i] = this.buildJavaClassImpl(type2);
            ++i;
        }
    }

    public JavaModelInputImpl(TypeMappingInfo[] types, JavaModel javaModel) {
        this.jModel = javaModel;
        this.jClasses = new JavaClass[types.length];
        int i = 0;
        while (i < types.length) {
            TypeMappingInfo typeMappingInfo = types[i];
            Type type2 = typeMappingInfo.getType();
            this.jClasses[i] = this.buildJavaClassImpl(type2);
            ++i;
        }
    }

    public JavaModelInputImpl(Class[] classes, JavaModel javaModel) {
        this.jModel = javaModel;
        this.jClasses = new JavaClass[classes.length];
        int i = 0;
        while (i < classes.length) {
            this.jClasses[i] = javaModel.getClass(classes[i]);
            ++i;
        }
    }

    private JavaClassImpl buildJavaClassImpl(Type type2) {
        if (type2 instanceof Class) {
            return (JavaClassImpl)this.jModel.getClass((Class)type2);
        }
        if (type2 instanceof GenericArrayType) {
            Class<?> genericTypeClass = (Class<?>)((GenericArrayType)type2).getGenericComponentType();
            genericTypeClass = Array.newInstance(genericTypeClass, 0).getClass();
            return new JavaClassImpl(genericTypeClass, (JavaModelImpl)this.jModel);
        }
        ParameterizedType pType = (ParameterizedType)type2;
        return new JavaClassImpl(pType, (Class)pType.getRawType(), (JavaModelImpl)this.jModel);
    }

    @Override
    public JavaClass[] getJavaClasses() {
        return this.jClasses;
    }

    @Override
    public JavaModel getJavaModel() {
        return this.jModel;
    }

    public boolean isFacets() {
        return this.facets;
    }

    public void setFacets(boolean facets) {
        this.facets = facets;
    }
}

