/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleSupport;
import org.glassfish.logging.annotation.LogMessageInfo;

public abstract class StoreBase
implements Lifecycle,
Store {
    private static final java.util.logging.Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    @LogMessageInfo(message="StoreBase has already been started", level="WARNING")
    public static final String STORE_BASE_STARTED_EXCEPTION = "AS-WEB-CORE-00396";
    @LogMessageInfo(message="StoreBase has not been started", level="WARNING")
    public static final String STORE_BASE_NOT_STARTED_EXCEPTION = "AS-WEB-CORE-00397";
    protected String info = "StoreBase/1.0";
    protected String storeName = "StoreBase";
    protected int debug = 0;
    protected boolean started = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Manager manager;

    @Override
    public String getInfo() {
        return this.info;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public int getDebug() {
        return this.debug;
    }

    @Override
    public void setManager(Manager manager) {
        Manager oldManager = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void writeSession(Session sess, ObjectOutputStream oos) throws IOException {
        if (sess == null) {
            return;
        }
        oos.writeObject(sess);
    }

    public Session readSession(Manager manager, ObjectInputStream ois) throws ClassNotFoundException, IOException {
        StandardSession sess = StandardSession.deserialize(ois, manager);
        sess.setManager(manager);
        return sess;
    }

    public void doProcessExpires() {
        this.processExpires();
    }

    public void removeFromStoreCache(String id) {
    }

    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        String[] keys = null;
        if (!this.started) {
            return;
        }
        try {
            keys = this.keys();
        }
        catch (IOException e) {
            this.log("Error during processExpires", e);
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            try {
                int timeIdle;
                StandardSession session = (StandardSession)this.load(keys[i]);
                if (session == null || (timeIdle = (int)((timeNow - session.thisAccessedTime) / 1000L)) < session.getMaxInactiveInterval()) continue;
                if (((PersistentManagerBase)this.manager).isLoaded(keys[i])) {
                    session.recycle();
                } else {
                    session.expire();
                }
                this.remove(keys[i]);
                continue;
            }
            catch (IOException e) {
                this.log("Error during processExpires", e);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.log("Error during processExpires", e);
            }
        }
    }

    protected void log(String message) {
        Logger logger2 = null;
        String containerName = null;
        Container container = this.manager.getContainer();
        if (container != null) {
            logger2 = container.getLogger();
            containerName = container.getName();
        }
        if (logger2 != null) {
            logger2.log(this.getStoreName() + "[" + containerName + "]: " + message);
        } else {
            log.log(Level.FINE, this.getStoreName() + "[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable t) {
        Logger logger2 = null;
        String containerName = null;
        Container container = this.manager.getContainer();
        if (container != null) {
            logger2 = container.getLogger();
            containerName = container.getName();
        }
        if (logger2 != null) {
            logger2.log(this.getStoreName() + "[" + containerName + "]: " + message, t, 2);
        } else {
            log.log(Level.WARNING, this.getStoreName() + "[" + containerName + "]: " + message, t);
        }
    }

    public Session load(String id, String version) throws ClassNotFoundException, IOException {
        return this.load(id);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(rb.getString(STORE_BASE_STARTED_EXCEPTION));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(rb.getString(STORE_BASE_NOT_STARTED_EXCEPTION));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }
}

