/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import jcifs.Config;
import jcifs.netbios.Name;
import jcifs.netbios.NbtAddress;
import jcifs.netbios.NbtException;
import jcifs.netbios.SessionRequestPacket;
import jcifs.netbios.SessionServicePacket;
import jcifs.netbios.SocketInputStream;
import jcifs.netbios.SocketOutputStream;
import jcifs.util.LogStream;

public class NbtSocket
extends Socket {
    private static final int SSN_SRVC_PORT = 139;
    private static final int BUFFER_SIZE = 512;
    private static final int DEFAULT_SO_TIMEOUT = 5000;
    private static LogStream log = LogStream.getInstance();
    private NbtAddress address;
    private Name calledName;
    private int soTimeout;

    public NbtSocket() {
    }

    public NbtSocket(NbtAddress address, int port) throws IOException {
        this(address, port, null, 0);
    }

    public NbtSocket(NbtAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this(address, null, port, localAddr, localPort);
    }

    public NbtSocket(NbtAddress address, String calledName, int port, InetAddress localAddr, int localPort) throws IOException {
        super(address.getInetAddress(), port == 0 ? 139 : port, localAddr, localPort);
        this.address = address;
        this.calledName = calledName == null ? address.hostName : new Name(calledName, 32, null);
        this.soTimeout = Config.getInt("jcifs.netbios.soTimeout", 5000);
        this.connect();
    }

    public NbtAddress getNbtAddress() {
        return this.address;
    }

    public InputStream getInputStream() throws IOException {
        return new SocketInputStream(super.getInputStream());
    }

    public OutputStream getOutputStream() throws IOException {
        return new SocketOutputStream(super.getOutputStream());
    }

    public int getPort() {
        return super.getPort();
    }

    public InetAddress getLocalAddress() {
        return super.getLocalAddress();
    }

    public int getLocalPort() {
        return super.getLocalPort();
    }

    public String toString() {
        return "NbtSocket[addr=" + this.address + ",port=" + super.getPort() + ",localport=" + super.getLocalPort() + "]";
    }

    /*
     * WARNING - void declaration
     */
    private void connect() throws IOException {
        int type2;
        byte[] buffer = new byte[512];
        try {
            InputStream in = super.getInputStream();
            OutputStream out = super.getOutputStream();
            SessionRequestPacket ssp0 = new SessionRequestPacket(this.calledName, NbtAddress.localhost.hostName);
            out.write(buffer, 0, ssp0.writeWireFormat(buffer, 0));
            this.setSoTimeout(this.soTimeout);
            type2 = SessionServicePacket.readPacketType(in, buffer, 0);
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
        switch (type2) {
            case 130: {
                if (LogStream.level > 2) {
                    log.println("session established ok with " + this.address);
                }
                return;
            }
            case 131: {
                void var3_2;
                int errorCode = var3_2.read() & 0xFF;
                this.close();
                throw new NbtException(2, errorCode);
            }
            case -1: {
                throw new NbtException(2, -1);
            }
        }
        this.close();
        throw new NbtException(2, 0);
    }

    public void close() throws IOException {
        if (LogStream.level > 3) {
            log.println("close: " + this);
        }
        super.close();
    }
}

