/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-cleanup")
@RunLevel(value=10)
public class CleanupPostBoot
implements EventListener {
    @Inject
    Events events;
    private static Logger logger = Logger.getLogger(CleanupPostBoot.class.getName());

    @PostConstruct
    public void postConstruct() {
        this.events.register(this);
    }

    @Override
    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            logger.info("Cleaning JarFileFactory Cache to prevent jar FD leaks");
            try {
                Field[] fields;
                Class<?> clazz = Class.forName("sun.net.www.protocol.jar.JarFileFactory", true, URL.class.getClassLoader());
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (!"fileCache".equals(field.getName())) continue;
                    field.setAccessible(true);
                    HashMap files = (HashMap)field.get(null);
                    HashSet jars = new HashSet();
                    jars.addAll(files.values());
                    for (JarFile file : jars) {
                        file.close();
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }
}

