/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.web.integration.WebProgrammaticLogin;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.jvnet.hk2.annotations.Service;

@Service
public class WebProgrammaticLoginImpl
implements WebProgrammaticLogin {
    public static final String WEBAUTH_PROGRAMMATIC = "PROGRAMMATIC";
    private static Logger logger = LogDomains.getLogger(WebProgrammaticLoginImpl.class, "javax.enterprise.system.core.security");

    @Override
    public Boolean login(String user, char[] password, String realm, HttpServletRequest request, HttpServletResponse response) {
        Session realSession;
        Request req = WebProgrammaticLoginImpl.getUnwrappedCoyoteRequest(request);
        if (req == null) {
            return false;
        }
        LoginContextDriver.login(user, password, realm);
        SecurityContext secCtx = SecurityContext.getCurrent();
        assert (secCtx != null);
        WebPrincipal principal = new WebPrincipal(user, password, secCtx);
        req.setUserPrincipal(principal);
        req.setAuthType(WEBAUTH_PROGRAMMATIC);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Programmatic login set principal in http request to: " + user);
        }
        if ((realSession = WebProgrammaticLoginImpl.getSession(req)) != null) {
            realSession.setPrincipal(principal);
            realSession.setAuthType(WEBAUTH_PROGRAMMATIC);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Programmatic login set principal in session.");
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Programmatic login: No session available.");
        }
        return true;
    }

    private static Request getUnwrappedCoyoteRequest(HttpServletRequest request) {
        Request req = null;
        ServletRequest servletRequest = request;
        try {
            HttpServletRequest prevRequest = null;
            while (servletRequest != prevRequest && servletRequest instanceof ServletRequestWrapper) {
                prevRequest = servletRequest;
                servletRequest = ((ServletRequestWrapper)servletRequest).getRequest();
            }
            if (servletRequest instanceof RequestFacade) {
                req = ((RequestFacade)servletRequest).getUnwrappedCoyoteRequest();
            }
        }
        catch (AccessControlException ex) {
            logger.log(Level.FINE, "Programmatic login faiied to get request");
        }
        return req;
    }

    @Override
    public Boolean logout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Session realSession;
        Request req = WebProgrammaticLoginImpl.getUnwrappedCoyoteRequest(request);
        if (req == null) {
            return false;
        }
        LoginContextDriver.logout();
        req.setUserPrincipal(null);
        req.setAuthType(null);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Programmatic logout removed principal from request.");
        }
        if ((realSession = WebProgrammaticLoginImpl.getSession(req)) != null) {
            realSession.setPrincipal(null);
            realSession.setAuthType(null);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Programmatic logout removed principal from session.");
            }
        }
        return true;
    }

    private static Session getSession(Request request) {
        Manager manager;
        Context context;
        HttpSession session = request.getSession(false);
        if (session != null && (context = request.getContext()) != null && (manager = context.getManager()) != null) {
            String sessionId = session.getId();
            try {
                Session realSession = manager.findSession(sessionId);
                return realSession;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

