/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.DelegatedRecoveryManager;
import com.sun.jts.CosTransactions.DelegatedTimeoutInfo;
import com.sun.jts.CosTransactions.DelegatedTimeoutThread;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.jts.jtsxa.XID;
import com.sun.logging.LogDomains;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CosTransactions.Status;

class DelegatedTimeoutManager {
    static final int CANCEL_TIMEOUT = 0;
    static final int NO_TIMEOUT = 0;
    static final int ACTIVE_TIMEOUT = 1;
    static final int IN_DOUBT_TIMEOUT = 2;
    private static boolean initialised = false;
    private Hashtable pendingTimeouts = new Hashtable();
    private Hashtable indoubtTimeouts = new Hashtable();
    private DelegatedTimeoutThread timeoutThread = null;
    private boolean timeoutActive = false;
    private boolean quiescing = false;
    private boolean isSetTimeout = false;
    private String logPath = null;
    static Logger _logger = LogDomains.getLogger(DelegatedTimeoutManager.class, "javax.enterprise.system.core.transaction");

    DelegatedTimeoutManager() {
    }

    DelegatedTimeoutManager(String logPath) {
        this.logPath = logPath;
    }

    synchronized void initSetTimeout() {
        if (this.isSetTimeout) {
            return;
        }
        this.isSetTimeout = true;
        this.timeoutThread = new DelegatedTimeoutThread(this);
        this.timeoutThread.start();
    }

    boolean setTimeout(Long localTID, int timeoutType, int seconds) {
        boolean result = true;
        DelegatedTimeoutInfo timeoutInfo = null;
        switch (timeoutType) {
            case 1: {
                if (!this.isSetTimeout) {
                    this.initSetTimeout();
                }
                timeoutInfo = new DelegatedTimeoutInfo();
                timeoutInfo.expireTime = new Date().getTime() + (long)seconds * 1000L;
                timeoutInfo.localTID = localTID;
                timeoutInfo.timeoutType = timeoutType;
                this.pendingTimeouts.put(localTID, timeoutInfo);
                break;
            }
            case 2: {
                if (!this.isSetTimeout) {
                    this.initSetTimeout();
                }
                timeoutInfo = new DelegatedTimeoutInfo();
                timeoutInfo.expireTime = new Date().getTime() + (long)seconds * 1000L;
                timeoutInfo.localTID = localTID;
                timeoutInfo.timeoutType = timeoutType;
                this.indoubtTimeouts.put(localTID, timeoutInfo);
                break;
            }
            default: {
                if (!this.isSetTimeout) break;
                boolean bl = result = this.pendingTimeouts.remove(localTID) != null;
                if (!result) {
                    boolean bl2 = result = this.indoubtTimeouts.remove(localTID) != null;
                }
                if (!this.quiescing || !this.pendingTimeouts.isEmpty() || !this.indoubtTimeouts.isEmpty()) break;
                this.timeoutThread.stop();
                this.timeoutActive = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeoutCoordinator(Long localTID, int timeoutType) {
        CoordinatorImpl coord = DelegatedRecoveryManager.getLocalCoordinator(localTID, this.logPath);
        if (coord == null) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.logp(Level.FINER, "DelegatedTimeoutManager", "timeoutCoordinator()", "DelegatedRecoveryManager.getLocalCoordinator() returned null,which means txn is done. Setting timeout type to CANCEL_TIMEOUT");
            }
            this.setTimeout(localTID, 0, 0);
        } else {
            CoordinatorImpl coordinatorImpl = coord;
            synchronized (coordinatorImpl) {
                boolean[] isRoot = new boolean[1];
                switch (timeoutType) {
                    case 1: {
                        if (_logger.isLoggable(Level.FINER)) {
                            _logger.logp(Level.FINER, "DelegatedTimeoutManager", "timeoutCoordinator()", "DelegatedTimeoutManager.timeoutCoordinator():case ACTIVE_TIMEOUTDelegatedRecoveryManager.getLocalCoordinator() returned non-null,which means txn is still around. Rolling back thetransaction...: GTID is : " + ((TopCoordinator)coord).superInfo.globalTID.toString());
                        }
                        try {
                            coord.rollback_only();
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                    case 2: {
                        Status state;
                        if (_logger.isLoggable(Level.FINER)) {
                            _logger.logp(Level.FINER, "DelegatedTimeoutManager", "timeoutCoordinator()", "DelegatedTimeoutManager.timeoutCoordinator():case IN_DOUBT_TIMEOUTDelegatedRecoveryManager.getLocalCoordinator() returned non-null,which means txn is still around. Invoking recover(boolean)on TopCoordinator...: GTID is: " + ((TopCoordinator)coord).superInfo.globalTID.toString());
                        }
                        if ((state = ((TopCoordinator)coord).recover(isRoot)) == Status.StatusUnknown) {
                            _logger.log(Level.WARNING, "jts.transaction_resync_from_orginator_failed");
                            break;
                        }
                        if (state == Status.StatusCommitted) {
                            try {
                                ((TopCoordinator)coord).commit();
                                if (!isRoot[0]) break;
                                ((TopCoordinator)coord).afterCompletion(state);
                            }
                            catch (Throwable throwable) {}
                            break;
                        }
                        try {
                            ((TopCoordinator)coord).rollback(true);
                            if (!isRoot[0]) break;
                            ((TopCoordinator)coord).afterCompletion(Status.StatusRolledBack);
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration checkTimeouts() {
        if (!this.isSetTimeout) {
            return null;
        }
        Enumeration result = null;
        if (this.timeoutActive && (this.pendingTimeouts.size() != 0 || this.indoubtTimeouts.size() != 0)) {
            DelegatedTimeoutInfo timeoutInfo;
            Vector<DelegatedTimeoutInfo> timedOut = null;
            Enumeration timeouts = null;
            Hashtable hashtable = this.pendingTimeouts;
            synchronized (hashtable) {
                timeouts = this.pendingTimeouts.elements();
                while (timeouts.hasMoreElements()) {
                    timeoutInfo = (DelegatedTimeoutInfo)timeouts.nextElement();
                    if (new Date().getTime() <= timeoutInfo.expireTime) continue;
                    if (timedOut == null) {
                        timedOut = new Vector<DelegatedTimeoutInfo>();
                    }
                    timedOut.addElement(timeoutInfo);
                }
            }
            hashtable = this.indoubtTimeouts;
            synchronized (hashtable) {
                timeouts = this.indoubtTimeouts.elements();
                while (timeouts.hasMoreElements()) {
                    timeoutInfo = (DelegatedTimeoutInfo)timeouts.nextElement();
                    if (new Date().getTime() <= timeoutInfo.expireTime) continue;
                    if (timedOut == null) {
                        timedOut = new Vector();
                    }
                    timedOut.addElement(timeoutInfo);
                }
            }
            if (timedOut != null) {
                result = timedOut.elements();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XID[] getInDoubtXids() {
        Hashtable hashtable = this.indoubtTimeouts;
        synchronized (hashtable) {
            Vector<XID> inDoubtList = new Vector<XID>();
            Enumeration timeouts = this.indoubtTimeouts.elements();
            while (timeouts.hasMoreElements()) {
                DelegatedTimeoutInfo timeoutInfo = (DelegatedTimeoutInfo)timeouts.nextElement();
                CoordinatorImpl coord = DelegatedRecoveryManager.getLocalCoordinator(timeoutInfo.localTID, this.logPath);
                if (coord == null) continue;
                XID xid = new XID();
                xid.copy(coord.getGlobalTID());
                inDoubtList.addElement(xid);
            }
            return inDoubtList.toArray(new XID[0]);
        }
    }

    long timeLeft(Long localTID) {
        DelegatedTimeoutInfo timeoutInfo = (DelegatedTimeoutInfo)this.pendingTimeouts.get(localTID);
        if (timeoutInfo == null) {
            timeoutInfo = (DelegatedTimeoutInfo)this.indoubtTimeouts.get(localTID);
        }
        long result = -1L;
        if (timeoutInfo != null && (result = timeoutInfo.expireTime - new Date().getTime()) < 0L) {
            result = 0L;
        }
        return result;
    }

    void shutdown(boolean immediate) {
        if (immediate || this.pendingTimeouts == null || this.pendingTimeouts.isEmpty()) {
            if (this.timeoutThread != null) {
                this.timeoutThread.stop();
            }
            if (this.pendingTimeouts != null) {
                this.pendingTimeouts.clear();
            }
            this.pendingTimeouts = null;
            this.timeoutThread = null;
            this.timeoutActive = false;
        } else {
            this.quiescing = true;
        }
    }
}

