/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.factory;

import com.sun.jaspic.config.factory.EntryInfo;
import com.sun.jaspic.config.factory.RegStoreFileParser;
import com.sun.jaspic.config.factory.RegistrationContextImpl;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;

public abstract class BaseAuthConfigFactory
extends AuthConfigFactory {
    private static final Logger logger = Logger.getLogger("enterprise.system.jaspic.security", "com.sun.logging.enterprise.system.jaspic.security.LogStrings");
    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    public static final Lock rLock = rwLock.readLock();
    public static final Lock wLock = rwLock.writeLock();
    private static Map<String, AuthConfigProvider> id2ProviderMap;
    private static Map<String, AuthConfigFactory.RegistrationContext> id2RegisContextMap;
    private static Map<String, List<RegistrationListener>> id2RegisListenersMap;
    private static Map<AuthConfigProvider, List<String>> provider2IdsMap;
    protected static final String CONF_FILE_NAME = "auth.conf";

    protected abstract RegStoreFileParser getRegStore();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        AuthConfigProvider provider = null;
        if (listener == null) {
            rLock.lock();
            try {
                provider = this.getConfigProviderUnderLock(layer, appContext, null);
            }
            finally {
                rLock.unlock();
            }
        }
        wLock.lock();
        try {
            provider = this.getConfigProviderUnderLock(layer, appContext, listener);
        }
        finally {
            wLock.unlock();
        }
        return provider;
    }

    @Override
    public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(AuthConfigFactory.providerRegistrationSecurityPermission);
        }
        AuthConfigProvider provider = BaseAuthConfigFactory._constructProvider(className, properties, null);
        return this._register(provider, properties, layer, appContext, description, true);
    }

    @Override
    public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(AuthConfigFactory.providerRegistrationSecurityPermission);
        }
        return this._register(provider, null, layer, appContext, description, false);
    }

    @Override
    public boolean removeRegistration(String registrationID) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(AuthConfigFactory.providerRegistrationSecurityPermission);
        }
        return this._unRegister(registrationID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] detachListener(RegistrationListener listener, String layer, String appContext) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(AuthConfigFactory.providerRegistrationSecurityPermission);
        }
        ArrayList<String> list = new ArrayList<String>();
        String regisID = BaseAuthConfigFactory.getRegistrationID(layer, appContext);
        wLock.lock();
        try {
            Set<String> targets = id2RegisListenersMap.keySet();
            for (String targetID : targets) {
                List<RegistrationListener> listeners;
                if (!BaseAuthConfigFactory.regIdImplies(regisID, targetID) || (listeners = id2RegisListenersMap.get(targetID)) == null || !listeners.remove(listener)) continue;
                list.add(targetID);
            }
        }
        finally {
            wLock.unlock();
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getRegistrationIDs(AuthConfigProvider provider) {
        rLock.lock();
        try {
            HashSet<String> regisIDs = null;
            if (provider != null) {
                regisIDs = (HashSet<String>)((Object)provider2IdsMap.get(provider));
            } else {
                Collection<List<String>> collList = provider2IdsMap.values();
                if (collList != null) {
                    regisIDs = new HashSet<String>();
                    for (List<String> listIds : collList) {
                        if (listIds == null) continue;
                        regisIDs.addAll(listIds);
                    }
                }
            }
            String[] stringArray = regisIDs != null ? regisIDs.toArray(new String[regisIDs.size()]) : new String[]{};
            return stringArray;
        }
        finally {
            rLock.unlock();
        }
    }

    @Override
    public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        rLock.lock();
        try {
            AuthConfigFactory.RegistrationContext registrationContext = id2RegisContextMap.get(registrationID);
            return registrationContext;
        }
        finally {
            rLock.unlock();
        }
    }

    @Override
    public void refresh() {
        Map<String, List<RegistrationListener>> preExistingListenersMap;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(AuthConfigFactory.providerRegistrationSecurityPermission);
        }
        wLock.lock();
        try {
            preExistingListenersMap = id2RegisListenersMap;
            this._loadFactory();
        }
        finally {
            wLock.unlock();
        }
        if (preExistingListenersMap != null) {
            BaseAuthConfigFactory.notifyListeners(preExistingListenersMap);
        }
    }

    private AuthConfigProvider getConfigProviderUnderLock(String layer, String appContext, RegistrationListener listener) {
        AuthConfigProvider provider = null;
        String regisID = BaseAuthConfigFactory.getRegistrationID(layer, appContext);
        String matchedID = null;
        boolean providerFound = false;
        if (id2ProviderMap.containsKey(regisID)) {
            provider = id2ProviderMap.get(regisID);
            providerFound = true;
        }
        if (!providerFound && id2ProviderMap.containsKey(matchedID = BaseAuthConfigFactory.getRegistrationID(null, appContext))) {
            provider = id2ProviderMap.get(matchedID);
            providerFound = true;
        }
        if (!providerFound && id2ProviderMap.containsKey(matchedID = BaseAuthConfigFactory.getRegistrationID(layer, null))) {
            provider = id2ProviderMap.get(matchedID);
            providerFound = true;
        }
        if (!providerFound && id2ProviderMap.containsKey(matchedID = BaseAuthConfigFactory.getRegistrationID(null, null))) {
            provider = id2ProviderMap.get(matchedID);
        }
        if (listener != null) {
            List<RegistrationListener> listeners = id2RegisListenersMap.get(regisID);
            if (listeners == null) {
                listeners = new ArrayList<RegistrationListener>();
                id2RegisListenersMap.put(regisID, listeners);
            }
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
        return provider;
    }

    private static String getRegistrationID(String layer, String appContext) {
        String regisID = null;
        regisID = layer != null ? (appContext != null ? "__3" + layer.length() + "_" + layer + appContext : "__2" + layer) : (appContext != null ? "__1" + appContext : "__0");
        return regisID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] decomposeRegisID(String regisID) {
        int n;
        String layer = null;
        String appContext = null;
        if (regisID.equals("__0")) return new String[]{layer, appContext};
        if (regisID.startsWith("__1")) {
            appContext = regisID.length() == 3 ? "" : regisID.substring(3);
            return new String[]{layer, appContext};
        }
        if (regisID.startsWith("__2")) {
            layer = regisID.length() == 3 ? "" : regisID.substring(3);
            return new String[]{layer, appContext};
        }
        if (!regisID.startsWith("__3")) throw new IllegalArgumentException();
        int ind = regisID.indexOf(95, 3);
        if (regisID.length() <= 3 || ind <= 0) throw new IllegalArgumentException();
        String numberString = regisID.substring(3, ind);
        try {
            n = Integer.parseInt(numberString);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
        layer = regisID.substring(ind + 1, ind + 1 + n);
        appContext = regisID.substring(ind + 1 + n);
        return new String[]{layer, appContext};
    }

    private static AuthConfigProvider _constructProvider(String className, Map properties, AuthConfigFactory factory) {
        AuthConfigProvider provider = null;
        if (className != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> c = Class.forName(className, true, loader);
                Constructor<?> constr = c.getConstructor(Map.class, AuthConfigFactory.class);
                provider = (AuthConfigProvider)constr.newInstance(properties, factory);
            }
            catch (Throwable t) {
                Throwable cause = t.getCause();
                logger.log(Level.WARNING, "jmac.factory_unable_to_load_provider", new Object[]{className, t.toString(), cause == null ? "cannot determine" : cause.toString()});
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _register(AuthConfigProvider provider, Map<String, Object> properties, String layer, String appContext, String description, boolean persistent) {
        Map<String, List<RegistrationListener>> listenerMap;
        String regisID = BaseAuthConfigFactory.getRegistrationID(layer, appContext);
        RegistrationContextImpl rc = new RegistrationContextImpl(layer, appContext, description, persistent);
        AuthConfigFactory.RegistrationContext prevRegisContext = null;
        wLock.lock();
        try {
            prevRegisContext = id2RegisContextMap.get(regisID);
            AuthConfigProvider prevProvider = id2ProviderMap.get(regisID);
            if (persistent) {
                this._storeRegistration(regisID, rc, provider, properties);
            } else if (prevRegisContext != null && prevRegisContext.isPersistent()) {
                this._deleteStoredRegistration(regisID, prevRegisContext);
            }
            boolean wasRegistered = id2ProviderMap.containsKey(regisID);
            if (wasRegistered) {
                List<String> prevRegisIDs = provider2IdsMap.get(prevProvider);
                prevRegisIDs.remove(regisID);
                if (prevRegisIDs.isEmpty()) {
                    provider2IdsMap.remove(prevProvider);
                }
            }
            id2ProviderMap.put(regisID, provider);
            id2RegisContextMap.put(regisID, rc);
            List<String> regisIDs = provider2IdsMap.get(provider);
            if (regisIDs == null) {
                regisIDs = new ArrayList<String>();
                provider2IdsMap.put(provider, regisIDs);
            }
            if (!regisIDs.contains(regisID)) {
                regisIDs.add(regisID);
            }
            listenerMap = BaseAuthConfigFactory.getEffectedListeners(regisID);
        }
        finally {
            wLock.unlock();
        }
        BaseAuthConfigFactory.notifyListeners(listenerMap);
        return regisID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _unRegister(String regisID) {
        Map<String, List<RegistrationListener>> listenerMap;
        boolean rvalue = false;
        AuthConfigFactory.RegistrationContext rc = null;
        wLock.lock();
        try {
            rc = id2RegisContextMap.remove(regisID);
            rvalue = id2ProviderMap.containsKey(regisID);
            AuthConfigProvider provider = id2ProviderMap.remove(regisID);
            List<String> regisIDs = provider2IdsMap.get(provider);
            if (regisIDs != null) {
                regisIDs.remove(regisID);
            }
            if (regisIDs == null || regisIDs.isEmpty()) {
                provider2IdsMap.remove(provider);
            }
            if (!rvalue) {
                boolean bl = false;
                return bl;
            }
            listenerMap = BaseAuthConfigFactory.getEffectedListeners(regisID);
            if (rc != null && rc.isPersistent()) {
                this._deleteStoredRegistration(regisID, rc);
            }
        }
        finally {
            wLock.unlock();
        }
        BaseAuthConfigFactory.notifyListeners(listenerMap);
        return rvalue;
    }

    protected void _loadFactory() {
        block6: {
            try {
                BaseAuthConfigFactory.initializeMaps();
                List<EntryInfo> entryList = this.getRegStore().getPersistedEntries();
                for (EntryInfo info : entryList) {
                    if (info.isConstructorEntry()) {
                        BaseAuthConfigFactory._constructProvider(info.getClassName(), info.getProperties(), this);
                        continue;
                    }
                    boolean first = true;
                    AuthConfigProvider p = null;
                    List<AuthConfigFactory.RegistrationContext> contexts = info.getRegContexts();
                    for (AuthConfigFactory.RegistrationContext ctx : contexts) {
                        if (first) {
                            p = BaseAuthConfigFactory._constructProvider(info.getClassName(), info.getProperties(), null);
                        }
                        BaseAuthConfigFactory._loadRegistration(p, ctx.getMessageLayer(), ctx.getAppContext(), ctx.getDescription());
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block6;
                logger.log(Level.WARNING, "jmac.factory_auth_config_loader_failure", e);
            }
        }
    }

    private static void initializeMaps() {
        id2ProviderMap = new HashMap<String, AuthConfigProvider>();
        id2RegisContextMap = new HashMap<String, AuthConfigFactory.RegistrationContext>();
        id2RegisListenersMap = new HashMap<String, List<RegistrationListener>>();
        provider2IdsMap = new HashMap<AuthConfigProvider, List<String>>();
    }

    private static String _loadRegistration(AuthConfigProvider provider, String layer, String appContext, String description) {
        RegistrationContextImpl rc = new RegistrationContextImpl(layer, appContext, description, true);
        String regisID = BaseAuthConfigFactory.getRegistrationID(layer, appContext);
        id2RegisContextMap.get(regisID);
        AuthConfigProvider prevProvider = id2ProviderMap.get(regisID);
        boolean wasRegistered = id2ProviderMap.containsKey(regisID);
        if (wasRegistered) {
            List<String> prevRegisIDs = provider2IdsMap.get(prevProvider);
            prevRegisIDs.remove(regisID);
            if (prevRegisIDs.isEmpty()) {
                provider2IdsMap.remove(prevProvider);
            }
        }
        id2ProviderMap.put(regisID, provider);
        id2RegisContextMap.put(regisID, rc);
        List<String> regisIDs = provider2IdsMap.get(provider);
        if (regisIDs == null) {
            regisIDs = new ArrayList<String>();
            provider2IdsMap.put(provider, regisIDs);
        }
        if (!regisIDs.contains(regisID)) {
            regisIDs.add(regisID);
        }
        return regisID;
    }

    private void _storeRegistration(String regId, AuthConfigFactory.RegistrationContext ctx, AuthConfigProvider p, Map properties) {
        String className = null;
        if (p != null) {
            className = p.getClass().getName();
        }
        if (this.propertiesContainAnyNonStringValues(properties)) {
            throw new IllegalArgumentException("AuthConfigProvider cannot be registered - properties must all be of type String.");
        }
        if (ctx.isPersistent()) {
            this.getRegStore().store(className, ctx, properties);
        }
    }

    private boolean propertiesContainAnyNonStringValues(Map<String, Object> props) {
        if (props != null) {
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                if (entry.getValue() instanceof String) continue;
                return true;
            }
        }
        return false;
    }

    private void _deleteStoredRegistration(String regId, AuthConfigFactory.RegistrationContext ctx) {
        if (ctx.isPersistent()) {
            this.getRegStore().delete(ctx);
        }
    }

    private static boolean regIdImplies(String reference, String target) {
        boolean rvalue = true;
        String[] refID = BaseAuthConfigFactory.decomposeRegisID(reference);
        String[] targetID = BaseAuthConfigFactory.decomposeRegisID(target);
        if (refID[0] != null && !refID[0].equals(targetID[0])) {
            rvalue = false;
        } else if (refID[1] != null && !refID[1].equals(targetID[1])) {
            rvalue = false;
        }
        return rvalue;
    }

    private static Map<String, List<RegistrationListener>> getEffectedListeners(String regisID) {
        HashMap<String, List<RegistrationListener>> effectedListeners = new HashMap<String, List<RegistrationListener>>();
        HashSet<String> listenerRegistrations = new HashSet<String>(id2RegisListenersMap.keySet());
        for (String listenerID : listenerRegistrations) {
            if (!BaseAuthConfigFactory.regIdImplies(regisID, listenerID)) continue;
            if (!effectedListeners.containsKey(listenerID)) {
                effectedListeners.put(listenerID, new ArrayList());
            }
            ((List)effectedListeners.get(listenerID)).addAll((Collection)id2RegisListenersMap.remove(listenerID));
        }
        return effectedListeners;
    }

    private static void notifyListeners(Map<String, List<RegistrationListener>> map) {
        Set<Map.Entry<String, List<RegistrationListener>>> entrySet = map.entrySet();
        for (Map.Entry<String, List<RegistrationListener>> entry : entrySet) {
            List<RegistrationListener> listeners = map.get(entry.getKey());
            if (listeners == null || listeners.size() <= 0) continue;
            String[] dIds = BaseAuthConfigFactory.decomposeRegisID(entry.getKey());
            for (RegistrationListener listener : listeners) {
                listener.notify(dIds[0], dIds[1]);
            }
        }
    }
}

