/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.container.common.spi.JCDIService;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.server.logging.LoggingRuntime;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.services.impl.ContainerMapper;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.web.AdHocServletInfo;
import com.sun.enterprise.web.AdHocWebModule;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.ProxyHandlerImpl;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.enterprise.web.WebConnector;
import com.sun.enterprise.web.WebDeployer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.WebPipeline;
import com.sun.enterprise.web.connector.coyote.PECoyoteConnector;
import com.sun.enterprise.web.logger.FileLoggerHandlerFactory;
import com.sun.enterprise.web.logger.IASLogger;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.web.reconfig.WebConfigListener;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.BindException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.tagext.JspTag;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.xmlparser.ParserUtils;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Container;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.web.TldProvider;
import org.glassfish.grizzly.config.ContextRootInfo;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.grizzly.ContextMapper;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.web.admin.monitor.HttpServiceStatsProviderBootstrap;
import org.glassfish.web.admin.monitor.JspProbeProvider;
import org.glassfish.web.admin.monitor.RequestProbeProvider;
import org.glassfish.web.admin.monitor.ServletProbeProvider;
import org.glassfish.web.admin.monitor.SessionProbeProvider;
import org.glassfish.web.admin.monitor.WebModuleProbeProvider;
import org.glassfish.web.admin.monitor.WebStatsProviderBootstrap;
import org.glassfish.web.config.serverbeans.SessionProperties;
import org.glassfish.web.deployment.archivist.WebArchivist;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.glassfish.web.deployment.runtime.SunWebAppImpl;
import org.glassfish.web.deployment.util.WebValidatorWithoutCL;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.types.Property;
import org.xml.sax.EntityResolver;

@Service(name="com.sun.enterprise.web.WebContainer")
@Singleton
public class WebContainer
implements Container,
PostConstruct,
PreDestroy,
org.glassfish.api.event.EventListener {
    public static final String DISPATCHER_MAX_DEPTH = "dispatcher-max-depth";
    public static final String JWS_APPCLIENT_EAR_NAME = "__JWSappclients";
    public static final String JWS_APPCLIENT_WAR_NAME = "sys";
    private static final String JWS_APPCLIENT_MODULE_NAME = "__JWSappclients:sys.war";
    private static final String DOL_DEPLOYMENT = "com.sun.enterprise.web.deployment.backend";
    private static final String MONITORING_NODE_SEPARATOR = "/";
    @LogMessagesResourceBundle
    public static final String SHARED_LOGMESSAGE_RESOURCE = "com.sun.enterprise.web.LogMessages";
    @LoggerInfo(subsystem="WEB", description="Main WEB Logger", publish=true)
    public static final String WEB_MAIN_LOGGER = "javax.enterprise.web";
    public static final Logger logger = Logger.getLogger("javax.enterprise.web", "com.sun.enterprise.web.LogMessages");
    public static final ResourceBundle rb = logger.getResourceBundle();
    @LogMessageInfo(message="Loading web module {0} in virtual server {1} at {2}", level="INFO")
    public static final String WEB_MODULE_LOADING = "AS-WEB-GLUE-00177";
    @LogMessageInfo(message="This web container has not yet been started", level="INFO")
    public static final String WEB_CONTAINER_NOT_STARTED = "AS-WEB-GLUE-00178";
    @LogMessageInfo(message="Property {0} is not yet supported", level="INFO")
    public static final String PROPERTY_NOT_YET_SUPPORTED = "AS-WEB-GLUE-00179";
    @LogMessageInfo(message="Virtual server {0} already has a web module {1} loaded at {2} therefore web module {3} cannot be loaded at this context path on this virtual server", level="INFO")
    public static final String DUPLICATE_CONTEXT_ROOT = "AS-WEB-GLUE-00180";
    @LogMessageInfo(message="Unable to stop web container", level="SEVERE", cause="Web container may not have been started", action="Verify if web container is started")
    public static final String UNABLE_TO_STOP_WEB_CONTAINER = "AS-WEB-GLUE-00181";
    @LogMessageInfo(message="Unable to start web container", level="SEVERE", cause="Web container may have already been started", action="Verify if web container is not already started")
    public static final String UNABLE_TO_START_WEB_CONTAINER = "AS-WEB-GLUE-00182";
    @LogMessageInfo(message="Property element in sun-web.xml has null 'name' or 'value'", level="INFO")
    public static final String NULL_WEB_PROPERTY = "AS-WEB-GLUE-00183";
    @LogMessageInfo(message="Web module {0} is not loaded in virtual server {1}", level="SEVERE", cause="Web module has failed to load", action="Verify if web module is valid")
    public static final String WEB_MODULE_NOT_LOADED_TO_VS = "AS-WEB-GLUE-00184";
    @LogMessageInfo(message="Unable to deploy web module {0} at root context of virtual server {1}, because this virtual server declares a default-web-module", level="INFO")
    public static final String DEFAULT_WEB_MODULE_CONFLICT = "AS-WEB-GLUE-00185";
    @LogMessageInfo(message="Unable to set default-web-module {0} for virtual server {1}", level="SEVERE", cause="There is no web context deployed on the givenvirtual server that matches the given default context path", action="Verify if the default context path is deployed on the virtual server")
    public static final String DEFAULT_WEB_MODULE_ERROR = "AS-WEB-GLUE-00186";
    @LogMessageInfo(message="Unable to load web module {0} at context root {1}, because it is not correctly encoded", level="INFO")
    public static final String INVALID_ENCODED_CONTEXT_ROOT = "AS-WEB-GLUE-00187";
    @LogMessageInfo(message="Unable to destroy web module deployed at context root {0} on virtual server {1} during undeployment", level="WARNING")
    public static final String EXCEPTION_DURING_DESTROY = "AS-WEB-GLUE-00188";
    @LogMessageInfo(message="Exception setting the schemas/dtds location", level="SEVERE", cause="A malformed URL has occurred. Either no legal protocol could be found in a specification string or the string could not be parsed", action="Verify if the schemas and dtds")
    public static final String EXCEPTION_SET_SCHEMAS_DTDS_LOCATION = "AS-WEB-GLUE-00189";
    @LogMessageInfo(message="Error loading web module {0}", level="SEVERE", cause="An error occurred during loading web module", action="Check the Exception for the error")
    public static final String LOAD_WEB_MODULE_ERROR = "AS-WEB-GLUE-00191";
    @LogMessageInfo(message="Undeployment failed for context {0}", level="SEVERE", cause="The context may not have been deployed", action="Verify if the context is deployed on the virtual server")
    public static final String UNDEPLOY_ERROR = "AS-WEB-GLUE-00192";
    @LogMessageInfo(message="Exception processing HttpService configuration change", level="SEVERE", cause="An error occurred during configurting http service", action="Verify if the configurations are valid")
    public static final String EXCEPTION_CONFIG_HTTP_SERVICE = "AS-WEB-GLUE-00193";
    @LogMessageInfo(message="Unable to set context root {0}", level="WARNING")
    public static final String UNABLE_TO_SET_CONTEXT_ROOT = "AS-WEB-GLUE-00194";
    @LogMessageInfo(message="Unable to disable web module at context root {0}", level="WARNING")
    public static final String DISABLE_WEB_MODULE_ERROR = "AS-WEB-GLUE-00195";
    @LogMessageInfo(message="Error during destruction of virtual server {0}", level="WARNING")
    public static final String DESTROY_VS_ERROR = "AS-WEB-GLUE-00196";
    @LogMessageInfo(message="Virtual server {0} cannot be updated, because it does not exist", level="WARNING")
    public static final String CANNOT_UPDATE_NON_EXISTENCE_VS = "AS-WEB-GLUE-00197";
    @LogMessageInfo(message="Created HTTP listener {0} on host/port {1}:{2}", level="INFO")
    public static final String HTTP_LISTENER_CREATED = "AS-WEB-GLUE-00198";
    @LogMessageInfo(message="Created JK listener {0} on host/port {1}:{2}", level="INFO")
    public static final String JK_LISTENER_CREATED = "AS-WEB-GLUE-00199";
    @LogMessageInfo(message="Created virtual server {0}", level="INFO")
    public static final String VIRTUAL_SERVER_CREATED = "AS-WEB-GLUE-00200";
    @LogMessageInfo(message="Virtual server {0} loaded default web module {1}", level="INFO")
    public static final String VIRTUAL_SERVER_LOADED_DEFAULT_WEB_MODULE = "AS-WEB-GLUE-00201";
    @LogMessageInfo(message="Maximum depth for nested request dispatches set to {0}", level="FINE")
    public static final String MAX_DISPATCH_DEPTH_SET = "AS-WEB-GLUE-00202";
    @LogMessageInfo(message="Unsupported http-service property {0} is being ignored", level="WARNING")
    public static final String INVALID_HTTP_SERVICE_PROPERTY = "AS-WEB-GLUE-00203";
    @LogMessageInfo(message="The host name {0} is shared by virtual servers {1} and {2}, which are both associated with the same HTTP listener {3}", level="SEVERE", cause="The host name is not unique", action="Verify that the host name is unique")
    public static final String DUPLICATE_HOST_NAME = "AS-WEB-GLUE-00204";
    @LogMessageInfo(message="Network listener {0} referenced by virtual server {1} does not exist", level="SEVERE", cause="Network listener {0} referenced by virtual server {1} does not exist", action="Verify that the network listener is valid")
    public static final String LISTENER_REFERENCED_BY_HOST_NOT_EXIST = "AS-WEB-GLUE-00205";
    @LogMessageInfo(message="Web module {0} not loaded to any virtual servers", level="INFO")
    public static final String WEB_MODULE_NOT_LOADED_NO_VIRTUAL_SERVERS = "AS-WEB-GLUE-00206";
    @LogMessageInfo(message="Loading web module {0} to virtual servers {1}", level="FINE")
    public static final String LOADING_WEB_MODULE = "AS-WEB-GLUE-00207";
    @LogMessageInfo(message="Unloading web module {0} from virtual servers {1}", level="FINE")
    public static final String UNLOADING_WEB_MODULE = "AS-WEB-GLUE-00208";
    @LogMessageInfo(message="Context {0} undeployed from virtual server {1}", level="FINE")
    public static final String CONTEXT_UNDEPLOYED = "AS-WEB-GLUE-00209";
    @LogMessageInfo(message="Context {0} disabled from virtual server {1}", level="FINE")
    public static final String CONTEXT_DISABLED = "AS-WEB-GLUE-00210";
    @LogMessageInfo(message="Virtual server {0}'s network listeners are updated from {1} to {2}", level="FINE")
    public static final String VS_UPDATED_NETWORK_LISTENERS = "AS-WEB-GLUE-00211";
    @LogMessageInfo(message="The class {0} is annotated with an invalid scope", level="INFO")
    public static final String INVALID_ANNOTATION_SCOPE = "AS-WEB-GLUE-00212";
    @LogMessageInfo(message="-DjvmRoute updated with {0}", level="FINE")
    public static final String JVM_ROUTE_UPDATED = "AS-WEB-GLUE-00213";
    @LogMessageInfo(message="Unable to parse port number {0} of network-listener {1}", level="INFO")
    public static final String HTTP_LISTENER_INVALID_PORT = "AS-WEB-GLUE-00214";
    @LogMessageInfo(message="Virtual server {0} set listener name {1}", level="FINE")
    public static final String VIRTUAL_SERVER_SET_LISTENER_NAME = "AS-WEB-GLUE-00215";
    @LogMessageInfo(message="Must not disable network-listener {0}, because it is associated with admin virtual server {1}", level="INFO")
    public static final String MUST_NOT_DISABLE = "AS-WEB-GLUE-00216";
    @LogMessageInfo(message="Virtual server {0} set jk listener name {1}", level="FINE")
    public static final String VIRTUAL_SERVER_SET_JK_LISTENER_NAME = "AS-WEB-GLUE-00217";
    @LogMessageInfo(message="virtual server {0} has an invalid docroot {1}", level="INFO")
    public static final String VIRTUAL_SERVER_INVALID_DOCROOT = "AS-WEB-GLUE-00218";
    @LogMessageInfo(message="{0} network listener is not included in {1} and will be updated ", level="FINE")
    public static final String UPDATE_LISTENER = "AS-WEB-GLUE-00219";
    static boolean useDOLforDeployment = true;
    @Inject
    private ApplicationRegistry appRegistry;
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    private ComponentEnvManager componentEnvManager;
    @Inject
    private Configs configs;
    @Inject
    @Optional
    private DasConfig dasConfig;
    @Inject
    private Domain domain;
    @Inject
    private Events events;
    @Inject
    private FileLoggerHandlerFactory fileLoggerHandlerFactory;
    @Inject
    private GrizzlyService grizzlyService;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private JavaEEIOUtils javaEEIOUtils;
    @Inject
    @Optional
    private JCDIService jcdiService;
    @Inject
    @Named(value="default-instance-name")
    private Config serverConfig;
    @Inject
    @Named(value="default-instance-name")
    private Server server;
    @Inject
    private ServerContext _serverContext;
    @Inject
    private Transactions transactions;
    @Inject
    private LoggingRuntime loggingRuntime;
    private HashMap<String, WebConnector> connectorMap = new HashMap();
    private EmbeddedWebContainer _embedded;
    private Engine engine;
    private String instanceName;
    private WebConnector jkConnector;
    private String logLevel = "INFO";
    protected boolean globalAccessLoggingEnabled = true;
    protected String globalAccessLogBufferSize = null;
    protected String globalAccessLogWriteInterval = null;
    protected int defaultRedirectPort = -1;
    @Inject
    protected ServerEnvironment instance = null;
    private Server _serverBean = null;
    protected int _debug = 0;
    private String _modulesWorkRoot = null;
    protected File _modulesRoot = null;
    private String _appsWorkRoot = null;
    private String appsStubRoot = null;
    private boolean _reloadingEnabled = false;
    private int _pollInterval = 2;
    protected boolean _started = false;
    protected boolean globalSSOEnabled = true;
    protected volatile WebContainerFeatureFactory webContainerFeatureFactory;
    boolean instanceEnableCookies = true;
    @Inject
    ServerConfigLookup serverConfigLookup;
    protected JspProbeProvider jspProbeProvider = null;
    protected RequestProbeProvider requestProbeProvider = null;
    protected ServletProbeProvider servletProbeProvider = null;
    protected SessionProbeProvider sessionProbeProvider = null;
    protected WebModuleProbeProvider webModuleProbeProvider = null;
    protected WebConfigListener configListener = null;
    private boolean isShutdown = false;
    private final Object mapperUpdateSync = new Object();
    private SecurityService securityService = null;
    protected HttpServiceStatsProviderBootstrap httpStatsProviderBootstrap = null;
    private WebStatsProviderBootstrap webStatsProviderBootstrap = null;
    private InjectionManager injectionMgr;
    private InvocationManager invocationMgr;
    private Collection<TldProvider> tldProviders;
    private String logServiceFile = null;

    private WebConfigListener addAndGetWebConfigListener() {
        ServiceLocator locator = this.habitat;
        DynamicConfigurationService dcs = locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addActiveDescriptor(WebConfigListener.class);
        config.commit();
        return locator.getService(WebConfigListener.class, new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postConstruct() {
        ReentrantReadWriteLock mapperLock = this.grizzlyService.obtainMapperLock();
        mapperLock.writeLock().lock();
        try {
            Level level;
            File currentLogFile;
            this.createProbeProviders();
            this.injectionMgr = this.habitat.getService(InjectionManager.class, new Annotation[0]);
            this.invocationMgr = this.habitat.getService(InvocationManager.class, new Annotation[0]);
            this.tldProviders = this.habitat.getAllServices(TldProvider.class, new Annotation[0]);
            this.createStatsProviders();
            WebContainer.setJspFactory();
            this._appsWorkRoot = this.instance.getApplicationCompileJspPath().getAbsolutePath();
            this._modulesRoot = this.instance.getApplicationRepositoryPath();
            this.appsStubRoot = this.instance.getApplicationStubPath().getAbsolutePath();
            File root = this._serverContext.getInstallRoot();
            File libRoot = new File(root, "lib");
            File schemas = new File(libRoot, "schemas");
            File dtds = new File(libRoot, "dtds");
            try {
                ParserUtils.setSchemaResourcePrefix(schemas.toURI().toURL().toString());
                ParserUtils.setDtdResourcePrefix(dtds.toURI().toURL().toString());
                ParserUtils.setEntityResolver(this.habitat.getService(EntityResolver.class, "web", new Annotation[0]));
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, EXCEPTION_SET_SCHEMAS_DTDS_LOCATION, e);
            }
            this.instanceName = this._serverContext.getInstanceName();
            this.webContainerFeatureFactory = this.getWebContainerFeatureFactory();
            this.configureDynamicReloadingSettings();
            this.setDebugLevel();
            String maxDepth = null;
            org.glassfish.web.config.serverbeans.WebContainer configWC = this.serverConfig.getExtensionByType(org.glassfish.web.config.serverbeans.WebContainer.class);
            if (configWC != null) {
                maxDepth = configWC.getPropertyValue(DISPATCHER_MAX_DEPTH);
            }
            if (maxDepth != null) {
                int depth = -1;
                try {
                    depth = Integer.parseInt(maxDepth);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (depth > 0) {
                    Request.setMaxDispatchDepth(depth);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, MAX_DISPATCH_DEPTH_SET, maxDepth);
                    }
                }
            }
            if ((currentLogFile = this.loggingRuntime.getCurrentLogFile()) != null) {
                this.logServiceFile = currentLogFile.getAbsolutePath();
            }
            if ((level = Logger.getLogger("org.apache.catalina.level").getLevel()) != null) {
                this.logLevel = level.getName();
            }
            this._embedded = this.habitat.getService(EmbeddedWebContainer.class, new Annotation[0]);
            this._embedded.setWebContainer(this);
            this._embedded.setLogServiceFile(this.logServiceFile);
            this._embedded.setLogLevel(this.logLevel);
            this._embedded.setFileLoggerHandlerFactory(this.fileLoggerHandlerFactory);
            this._embedded.setWebContainerFeatureFactory(this.webContainerFeatureFactory);
            this._embedded.setCatalinaHome(this.instance.getDomainRoot().getAbsolutePath());
            this._embedded.setCatalinaBase(this.instance.getDomainRoot().getAbsolutePath());
            this._embedded.setUseNaming(false);
            if (this._debug > 1) {
                this._embedded.setDebug(this._debug);
            }
            this._embedded.setLogger(new IASLogger(logger));
            this.engine = this._embedded.createEngine();
            this.engine.setParentClassLoader(EmbeddedWebContainer.class.getClassLoader());
            this.engine.setService(this._embedded);
            this._embedded.addEngine(this.engine);
            ((StandardEngine)this.engine).setDomain(this._serverContext.getDefaultDomainName());
            this.engine.setName(this._serverContext.getDefaultDomainName());
            String serverInfo = System.getProperty("product.name");
            if (serverInfo == null) {
                ServerInfo.setServerInfo(Version.getVersion());
                ServerInfo.setPublicServerInfo(Version.getVersion());
            } else if (serverInfo.isEmpty()) {
                ServerInfo.setServerInfo(Version.getVersion());
                ServerInfo.setPublicServerInfo(serverInfo);
            } else {
                ServerInfo.setServerInfo(serverInfo);
                ServerInfo.setPublicServerInfo(serverInfo);
            }
            this.initInstanceSessionProperties();
            this.configListener = this.addAndGetWebConfigListener();
            ObservableBean bean = (ObservableBean)((Object)ConfigSupport.getImpl(this.serverConfig.getHttpService()));
            bean.addListener(this.configListener);
            bean = (ObservableBean)((Object)ConfigSupport.getImpl(this.serverConfig.getNetworkConfig().getNetworkListeners()));
            bean.addListener(this.configListener);
            if (this.serverConfig.getAvailabilityService() != null) {
                bean = (ObservableBean)((Object)ConfigSupport.getImpl(this.serverConfig.getAvailabilityService()));
                bean.addListener(this.configListener);
            }
            this.transactions.addListenerForType(SystemProperty.class, this.configListener);
            this.configListener.setNetworkConfig(this.serverConfig.getNetworkConfig());
            if (this.configListener.managerProperties != null) {
                ObservableBean managerBean = (ObservableBean)((Object)ConfigSupport.getImpl(this.configListener.managerProperties));
                managerBean.addListener(this.configListener);
            }
            if (this.serverConfig.getJavaConfig() != null) {
                ((ObservableBean)((Object)ConfigSupport.getImpl(this.serverConfig.getJavaConfig()))).addListener(this.configListener);
            }
            this.configListener.setContainer(this);
            this.configListener.setLogger(logger);
            this.events.register(this);
            this.grizzlyService.addMapperUpdateListener(this.configListener);
            HttpService httpService = this.serverConfig.getHttpService();
            NetworkConfig networkConfig = this.serverConfig.getNetworkConfig();
            if (networkConfig != null) {
                this.securityService = this.serverConfig.getSecurityService();
                NetworkListeners networkListeners = networkConfig.getNetworkListeners();
                if (networkListeners != null) {
                    List<NetworkListener> listeners = networkListeners.getNetworkListener();
                    for (NetworkListener listener : listeners) {
                        this.createHttpListener(listener, httpService);
                    }
                }
                this.setDefaultRedirectPort(this.defaultRedirectPort);
                this.createHosts(httpService, this.securityService);
            }
            this.loadSystemDefaultWebModules();
            this._started = true;
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                ImageIO.getCacheDirectory();
                this._embedded.start();
                Thread.currentThread().setContextClassLoader(current);
            }
            catch (LifecycleException le) {
                try {
                    logger.log(Level.SEVERE, UNABLE_TO_START_WEB_CONTAINER, le);
                    Thread.currentThread().setContextClassLoader(current);
                    mapperLock.writeLock().unlock();
                    return;
                }
                catch (Throwable throwable) {
                    Thread.currentThread().setContextClassLoader(current);
                    throw throwable;
                }
            }
        }
        finally {
            mapperLock.writeLock().unlock();
        }
    }

    @Override
    public void event(EventListener.Event event) {
        if (event.is(Deployment.ALL_APPLICATIONS_PROCESSED)) {
            this.loadDefaultWebModulesAfterAllAppsProcessed();
        } else if (event.is(EventTypes.PREPARE_SHUTDOWN)) {
            this.isShutdown = true;
        }
    }

    void afterServletContextInitializedEvent(WebBundleDescriptor wbd) {
        this.events.send(new EventListener.Event<WebBundleDescriptor>(WebBundleDescriptor.AFTER_SERVLET_CONTEXT_INITIALIZED_EVENT, wbd), false);
    }

    @Override
    public void preDestroy() {
        try {
            for (Connector con : this._embedded.findConnectors()) {
                this.deleteConnector((WebConnector)con);
            }
            this._embedded.removeEngine(this.getEngine());
            this._embedded.destroy();
        }
        catch (LifecycleException le) {
            logger.log(Level.SEVERE, UNABLE_TO_STOP_WEB_CONTAINER, le);
            return;
        }
    }

    JavaEEIOUtils getJavaEEIOUtils() {
        return this.javaEEIOUtils;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    Collection<TldProvider> getTldProviders() {
        return this.tldProviders;
    }

    public ServletProbeProvider getServletProbeProvider() {
        return this.servletProbeProvider;
    }

    public JspProbeProvider getJspProbeProvider() {
        return this.jspProbeProvider;
    }

    public SessionProbeProvider getSessionProbeProvider() {
        return this.sessionProbeProvider;
    }

    public RequestProbeProvider getRequestProbeProvider() {
        return this.requestProbeProvider;
    }

    public WebModuleProbeProvider getWebModuleProbeProvider() {
        return this.webModuleProbeProvider;
    }

    @Override
    public String getName() {
        return "Web";
    }

    public Class<? extends WebDeployer> getDeployer() {
        return WebDeployer.class;
    }

    InvocationManager getInvocationManager() {
        return this.invocationMgr;
    }

    public WebConnector getJkConnector() {
        return this.jkConnector;
    }

    public HashMap<String, WebConnector> getConnectorMap() {
        return this.connectorMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends Servlet> T createServletInstance(WebModule module, Class<T> clazz) throws Exception {
        this.validateJSR299Scope(clazz);
        WebComponentInvocation inv = new WebComponentInvocation(module);
        try {
            this.invocationMgr.preInvoke(inv);
            Servlet servlet = (Servlet)this.injectionMgr.createManagedObject(clazz);
            return (T)servlet;
        }
        finally {
            this.invocationMgr.postInvoke(inv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends Filter> T createFilterInstance(WebModule module, Class<T> clazz) throws Exception {
        this.validateJSR299Scope(clazz);
        WebComponentInvocation inv = new WebComponentInvocation(module);
        try {
            this.invocationMgr.preInvoke(inv);
            Filter filter = (Filter)this.injectionMgr.createManagedObject(clazz);
            return (T)filter;
        }
        finally {
            this.invocationMgr.postInvoke(inv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends EventListener> T createListenerInstance(WebModule module, Class<T> clazz) throws Exception {
        this.validateJSR299Scope(clazz);
        WebComponentInvocation inv = new WebComponentInvocation(module);
        try {
            this.invocationMgr.preInvoke(inv);
            EventListener eventListener = (EventListener)this.injectionMgr.createManagedObject(clazz);
            return (T)eventListener;
        }
        finally {
            this.invocationMgr.postInvoke(inv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends HttpUpgradeHandler> T createHttpUpgradeHandlerInstance(WebModule module, Class<T> clazz) throws Exception {
        this.validateJSR299Scope(clazz);
        WebComponentInvocation inv = new WebComponentInvocation(module);
        try {
            this.invocationMgr.preInvoke(inv);
            HttpUpgradeHandler httpUpgradeHandler = (HttpUpgradeHandler)this.injectionMgr.createManagedObject(clazz);
            return (T)httpUpgradeHandler;
        }
        finally {
            this.invocationMgr.postInvoke(inv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JspTag> T createTagHandlerInstance(WebModule module, Class<T> clazz) throws Exception {
        WebComponentInvocation inv = new WebComponentInvocation(module);
        try {
            this.invocationMgr.preInvoke(inv);
            JspTag jspTag = (JspTag)this.injectionMgr.createManagedObject(clazz);
            return (T)jspTag;
        }
        finally {
            this.invocationMgr.postInvoke(inv);
        }
    }

    protected WebConnector createHttpListener(NetworkListener listener, HttpService httpService) {
        return this.createHttpListener(listener, httpService, null);
    }

    protected WebConnector createHttpListener(NetworkListener listener, HttpService httpService, Mapper mapper) {
        String address;
        boolean isSecure;
        String defaultVS;
        if (!Boolean.valueOf(listener.getEnabled()).booleanValue()) {
            return null;
        }
        int port = 8080;
        this.checkHostnameUniqueness(listener.getName(), httpService);
        try {
            port = Integer.parseInt(listener.getPort());
        }
        catch (NumberFormatException nfe) {
            String msg = rb.getString(HTTP_LISTENER_INVALID_PORT);
            msg = MessageFormat.format(msg, listener.getPort(), listener.getName());
            throw new IllegalArgumentException(msg);
        }
        if (mapper == null) {
            for (Mapper m : this.habitat.getAllServices(Mapper.class, new Annotation[0])) {
                if (m.getPort() != port || !(m instanceof ContextMapper)) continue;
                ContextMapper cm = (ContextMapper)m;
                if (!listener.getName().equals(cm.getId())) continue;
                mapper = m;
                break;
            }
        }
        if (!(defaultVS = listener.findHttpProtocol().getHttp().getDefaultVirtualServer()).equals("__asadmin")) {
            ContextRootInfo r;
            MappingData md;
            block15: {
                DataChunk host = DataChunk.newInstance();
                char[] c = defaultVS.toCharArray();
                host.setChars(c, 0, c.length);
                DataChunk mb = DataChunk.newInstance();
                mb.setChars(new char[]{'/'}, 0, 1);
                md = new MappingData();
                try {
                    mapper.map(host, mb, md);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) break block15;
                    logger.log(Level.FINE, "", e);
                }
            }
            if (md.context != null && md.context instanceof ContextRootInfo && !((r = (ContextRootInfo)md.context).getHttpHandler() instanceof ContainerMapper)) {
                new BindException("Port " + port + " is already used by Container: " + r.getHttpHandler() + " and will not get started.").printStackTrace();
                return null;
            }
        }
        if ((isSecure = Boolean.valueOf(listener.findHttpProtocol().getSecurityEnabled()).booleanValue()) && this.defaultRedirectPort == -1) {
            this.defaultRedirectPort = port;
        }
        if ("any".equals(address = listener.getAddress()) || "ANY".equals(address) || "INADDR_ANY".equals(address)) {
            address = null;
        }
        WebConnector connector = (WebConnector)this._embedded.createConnector(address, port, isSecure);
        connector.setMapper(mapper);
        connector.setJvmRoute(this.engine.getJvmRoute());
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, HTTP_LISTENER_CREATED, new Object[]{listener.getName(), listener.getAddress(), listener.getPort()});
        }
        connector.setDefaultHost(listener.findHttpProtocol().getHttp().getDefaultVirtualServer());
        connector.setName(listener.getName());
        connector.setInstanceName(this.instanceName);
        connector.configure(listener, isSecure, httpService);
        this._embedded.addConnector(connector);
        this.connectorMap.put(listener.getName(), connector);
        String redirectPort = listener.findHttpProtocol().getHttp().getRedirectPort();
        if (redirectPort != null) {
            connector.setRedirectPort(Integer.parseInt(redirectPort));
        } else if (this.defaultRedirectPort != -1) {
            connector.setRedirectPort(this.defaultRedirectPort);
        }
        ObservableBean httpListenerBean = (ObservableBean)((Object)ConfigSupport.getImpl(listener));
        httpListenerBean.addListener(this.configListener);
        return connector;
    }

    protected WebConnector createJKConnector(NetworkListener listener, HttpService httpService) {
        int port = 8009;
        boolean isSecure = false;
        String address = null;
        if (listener == null) {
            String portString = System.getProperty("com.sun.enterprise.web.connector.enableJK");
            if (portString == null) {
                return null;
            }
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException ex) {
                port = 8009;
            }
        } else {
            port = Integer.parseInt(listener.getPort());
            isSecure = Boolean.valueOf(listener.findHttpProtocol().getSecurityEnabled());
            address = listener.getAddress();
        }
        if (isSecure && this.defaultRedirectPort == -1) {
            this.defaultRedirectPort = port;
        }
        if ("any".equals(address) || "ANY".equals(address) || "INADDR_ANY".equals(address)) {
            address = null;
        }
        this.jkConnector = (WebConnector)this._embedded.createConnector(address, port, "ajp");
        this.jkConnector.configureJKProperties(listener);
        String defaultHost = "server";
        String jkConnectorName = "jk-connector";
        if (listener != null) {
            defaultHost = listener.findHttpProtocol().getHttp().getDefaultVirtualServer();
            jkConnectorName = listener.getName();
        }
        this.jkConnector.setDefaultHost(defaultHost);
        this.jkConnector.setName(jkConnectorName);
        this.jkConnector.setDomain(this._serverContext.getDefaultDomainName());
        this.jkConnector.setInstanceName(this.instanceName);
        if (listener != null) {
            this.jkConnector.configure(listener, isSecure, httpService);
            this.connectorMap.put(listener.getName(), this.jkConnector);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, JK_LISTENER_CREATED, new Object[]{listener.getName(), listener.getAddress(), listener.getPort()});
        }
        for (Mapper m : this.habitat.getAllServices(Mapper.class, new Annotation[0])) {
            if (m.getPort() != port || !(m instanceof ContextMapper)) continue;
            ContextMapper cm = (ContextMapper)m;
            if (!listener.getName().equals(cm.getId())) continue;
            this.jkConnector.setMapper(m);
            break;
        }
        this._embedded.addConnector(this.jkConnector);
        return this.jkConnector;
    }

    private void setDefaultRedirectPort(int defaultRedirectPort) {
        if (defaultRedirectPort != -1) {
            Connector[] connectors;
            for (Connector connector : connectors = this._embedded.getConnectors()) {
                if (connector.getRedirectPort() != -1) continue;
                connector.setRedirectPort(defaultRedirectPort);
            }
        }
    }

    public void configureHttpServiceProperties(HttpService httpService, PECoyoteConnector connector) {
        List<Property> httpServiceProps = httpService.getProperty();
        connector.setProxyHandler(new ProxyHandlerImpl());
        this.globalSSOEnabled = ConfigBeansUtilities.toBoolean(httpService.getSsoEnabled());
        this.globalAccessLoggingEnabled = ConfigBeansUtilities.toBoolean(httpService.getAccessLoggingEnabled());
        this.globalAccessLogWriteInterval = httpService.getAccessLog().getWriteIntervalSeconds();
        this.globalAccessLogBufferSize = httpService.getAccessLog().getBufferSizeBytes();
        if (httpServiceProps != null) {
            for (Property httpServiceProp : httpServiceProps) {
                String propValue;
                String propName = httpServiceProp.getName();
                if (connector.configureHttpListenerProperty(propName, propValue = httpServiceProp.getValue())) continue;
                if ("connectionTimeout".equals(propName)) {
                    connector.setConnectionTimeout(Integer.parseInt(propValue));
                    continue;
                }
                if ("tcpNoDelay".equals(propName)) {
                    connector.setTcpNoDelay(ConfigBeansUtilities.toBoolean(propValue));
                    continue;
                }
                if ("traceEnabled".equals(propName)) {
                    connector.setAllowTrace(ConfigBeansUtilities.toBoolean(propValue));
                    continue;
                }
                if ("ssl-session-timeout".equals(propName)) {
                    connector.setSslSessionTimeout(propValue);
                    continue;
                }
                if ("ssl3-session-timeout".equals(propName)) {
                    connector.setSsl3SessionTimeout(propValue);
                    continue;
                }
                if ("ssl-cache-entries".equals(propName)) {
                    connector.setSslSessionCacheSize(propValue);
                    continue;
                }
                if ("proxyHandler".equals(propName)) {
                    connector.setProxyHandler(propValue);
                    continue;
                }
                String msg = rb.getString(INVALID_HTTP_SERVICE_PROPERTY);
                logger.log(Level.WARNING, MessageFormat.format(msg, httpServiceProp.getName()));
            }
        }
    }

    private void checkHostnameUniqueness(String listenerId, HttpService httpService) {
        int j;
        ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer> listenerVses = null;
        block0: for (com.sun.enterprise.config.serverbeans.VirtualServer vse : httpService.getVirtualServer()) {
            List<String> vsListeners = StringUtils.parseStringList(vse.getNetworkListeners(), ",");
            for (j = 0; vsListeners != null && j < vsListeners.size(); ++j) {
                if (!listenerId.equals(vsListeners.get(j))) continue;
                if (listenerVses == null) {
                    listenerVses = new ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer>();
                }
                listenerVses.add(vse);
                continue block0;
            }
        }
        if (listenerVses == null) {
            return;
        }
        for (int i = 0; i < listenerVses.size(); ++i) {
            com.sun.enterprise.config.serverbeans.VirtualServer vs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(i);
            List<String> hosts = StringUtils.parseStringList(vs.getHosts(), ",");
            for (j = 0; hosts != null && j < hosts.size(); ++j) {
                String host = hosts.get(j);
                for (int k = 0; k < listenerVses.size(); ++k) {
                    if (k <= i) continue;
                    com.sun.enterprise.config.serverbeans.VirtualServer otherVs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(k);
                    List<String> otherHosts = StringUtils.parseStringList(otherVs.getHosts(), ",");
                    for (int l = 0; otherHosts != null && l < otherHosts.size(); ++l) {
                        if (!host.equals(otherHosts.get(l))) continue;
                        logger.log(Level.SEVERE, DUPLICATE_HOST_NAME, new Object[]{host, vs.getId(), otherVs.getId(), listenerId});
                    }
                }
            }
        }
    }

    protected void createHosts(HttpService httpService, SecurityService securityService) {
        List<com.sun.enterprise.config.serverbeans.VirtualServer> virtualServers = httpService.getVirtualServer();
        for (com.sun.enterprise.config.serverbeans.VirtualServer vs : virtualServers) {
            this.createHost(vs, httpService, securityService);
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.log(Level.INFO, VIRTUAL_SERVER_CREATED, vs.getId());
        }
    }

    public VirtualServer createHost(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, HttpService httpService, SecurityService securityService) {
        PEAccessLogValve accessLogValve;
        boolean startAccessLog;
        String vs_id = vsBean.getId();
        String docroot = vsBean.getPropertyValue("docroot");
        if (docroot == null) {
            docroot = vsBean.getDocroot();
        }
        this.validateDocroot(docroot, vs_id, vsBean.getDefaultWebModule());
        VirtualServer vs = this.createHost(vs_id, vsBean, docroot, null);
        Property cacheProp = vsBean.getProperty("setCacheControl");
        if (cacheProp != null) {
            vs.configureCacheControl(cacheProp.getValue());
        }
        if ((startAccessLog = (accessLogValve = vs.getAccessLogValve()).configure(vs_id, vsBean, httpService, this.domain, this.habitat, this.webContainerFeatureFactory, this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval)) && vs.isAccessLoggingEnabled(this.globalAccessLoggingEnabled)) {
            vs.addValve(accessLogValve);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, VIRTUAL_SERVER_CREATED, vs_id);
        }
        this.configureHost(vs, securityService);
        vs.setDomain(this.domain);
        vs.setServices(this.habitat);
        vs.setClassLoaderHierarchy(this.clh);
        this.engine.addChild(vs);
        ObservableBean virtualServerBean = (ObservableBean)((Object)ConfigSupport.getImpl(vsBean));
        virtualServerBean.addListener(this.configListener);
        return vs;
    }

    protected void validateDocroot(String docroot, String vs_id, String defaultWebModule) {
        if (docroot == null) {
            return;
        }
        boolean isValid = new File(docroot).exists();
        if (!isValid) {
            String msg = rb.getString(VIRTUAL_SERVER_INVALID_DOCROOT);
            msg = MessageFormat.format(msg, vs_id, docroot);
            throw new IllegalArgumentException(msg);
        }
    }

    protected void configureHost(VirtualServer vs, SecurityService securityService) {
        com.sun.enterprise.config.serverbeans.VirtualServer vsBean = vs.getBean();
        vs.configureAliases();
        List<String> listeners = StringUtils.parseStringList(vsBean.getNetworkListeners(), ",");
        if (listeners == null) {
            return;
        }
        HashSet<NetworkListener> httpListeners = new HashSet<NetworkListener>();
        for (String listener : listeners) {
            boolean found = false;
            for (NetworkListener httpListener : this.serverConfig.getNetworkConfig().getNetworkListeners().getNetworkListener()) {
                if (!httpListener.getName().equals(listener)) continue;
                httpListeners.add(httpListener);
                found = true;
                break;
            }
            if (found) continue;
            String msg = rb.getString(LISTENER_REFERENCED_BY_HOST_NOT_EXIST);
            msg = MessageFormat.format(msg, listener, vs.getName());
            logger.log(Level.SEVERE, msg);
        }
        this.configureHostPortNumbers(vs, httpListeners);
        vs.configureCatalinaProperties();
        vs.configureAuthRealm(securityService);
        vs.addProbes(this.globalAccessLoggingEnabled);
    }

    protected void configureHostPortNumbers(VirtualServer vs, HashSet<NetworkListener> listeners) {
        boolean addJkListenerName = this.jkConnector != null && !vs.getName().equalsIgnoreCase("__asadmin");
        ArrayList<String> listenerNames = new ArrayList<String>();
        for (NetworkListener listener : listeners) {
            if (Boolean.valueOf(listener.getEnabled()).booleanValue()) {
                listenerNames.add(listener.getName());
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, VIRTUAL_SERVER_SET_LISTENER_NAME);
                continue;
            }
            if (!vs.getName().equalsIgnoreCase("__asadmin")) continue;
            String msg = rb.getString(MUST_NOT_DISABLE);
            msg = MessageFormat.format(msg, listener.getName(), vs.getName());
            throw new IllegalArgumentException(msg);
        }
        if (addJkListenerName && !listenerNames.contains(this.jkConnector.getName())) {
            listenerNames.add(this.jkConnector.getName());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, VIRTUAL_SERVER_SET_JK_LISTENER_NAME, new Object[]{vs.getID(), this.jkConnector.getName()});
            }
        }
        vs.setNetworkListenerNames(listenerNames.toArray(new String[listenerNames.size()]));
    }

    public VirtualServer createHost(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String docroot, MimeMap mimeMap) {
        VirtualServer vs = (VirtualServer)this._embedded.createHost(vsID, vsBean, docroot, vsBean.getLogFile(), mimeMap);
        vs.configureState();
        vs.configureRemoteAddressFilterValve();
        vs.configureRemoteHostFilterValve();
        vs.configureSingleSignOn(this.globalSSOEnabled, this.webContainerFeatureFactory, this.isSsoFailoverEnabled());
        vs.configureRedirect();
        vs.configureErrorPage();
        vs.configureErrorReportValve();
        vs.setServerContext(this.getServerContext());
        vs.setServerConfig(this.serverConfig);
        vs.setGrizzlyService(this.grizzlyService);
        vs.setWebContainer(this);
        return vs;
    }

    public void stop() throws LifecycleException {
        block3: {
            if (!this._started) {
                String msg = rb.getString(WEB_CONTAINER_NOT_STARTED);
                throw new LifecycleException(msg);
            }
            this._started = false;
            try {
                this._embedded.stop();
            }
            catch (LifecycleException ex) {
                if (ex.getMessage().contains("has not been started")) break block3;
                throw ex;
            }
        }
    }

    public void loadSystemDefaultWebModules() {
        org.apache.catalina.Container[] vsArray;
        WebModuleConfig wmInfo = null;
        String defaultPath = null;
        for (org.apache.catalina.Container aVsArray : vsArray = this.getEngine().findChildren()) {
            VirtualServer vs;
            if (!(aVsArray instanceof VirtualServer) || "__asadmin".equals((vs = (VirtualServer)aVsArray).getName())) continue;
            wmInfo = vs.createSystemDefaultWebModuleIfNecessary(this.habitat.getService(WebArchivist.class, new Annotation[0]));
            if (wmInfo != null) {
                defaultPath = wmInfo.getContextPath();
                this.loadStandaloneWebModule(vs, wmInfo);
            }
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.log(Level.INFO, VIRTUAL_SERVER_LOADED_DEFAULT_WEB_MODULE, new Object[]{vs.getName(), defaultPath});
        }
    }

    public void loadDefaultWebModulesAfterAllAppsProcessed() {
        org.apache.catalina.Container[] vsArray;
        String defaultPath = null;
        for (org.apache.catalina.Container aVsArray : vsArray = this.getEngine().findChildren()) {
            WebModuleConfig wmInfo;
            VirtualServer vs;
            if (!(aVsArray instanceof VirtualServer) || "__asadmin".equals((vs = (VirtualServer)aVsArray).getName()) || (wmInfo = vs.getDefaultWebModule(this.domain, this.habitat.getService(WebArchivist.class, new Annotation[0]), this.appRegistry)) == null) continue;
            defaultPath = wmInfo.getContextPath();
            try {
                this.updateDefaultWebModule(vs, vs.getNetworkListenerNames(), wmInfo);
            }
            catch (LifecycleException le) {
                String msg = rb.getString(DEFAULT_WEB_MODULE_ERROR);
                msg = MessageFormat.format(msg, defaultPath, vs.getName());
                logger.log(Level.SEVERE, msg, le);
            }
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.log(Level.INFO, VIRTUAL_SERVER_LOADED_DEFAULT_WEB_MODULE, new Object[]{vs.getName(), defaultPath});
        }
    }

    public void loadDefaultWebModule(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        VirtualServer virtualServer = (VirtualServer)this.getEngine().findChild(vsBean.getId());
        if (virtualServer != null) {
            this.loadDefaultWebModule(virtualServer);
        }
    }

    public void loadDefaultWebModule(VirtualServer vs) {
        String defaultPath = null;
        WebModuleConfig wmInfo = vs.getDefaultWebModule(this.domain, this.habitat.getService(WebArchivist.class, new Annotation[0]), this.appRegistry);
        if (wmInfo != null) {
            defaultPath = wmInfo.getContextPath();
            try {
                this.updateDefaultWebModule(vs, vs.getNetworkListenerNames(), wmInfo);
            }
            catch (LifecycleException le) {
                String msg = rb.getString(DEFAULT_WEB_MODULE_ERROR);
                msg = MessageFormat.format(msg, defaultPath, vs.getName());
                logger.log(Level.SEVERE, msg, le);
            }
        } else {
            wmInfo = vs.createSystemDefaultWebModuleIfNecessary(this.habitat.getService(WebArchivist.class, new Annotation[0]));
            if (wmInfo != null) {
                defaultPath = wmInfo.getContextPath();
                this.loadStandaloneWebModule(vs, wmInfo);
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, VIRTUAL_SERVER_LOADED_DEFAULT_WEB_MODULE, new Object[]{vs.getName(), defaultPath});
        }
    }

    protected void loadStandaloneWebModule(VirtualServer vs, WebModuleConfig wmInfo) {
        try {
            this.loadWebModule(vs, wmInfo, "null", null);
        }
        catch (Throwable t) {
            String msg = rb.getString(LOAD_WEB_MODULE_ERROR);
            msg = MessageFormat.format(msg, wmInfo.getName());
            logger.log(Level.SEVERE, msg, t);
        }
    }

    protected boolean isEnabled(String moduleName) {
        return true;
    }

    public List<Result<WebModule>> loadWebModule(WebModuleConfig wmInfo, String j2eeApplication, Properties deploymentProperties) {
        org.apache.catalina.Container[] vsArray;
        ArrayList<Result<WebModule>> results = new ArrayList<Result<WebModule>>();
        String vsIDs = wmInfo.getVirtualServers();
        List<String> vsList = StringUtils.parseStringList(vsIDs, " ,");
        if (vsList == null || vsList.isEmpty()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, WEB_MODULE_NOT_LOADED_NO_VIRTUAL_SERVERS, wmInfo.getName());
            }
            return results;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, LOADING_WEB_MODULE, vsIDs);
        }
        ArrayList<String> nonProcessedVSList = new ArrayList<String>(vsList);
        for (org.apache.catalina.Container aVsArray : vsArray = this.getEngine().findChildren()) {
            Set<String> matchedAliases;
            boolean hasMatchedAlias;
            if (!(aVsArray instanceof VirtualServer)) continue;
            VirtualServer vs = (VirtualServer)aVsArray;
            boolean eqVS = vsList.contains(vs.getID());
            if (eqVS) {
                nonProcessedVSList.remove(vs.getID());
            }
            boolean bl = hasMatchedAlias = (matchedAliases = this.matchAlias(vsList, vs)).size() > 0;
            if (hasMatchedAlias) {
                nonProcessedVSList.removeAll(matchedAliases);
            }
            if (!eqVS && !hasMatchedAlias) continue;
            WebModule ctx = null;
            try {
                ctx = this.loadWebModule(vs, wmInfo, j2eeApplication, deploymentProperties);
                results.add(new Result<WebModule>(ctx));
            }
            catch (Throwable t) {
                if (ctx != null) {
                    ctx.setAvailable(false);
                }
                results.add(new Result(t));
            }
        }
        if (nonProcessedVSList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            boolean follow = false;
            for (String alias : nonProcessedVSList) {
                if (follow) {
                    sb.append(",");
                }
                sb.append(alias);
                follow = true;
            }
            Object[] params = new Object[]{wmInfo.getName(), sb.toString()};
            logger.log(Level.SEVERE, WEB_MODULE_NOT_LOADED_TO_VS, params);
        }
        return results;
    }

    private boolean verifyAlias(List<String> vsList, VirtualServer vs) {
        for (int i = 0; i < vs.getAliases().length; ++i) {
            if (!vsList.contains(vs.getAliases()[i])) continue;
            return true;
        }
        return false;
    }

    private Set<String> matchAlias(List<String> vsList, VirtualServer vs) {
        HashSet<String> matched = new HashSet<String>();
        for (String alias : vs.getAliases()) {
            if (!vsList.contains(alias)) continue;
            matched.add(alias);
        }
        return matched;
    }

    private WebModule loadWebModule(VirtualServer vs, WebModuleConfig wmInfo, String j2eeApplication, Properties deploymentProperties) throws Exception {
        String moduleName;
        ClassLoader parentLoader;
        WebBundleDescriptorImpl wbd;
        String wmName = wmInfo.getName();
        String wmContextPath = wmInfo.getContextPath();
        if (wmContextPath.indexOf(37) != -1) {
            try {
                RequestUtil.urlDecode(wmContextPath, "UTF-8");
            }
            catch (Exception e) {
                String msg = rb.getString(INVALID_ENCODED_CONTEXT_ROOT);
                msg = MessageFormat.format(msg, wmName, wmContextPath);
                throw new Exception(msg);
            }
        }
        if (wmContextPath.length() == 0 && vs.getDefaultWebModuleID() != null) {
            String msg = rb.getString(DEFAULT_WEB_MODULE_CONFLICT);
            msg = MessageFormat.format(msg, wmName, vs.getID());
            throw new Exception(msg);
        }
        wmInfo.setWorkDirBase(this._appsWorkRoot);
        wmInfo.setStubBaseDir(this.appsStubRoot);
        String displayContextPath = null;
        displayContextPath = wmContextPath.length() == 0 ? MONITORING_NODE_SEPARATOR : wmContextPath;
        Map<String, AdHocServletInfo> adHocPaths = null;
        Map<String, AdHocServletInfo> adHocSubtrees = null;
        WebModule ctx = (WebModule)vs.findChild(wmContextPath);
        if (ctx != null) {
            if (ctx instanceof AdHocWebModule) {
                if (ctx.hasAdHocPaths()) {
                    adHocPaths = ctx.getAdHocPaths();
                }
                if (ctx.hasAdHocSubtrees()) {
                    adHocSubtrees = ctx.getAdHocSubtrees();
                }
                vs.removeChild(ctx);
            } else if ("__default-web-module".equals(ctx.getModuleName())) {
                this.unloadWebModule(wmContextPath, ctx.getWebBundleDescriptor().getApplication().getRegistrationName(), vs.getName(), true, null);
            } else {
                if (!ctx.getAvailable()) {
                    ctx.setAvailable(true);
                    return ctx;
                }
                String msg = rb.getString(DUPLICATE_CONTEXT_ROOT);
                throw new Exception(MessageFormat.format(msg, vs.getID(), ctx.getModuleName(), displayContextPath, wmName));
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            Object[] params = new Object[]{wmName, vs.getID(), displayContextPath};
            logger.log(Level.FINEST, WEB_MODULE_LOADING, params);
        }
        File docBase = null;
        docBase = JWS_APPCLIENT_MODULE_NAME.equals(wmName) ? new File(System.getProperty("com.sun.aas.installRoot")) : wmInfo.getLocation();
        ctx = (WebModule)this._embedded.createContext(wmName, wmContextPath, docBase, vs.getDefaultContextXmlLocation(), vs.getDefaultWebXmlLocation(), useDOLforDeployment, wmInfo);
        ctx.setUseNaming(false);
        Engine engine = (Engine)vs.getParent();
        if (engine != null) {
            ctx.setEngineName(engine.getName());
            ctx.setJvmRoute(engine.getJvmRoute());
        }
        String j2eeServer = this._serverContext.getInstanceName();
        String domain = this._serverContext.getDefaultDomainName();
        ctx.setDomain(domain);
        ctx.setJ2EEServer(j2eeServer);
        ctx.setJ2EEApplication(j2eeApplication);
        ctx.setCacheControls(vs.getCacheControls());
        ctx.setBean(wmInfo.getBean());
        if (adHocPaths != null) {
            ctx.addAdHocPaths(adHocPaths);
        }
        if (adHocSubtrees != null) {
            ctx.addAdHocSubtrees(adHocSubtrees);
        }
        if ((wbd = wmInfo.getDescriptor()) != null) {
            ctx.setContextRoot(((WebBundleDescriptor)wbd).getContextRoot());
        } else {
            logger.log(Level.WARNING, UNABLE_TO_SET_CONTEXT_ROOT, wmInfo);
        }
        String wmInfoWorkDir = wmInfo.getWorkDir();
        if (wmInfoWorkDir != null) {
            StringBuilder workDir = new StringBuilder(wmInfo.getWorkDir());
            if (wmName.equals("__default-web-module")) {
                workDir.append("-");
                workDir.append(FileUtils.makeFriendlyFilename(vs.getID()));
            }
            ctx.setWorkDir(workDir.toString());
        }
        if ((parentLoader = wmInfo.getParentLoader()) == null) {
            parentLoader = this._serverContext.getSharedClassLoader();
        }
        ctx.setParentClassLoader(parentLoader);
        if (wbd != null) {
            ctx.configureAlternateDD(wbd);
            ctx.configureWebServices(wbd);
        }
        SunWebAppImpl iasBean = null;
        if (wbd != null) {
            iasBean = (SunWebAppImpl)((WebBundleDescriptor)wbd).getSunDescriptor();
        }
        ctx.setIasWebAppConfigBean(iasBean);
        ctx.configureMiscSettings(iasBean, vs, displayContextPath);
        if (ctx.getID().startsWith("__default-web-module")) {
            ctx.setAlternateDocBases(vs.getProperties());
        }
        Loader loader = ctx.configureLoader(iasBean);
        if (wbd != null && wbd.hasWebServices()) {
            wbd.addExtraAttribute("WEBLOADER", loader);
        }
        for (LifecycleListener listener : ctx.findLifecycleListeners()) {
            if (!(listener instanceof ContextConfig)) continue;
            ((ContextConfig)listener).setClassLoader(wmInfo.getAppClassLoader());
        }
        ctx.configureSessionSettings(wbd, wmInfo);
        ctx.setI18nInfo();
        if (wbd != null) {
            boolean isSystem;
            String resourceType = wmInfo.getObjectType();
            boolean bl = isSystem = resourceType != null && resourceType.startsWith("system-");
            if (!wmName.startsWith("__default-web-module")) {
                Realm realm = this.habitat.getService(Realm.class, new Annotation[0]);
                if ("null".equals(j2eeApplication)) {
                    if (realm != null && realm instanceof RealmInitializer) {
                        ((RealmInitializer)((Object)realm)).initializeRealm(wbd, isSystem, vs.getAuthRealmName());
                        ctx.setRealm(realm);
                    }
                } else if (realm != null && realm instanceof RealmInitializer) {
                    ((RealmInitializer)((Object)realm)).initializeRealm(wbd, isSystem, null);
                    ctx.setRealm(realm);
                }
            }
            if (wbd.getApplication() != null && wbd.getApplication().isVirtual()) {
                ((BundleDescriptor)wbd).visit(new WebValidatorWithoutCL());
            }
        }
        this.addMimeMappings(ctx, vs.getMimeMap());
        String monitoringNodeName = moduleName = "__default-web-module";
        if (wbd != null && wbd.getApplication() != null) {
            Application app = wbd.getApplication();
            ctx.setStandalone(app.isVirtual());
            if (app.isVirtual()) {
                moduleName = app.getRegistrationName();
                monitoringNodeName = wbd.getModuleID();
            } else {
                moduleName = wbd.getModuleDescriptor().getArchiveUri();
                StringBuilder sb = new StringBuilder();
                sb.append(app.getRegistrationName()).append(MONITORING_NODE_SEPARATOR).append(moduleName);
                monitoringNodeName = sb.toString().replaceAll("\\.", "\\\\.").replaceAll("_war", "\\\\.war");
            }
        }
        ctx.setModuleName(moduleName);
        ctx.setMonitoringNodeName(monitoringNodeName);
        ArrayList<String> servletNames = new ArrayList<String>();
        if (wbd != null) {
            for (WebComponentDescriptor webCompDesc : ((WebBundleDescriptor)wbd).getWebComponentDescriptors()) {
                if (!webCompDesc.isServlet()) continue;
                servletNames.add(webCompDesc.getCanonicalName());
            }
        }
        this.webStatsProviderBootstrap.registerApplicationStatsProviders(monitoringNodeName, vs.getName(), servletNames);
        vs.addChild(ctx);
        ctx.loadSessions(deploymentProperties);
        return ctx;
    }

    protected void updateDefaultWebModule(VirtualServer virtualServer, String[] listenerNames, WebModuleConfig wmInfo) throws LifecycleException {
        Connector[] connectors;
        String defaultContextPath = null;
        if (wmInfo != null) {
            defaultContextPath = wmInfo.getContextPath();
        }
        if (defaultContextPath != null && !defaultContextPath.startsWith(MONITORING_NODE_SEPARATOR)) {
            defaultContextPath = MONITORING_NODE_SEPARATOR + defaultContextPath;
            wmInfo.getDescriptor().setContextRoot(defaultContextPath);
        }
        for (Connector connector : connectors = this._embedded.findConnectors()) {
            PECoyoteConnector conn = (PECoyoteConnector)connector;
            String name = conn.getName();
            for (String listenerName : listenerNames) {
                if (!name.equals(listenerName)) continue;
                Mapper mapper = conn.getMapper();
                try {
                    mapper.setDefaultContextPath(virtualServer.getName(), defaultContextPath);
                    for (String alias : virtualServer.findAliases()) {
                        mapper.setDefaultContextPath(alias, defaultContextPath);
                    }
                    virtualServer.setDefaultContextPath(defaultContextPath);
                }
                catch (Exception e) {
                    throw new LifecycleException(e);
                }
            }
        }
    }

    public ServerContext getServerContext() {
        return this._serverContext;
    }

    ServerConfigLookup getServerConfigLookup() {
        return this.serverConfigLookup;
    }

    File getLibPath() {
        return this.instance.getLibPath();
    }

    public String getApplicationId(WebModule wm) {
        return wm.getID();
    }

    public File getModulesRoot() {
        return this._modulesRoot;
    }

    public void unloadWebModule(String contextRoot, String appName, String virtualServers, Properties props) {
        this.unloadWebModule(contextRoot, appName, virtualServers, false, props);
    }

    public void unloadWebModule(String contextRoot, String appName, String virtualServers, boolean dummy, Properties props) {
        org.apache.catalina.Container[] hostArray;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, UNLOADING_WEB_MODULE, new Object[]{contextRoot, virtualServers});
        }
        if (contextRoot.length() != 0 && !contextRoot.startsWith(MONITORING_NODE_SEPARATOR)) {
            contextRoot = MONITORING_NODE_SEPARATOR + contextRoot;
        } else if (MONITORING_NODE_SEPARATOR.equals(contextRoot)) {
            contextRoot = "";
        }
        List<String> hostList = StringUtils.parseStringList(virtualServers, " ,");
        boolean unloadFromAll = hostList == null || hostList.isEmpty();
        boolean hasBeenUndeployed = false;
        VirtualServer host = null;
        WebModule context = null;
        for (org.apache.catalina.Container aHostArray : hostArray = this.getEngine().findChildren()) {
            WebModuleConfig wmInfo;
            host = (VirtualServer)aHostArray;
            if (!unloadFromAll && !hostList.contains(host.getName()) && !this.verifyAlias(hostList, host) || (context = (WebModule)host.findChild(contextRoot)) == null || !context.getWebBundleDescriptor().getApplication().getRegistrationName().equals(appName)) continue;
            context.saveSessions(props);
            host.removeChild(context);
            this.webStatsProviderBootstrap.unregisterApplicationStatsProviders(context.getMonitoringNodeName(), host.getName());
            try {
                if (!this.isShutdown) {
                    context.destroy();
                }
            }
            catch (Exception ex) {
                String msg = rb.getString(EXCEPTION_DURING_DESTROY);
                msg = MessageFormat.format(msg, contextRoot, host.getName());
                logger.log(Level.WARNING, msg, ex);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, CONTEXT_UNDEPLOYED, new Object[]{contextRoot, host});
            }
            hasBeenUndeployed = true;
            host.fireContainerEvent("remove", context);
            if (context.hasAdHocPaths() || context.hasAdHocSubtrees()) {
                WebModule wm = this.createAdHocWebModule(context.getID(), host, contextRoot, context.getJ2EEApplication());
                wm.addAdHocPaths(context.getAdHocPaths());
                wm.addAdHocSubtrees(context.getAdHocSubtrees());
            }
            if (dummy || this.isShutdown || (wmInfo = host.createSystemDefaultWebModuleIfNecessary(this.habitat.getService(WebArchivist.class, new Annotation[0]))) == null) continue;
            this.loadStandaloneWebModule(host, wmInfo);
        }
        if (!hasBeenUndeployed) {
            logger.log(Level.SEVERE, UNDEPLOY_ERROR, contextRoot);
        }
    }

    public boolean suspendWebModule(String contextRoot, String appName, String hosts) {
        boolean hasBeenSuspended = false;
        List<String> hostList = StringUtils.parseStringList(hosts, " ,");
        if (hostList == null || hostList.isEmpty()) {
            return hasBeenSuspended;
        }
        if (contextRoot.length() != 0 && !contextRoot.startsWith(MONITORING_NODE_SEPARATOR)) {
            contextRoot = MONITORING_NODE_SEPARATOR + contextRoot;
        }
        VirtualServer host = null;
        Context context = null;
        for (org.apache.catalina.Container aHostArray : this.getEngine().findChildren()) {
            host = (VirtualServer)aHostArray;
            if (!hostList.contains(host.getName()) && !this.verifyAlias(hostList, host) || (context = (Context)host.findChild(contextRoot)) == null) continue;
            context.setAvailable(false);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, CONTEXT_DISABLED, new Object[]{contextRoot, host});
            }
            hasBeenSuspended = true;
        }
        if (!hasBeenSuspended) {
            logger.log(Level.WARNING, DISABLE_WEB_MODULE_ERROR, contextRoot);
        }
        return hasBeenSuspended;
    }

    private void configureDynamicReloadingSettings() {
        if (this.dasConfig != null) {
            this._reloadingEnabled = Boolean.parseBoolean(this.dasConfig.getDynamicReloadEnabled());
            String seconds = this.dasConfig.getDynamicReloadPollIntervalInSeconds();
            if (seconds != null) {
                try {
                    this._pollInterval = Integer.parseInt(seconds);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void setDebugLevel() {
        Level logLevel;
        Level level = logLevel = logger.getLevel() != null ? logger.getLevel() : Level.INFO;
        this._debug = logLevel.equals(Level.FINE) ? 1 : (logLevel.equals(Level.FINER) ? 2 : (logLevel.equals(Level.FINEST) ? 5 : 0));
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    List<VirtualServer> getVirtualServersForHttpListenerId(HttpService httpService, String httpListenerId) {
        if (httpListenerId == null) {
            return null;
        }
        ArrayList<VirtualServer> result = new ArrayList<VirtualServer>();
        block0: for (com.sun.enterprise.config.serverbeans.VirtualServer vs : httpService.getVirtualServer()) {
            List<String> listeners = StringUtils.parseStringList(vs.getNetworkListeners(), ",");
            if (listeners == null) continue;
            ListIterator<String> iter = listeners.listIterator();
            while (iter.hasNext()) {
                if (!httpListenerId.equals(iter.next())) continue;
                VirtualServer match = (VirtualServer)this.getEngine().findChild(vs.getId());
                if (match == null) continue block0;
                result.add(match);
                continue block0;
            }
        }
        return result;
    }

    private void addMimeMappings(StandardContext ctx, MimeMap mimeMap) {
        if (mimeMap == null) {
            return;
        }
        Iterator<String> itr = mimeMap.getExtensions();
        while (itr.hasNext()) {
            String extension = itr.next();
            if (ctx.findMimeMapping(extension) != null) continue;
            ctx.addMimeMapping(extension, mimeMap.getType(extension));
        }
    }

    public Engine getEngine() {
        return this._embedded.getEngines()[0];
    }

    public HttpService getHttpService() {
        return this.serverConfig.getHttpService();
    }

    public void registerAdHocPath(String path, String ctxtRoot, String appName, AdHocServletInfo servletInfo) {
        this.registerAdHocPathAndSubtree(path, null, ctxtRoot, appName, servletInfo);
    }

    public void registerAdHocPathAndSubtree(String path, String subtree, String ctxtRoot, String appName, AdHocServletInfo servletInfo) {
        org.apache.catalina.Container[] vsList;
        WebModule wm = null;
        for (org.apache.catalina.Container aVsList : vsList = this.getEngine().findChildren()) {
            VirtualServer vs = (VirtualServer)aVsList;
            if (vs.getName().equalsIgnoreCase("__asadmin")) continue;
            wm = (WebModule)vs.findChild(ctxtRoot);
            if (wm == null) {
                wm = this.createAdHocWebModule(vs, ctxtRoot, appName);
            }
            wm.addAdHocPathAndSubtree(path, subtree, servletInfo);
        }
    }

    public void unregisterAdHocPath(String path, String ctxtRoot) {
        this.unregisterAdHocPathAndSubtree(path, null, ctxtRoot);
    }

    public void unregisterAdHocPathAndSubtree(String path, String subtree, String ctxtRoot) {
        org.apache.catalina.Container[] vsList;
        WebModule wm = null;
        for (org.apache.catalina.Container aVsList : vsList = this.getEngine().findChildren()) {
            VirtualServer vs = (VirtualServer)aVsList;
            if (vs.getName().equalsIgnoreCase("__asadmin") || (wm = (WebModule)vs.findChild(ctxtRoot)) == null) continue;
            wm.removeAdHocPath(path);
            wm.removeAdHocSubtree(subtree);
            if (!(wm instanceof AdHocWebModule) || wm.hasAdHocPaths() || wm.hasAdHocSubtrees()) continue;
            vs.removeChild(wm);
            try {
                wm.destroy();
            }
            catch (Exception ex) {
                String msg = rb.getString(EXCEPTION_DURING_DESTROY);
                msg = MessageFormat.format(msg, wm.getPath(), vs.getName());
                logger.log(Level.WARNING, msg, ex);
            }
        }
    }

    private WebModule createAdHocWebModule(VirtualServer vs, String ctxtRoot, String appName) {
        return this.createAdHocWebModule(appName, vs, ctxtRoot, appName);
    }

    private WebModule createAdHocWebModule(String id, VirtualServer vs, String ctxtRoot, String j2eeApplication) {
        AdHocWebModule wm = new AdHocWebModule();
        wm.setID(id);
        wm.setWebContainer(this);
        wm.restrictedSetPipeline(new WebPipeline(wm));
        wm.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        wm.setContextRoot(ctxtRoot);
        wm.setJ2EEApplication(j2eeApplication);
        wm.setName(ctxtRoot);
        wm.setDocBase(vs.getAppBase());
        wm.setEngineName(vs.getParent().getName());
        String domain = this._serverContext.getDefaultDomainName();
        wm.setDomain(domain);
        String j2eeServer = this._serverContext.getInstanceName();
        wm.setJ2EEServer(j2eeServer);
        wm.setCrossContext(true);
        vs.addChild(wm);
        return wm;
    }

    void removeDummyModule(VirtualServer vs) {
        WebModule ctx = (WebModule)vs.findChild("");
        if (ctx != null && "__default-web-module".equals(ctx.getModuleName())) {
            this.unloadWebModule("", ctx.getWebBundleDescriptor().getApplication().getRegistrationName(), vs.getName(), true, null);
        }
    }

    private void initInstanceSessionProperties() {
        SessionProperties spBean = this.serverConfigLookup.getInstanceSessionProperties();
        if (spBean == null || spBean.getProperty() == null) {
            return;
        }
        List<Property> props = spBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                throw new IllegalArgumentException(rb.getString(NULL_WEB_PROPERTY));
            }
            if (propName.equalsIgnoreCase("enableCookies")) {
                this.instanceEnableCookies = ConfigBeansUtilities.toBoolean(propValue);
                continue;
            }
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.log(Level.INFO, PROPERTY_NOT_YET_SUPPORTED, propName);
        }
    }

    private static synchronized void setJspFactory() {
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory(new JspFactoryImpl());
        }
    }

    public void deleteHost(HttpService httpService) throws LifecycleException {
        org.apache.catalina.Container[] virtualServers = this.getEngine().findChildren();
        block2: for (int i = 0; i < virtualServers.length; ++i) {
            for (com.sun.enterprise.config.serverbeans.VirtualServer vse : httpService.getVirtualServer()) {
                if (!virtualServers[i].getName().equals(vse.getId())) continue;
                virtualServers[i] = null;
                continue block2;
            }
        }
        for (org.apache.catalina.Container virtualServer1 : virtualServers) {
            org.apache.catalina.Container[] webModules;
            VirtualServer virtualServer = (VirtualServer)virtualServer1;
            if (virtualServer == null) continue;
            if (virtualServer.getID().equals("__asadmin")) {
                throw new LifecycleException("Cannot delete admin virtual-server.");
            }
            for (org.apache.catalina.Container webModule : webModules = virtualServer.findChildren()) {
                String appName = webModule.getName();
                if (webModule instanceof WebModule) {
                    appName = ((WebModule)webModule).getWebBundleDescriptor().getApplication().getRegistrationName();
                }
                this.unloadWebModule(webModule.getName(), appName, virtualServer.getID(), null);
            }
            try {
                virtualServer.destroy();
            }
            catch (Exception e) {
                String msg = rb.getString(DESTROY_VS_ERROR);
                msg = MessageFormat.format(msg, virtualServer.getID());
                logger.log(Level.WARNING, msg, e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateHost(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) throws LifecycleException {
        WebModuleConfig wmInfo;
        boolean found;
        if ("__asadmin".equals(vsBean.getId())) {
            return;
        }
        VirtualServer vs = (VirtualServer)this.getEngine().findChild(vsBean.getId());
        if (vs == null) {
            logger.log(Level.WARNING, CANNOT_UPDATE_NON_EXISTENCE_VS, vsBean.getId());
            return;
        }
        boolean updateListeners = false;
        if (vs.getNetworkListeners() == null) {
            updateListeners = vsBean.getNetworkListeners() != null;
        } else if (vs.getNetworkListeners().equals(vsBean.getNetworkListeners())) {
            updateListeners = false;
        } else {
            List<String> vsList = StringUtils.parseStringList(vs.getNetworkListeners(), ",");
            List<String> vsBeanList = StringUtils.parseStringList(vsBean.getNetworkListeners(), ",");
            for (String vsBeanName : vsBeanList) {
                if (vsList.contains(vsBeanName)) continue;
                updateListeners = true;
                if (!logger.isLoggable(Level.FINE)) break;
                logger.log(Level.FINE, UPDATE_LISTENER, new Object[]{vsBeanName, vs.getNetworkListeners()});
                break;
            }
        }
        String oldDefaultWebModule = vs.getDefaultWebModuleID();
        vs.setBean(vsBean);
        String vsLogFile = vsBean.getLogFile();
        vs.setLogFile(vsLogFile, this.logLevel, this.logServiceFile);
        vs.configureState();
        vs.clearAliases();
        vs.configureAliases();
        String docroot = vsBean.getPropertyValue("docroot");
        if (docroot == null) {
            docroot = vsBean.getDocroot();
        }
        if (docroot != null && !vs.getDocRoot().getAbsolutePath().equals(docroot)) {
            this.updateDocroot(docroot, vs, vsBean);
        }
        List<Property> props = vs.getProperties();
        for (Property prop : props) {
            this.updateHostProperties(vsBean, prop.getName(), prop.getValue(), this.securityService, vs);
        }
        vs.configureSingleSignOn(this.globalSSOEnabled, this.webContainerFeatureFactory, this.isSsoFailoverEnabled());
        vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        List<String> oldListenerList = StringUtils.parseStringList(vsBean.getNetworkListeners(), ",");
        String[] oldListeners = oldListenerList != null ? oldListenerList.toArray(new String[oldListenerList.size()]) : new String[]{};
        HashSet<NetworkListener> networkListeners = new HashSet<NetworkListener>();
        if (oldListenerList != null) {
            for (String string : oldListeners) {
                found = false;
                for (NetworkListener networkListener : this.serverConfig.getNetworkConfig().getNetworkListeners().getNetworkListener()) {
                    if (!networkListener.getName().equals(string)) continue;
                    networkListeners.add(networkListener);
                    found = true;
                    break;
                }
                if (found) continue;
                Object msg = rb.getString(LISTENER_REFERENCED_BY_HOST_NOT_EXIST);
                msg = MessageFormat.format((String)msg, string, vs.getName());
                logger.log(Level.SEVERE, (String)msg);
            }
            this.configureHostPortNumbers(vs, networkListeners);
        } else {
            vs.setNetworkListenerNames(new String[0]);
        }
        for (String string : oldListeners) {
            Connector[] connectors;
            found = false;
            for (NetworkListener networkListener : networkListeners) {
                if (!networkListener.getName().equals(string)) continue;
                found = true;
            }
            if (found) continue;
            for (Connector connector : connectors = this._embedded.findConnectors()) {
                WebConnector conn = (WebConnector)connector;
                if (!string.equals(conn.getName())) continue;
                try {
                    conn.getMapperListener().unregisterHost(vs.getJmxName());
                }
                catch (Exception e) {
                    throw new LifecycleException(e);
                }
            }
        }
        for (NetworkListener httpListener : networkListeners) {
            void var17_40;
            Connector[] connectorArray;
            boolean found2 = false;
            for (String string : oldListeners) {
                if (!httpListener.getName().equals(string)) continue;
                found2 = true;
            }
            if (found2) continue;
            Connector[] connectorArray2 = connectorArray = this._embedded.findConnectors();
            int n = connectorArray2.length;
            boolean bl = false;
            while (var17_40 < n) {
                Connector connector = connectorArray2[var17_40];
                WebConnector conn = (WebConnector)connector;
                if (httpListener.getName().equals(conn.getName())) {
                    if (!conn.isAvailable()) {
                        conn.start();
                    }
                    try {
                        conn.getMapperListener().registerHost(vs);
                    }
                    catch (Exception e) {
                        throw new LifecycleException(e);
                    }
                }
                ++var17_40;
            }
        }
        if (oldDefaultWebModule != null) {
            this.updateDefaultWebModule(vs, oldListeners, null);
        }
        if ((wmInfo = vs.getDefaultWebModule(this.domain, this.habitat.getService(WebArchivist.class, new Annotation[0]), this.appRegistry)) != null && wmInfo.getContextPath() != null && !"".equals(wmInfo.getContextPath()) && !MONITORING_NODE_SEPARATOR.equals(wmInfo.getContextPath())) {
            this.removeDummyModule(vs);
            this.updateDefaultWebModule(vs, vs.getNetworkListenerNames(), wmInfo);
        } else {
            WebModuleConfig wmc = vs.createSystemDefaultWebModuleIfNecessary(this.habitat.getService(WebArchivist.class, new Annotation[0]));
            if (wmc != null) {
                this.loadStandaloneWebModule(vs, wmc);
            }
        }
        if (updateListeners) {
            List<NetworkListener> httpListeners;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, VS_UPDATED_NETWORK_LISTENERS, new Object[]{vs.getName(), vs.getNetworkListeners(), vsBean.getNetworkListeners()});
            }
            if ((httpListeners = this.serverConfig.getNetworkConfig().getNetworkListeners().getNetworkListener()) != null) {
                for (NetworkListener networkListener : httpListeners) {
                    this.updateConnector(networkListener, this.habitat.getService(HttpService.class, new Annotation[0]));
                }
            }
        }
    }

    public void updateHostProperties(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String name, String value, SecurityService securityService, VirtualServer vs) {
        if (vs == null) {
            return;
        }
        vs.setBean(vsBean);
        if (name == null) {
            return;
        }
        if (name.startsWith("alternatedocroot_")) {
            this.updateAlternateDocroot(vs);
        } else if ("setCacheControl".equals(name)) {
            vs.configureCacheControl(value);
        } else if ("accessLoggingEnabled".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        } else if ("accesslog".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        } else if ("accessLogWriteInterval".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        } else if ("accessLogBufferSize".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        } else if ("allowRemoteHost".equals(name) || "denyRemoteHost".equals(name)) {
            vs.configureRemoteHostFilterValve();
        } else if ("allowRemoteAddress".equals(name) || "denyRemoteAddress".equals(name)) {
            vs.configureRemoteAddressFilterValve();
        } else if ("sso-enabled".equals(name)) {
            vs.configureSingleSignOn(this.globalSSOEnabled, this.webContainerFeatureFactory, this.isSsoFailoverEnabled());
        } else if ("authRealm".equals(name)) {
            vs.configureAuthRealm(securityService);
        } else if (name.startsWith("send-error")) {
            vs.configureErrorPage();
        } else if ("errorReportValve".equals(name)) {
            vs.setErrorReportValveClass(value);
        } else if (name.startsWith("redirect")) {
            vs.configureRedirect();
        } else if (name.startsWith("contextXmlDefault")) {
            vs.setDefaultContextXmlLocation(value);
        }
    }

    private boolean isSsoFailoverEnabled() {
        boolean webContainerAvailabilityEnabled = this.serverConfigLookup.calculateWebAvailabilityEnabledFromConfig();
        boolean isSsoFailoverEnabled = this.serverConfigLookup.isSsoFailoverEnabledFromConfig();
        return isSsoFailoverEnabled && webContainerAvailabilityEnabled;
    }

    public void updateHttpService(HttpService httpService) throws LifecycleException {
        if (httpService == null) {
            return;
        }
        this.globalSSOEnabled = ConfigBeansUtilities.toBoolean(httpService.getSsoEnabled());
        this.globalAccessLogWriteInterval = httpService.getAccessLog().getWriteIntervalSeconds();
        this.globalAccessLogBufferSize = httpService.getAccessLog().getBufferSizeBytes();
        this.globalAccessLoggingEnabled = ConfigBeansUtilities.toBoolean(httpService.getAccessLoggingEnabled());
        this.webContainerFeatureFactory = this.getWebContainerFeatureFactory();
        List<com.sun.enterprise.config.serverbeans.VirtualServer> virtualServers = httpService.getVirtualServer();
        for (com.sun.enterprise.config.serverbeans.VirtualServer virtualServer : virtualServers) {
            VirtualServer vs = (VirtualServer)this.getEngine().findChild(virtualServer.getId());
            if (vs == null) continue;
            vs.configureSingleSignOn(this.globalSSOEnabled, this.webContainerFeatureFactory, this.isSsoFailoverEnabled());
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
            this.updateHost(virtualServer);
        }
    }

    public void updateConnectorProperty(NetworkListener listener, String propName, String propValue) throws LifecycleException {
        WebConnector connector = this.connectorMap.get(listener.getName());
        if (connector != null) {
            connector.configHttpProperties(listener.findHttpProtocol().getHttp(), listener.findTransport(), listener.findHttpProtocol().getSsl());
            connector.configureHttpListenerProperty(propName, propValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnector(NetworkListener networkListener, HttpService httpService) throws LifecycleException {
        Object object = this.mapperUpdateSync;
        synchronized (object) {
            if (networkListener.findHttpProtocol().getHttp().getDefaultVirtualServer().equals("__asadmin") || "http-listener-1".equals(networkListener.getName()) && this.connectorMap.get("admin-listener") == null) {
                return;
            }
            WebConnector connector = this.connectorMap.get(networkListener.getName());
            if (connector != null) {
                this.deleteConnector(connector);
            }
            if (!Boolean.valueOf(networkListener.getEnabled()).booleanValue()) {
                return;
            }
            connector = this.addConnector(networkListener, httpService, false);
            List<VirtualServer> virtualServers = this.getVirtualServersForHttpListenerId(httpService, networkListener.getName());
            if (virtualServers != null) {
                for (VirtualServer vs : virtualServers) {
                    boolean found = false;
                    String[] listenerNames = vs.getNetworkListenerNames();
                    String name = connector.getName();
                    for (String listenerName : listenerNames) {
                        if (!listenerName.equals(name)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    String[] newListenerNames = new String[listenerNames.length + 1];
                    System.arraycopy(listenerNames, 0, newListenerNames, 0, listenerNames.length);
                    newListenerNames[listenerNames.length] = connector.getName();
                    vs.setNetworkListenerNames(newListenerNames);
                }
            }
            connector.start();
            if (virtualServers != null) {
                Mapper mapper = connector.getMapper();
                for (VirtualServer vs : virtualServers) {
                    String defaultWebModulePath = vs.getDefaultContextPath(this.domain, this.appRegistry);
                    if (defaultWebModulePath == null) continue;
                    try {
                        mapper.setDefaultContextPath(vs.getName(), defaultWebModulePath);
                        vs.setDefaultContextPath(defaultWebModulePath);
                    }
                    catch (Exception e) {
                        throw new LifecycleException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMapper(HttpService httpService, NetworkListener httpListener, Mapper mapper) {
        Object object = this.mapperUpdateSync;
        synchronized (object) {
            WebConnector connector = this.connectorMap.get(httpListener.getName());
            if (connector != null && connector.getMapper() != mapper) {
                try {
                    this.updateConnector(httpListener, httpService);
                }
                catch (LifecycleException le) {
                    logger.log(Level.SEVERE, EXCEPTION_CONFIG_HTTP_SERVICE, le);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebConnector addConnector(NetworkListener httpListener, HttpService httpService, boolean start) throws LifecycleException {
        Object object = this.mapperUpdateSync;
        synchronized (object) {
            WebConnector connector;
            int port = Integer.parseInt(httpListener.getPort());
            String virtualServerName = httpListener.findHttpProtocol().getHttp().getDefaultVirtualServer();
            VirtualServer vs = (VirtualServer)this.getEngine().findChild(virtualServerName);
            List<String> list = Arrays.asList(vs.getNetworkListenerNames());
            if (!list.contains(httpListener.getName())) {
                String[] oldListenerNames = vs.getNetworkListenerNames();
                String[] newListenerNames = new String[oldListenerNames.length + 1];
                System.arraycopy(oldListenerNames, 0, newListenerNames, 0, oldListenerNames.length);
                newListenerNames[oldListenerNames.length] = httpListener.getName();
                vs.setNetworkListenerNames(newListenerNames);
            }
            Mapper mapper = null;
            for (Mapper m : this.habitat.getAllServices(Mapper.class, new Annotation[0])) {
                if (m.getPort() != port || !(m instanceof ContextMapper)) continue;
                ContextMapper cm = (ContextMapper)m;
                if (!httpListener.getName().equals(cm.getId())) continue;
                mapper = m;
                break;
            }
            if ((connector = this.createHttpListener(httpListener, httpService, mapper)).getRedirectPort() == -1) {
                connector.setRedirectPort(this.defaultRedirectPort);
            }
            if (start) {
                connector.start();
            }
            return connector;
        }
    }

    public void deleteConnector(WebConnector connector) throws LifecycleException {
        Connector[] connectors;
        String name = connector.getName();
        for (Connector conn : connectors = this._embedded.findConnectors()) {
            if (!name.equals(conn.getName())) continue;
            this._embedded.removeConnector(conn);
            this.connectorMap.remove(connector.getName());
        }
    }

    public void deleteConnector(NetworkListener httpListener) throws LifecycleException {
        Connector[] connectors = this._embedded.findConnectors();
        String name = httpListener.getName();
        for (Connector conn : connectors) {
            if (!name.equals(conn.getName())) continue;
            this._embedded.removeConnector(conn);
            this.connectorMap.remove(name);
        }
    }

    public void updateAccessLog(HttpService httpService) {
        org.apache.catalina.Container[] virtualServers;
        for (org.apache.catalina.Container virtualServer : virtualServers = this.getEngine().findChildren()) {
            ((VirtualServer)virtualServer).reconfigureAccessLog(httpService, this.webContainerFeatureFactory);
        }
    }

    private void updateDocroot(String docroot, VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.validateDocroot(docroot, vsBean.getId(), vsBean.getDefaultWebModule());
        vs.setAppBase(docroot);
        this.removeDummyModule(vs);
        WebModuleConfig wmInfo = vs.createSystemDefaultWebModuleIfNecessary(this.habitat.getService(WebArchivist.class, new Annotation[0]));
        if (wmInfo != null) {
            this.loadStandaloneWebModule(vs, wmInfo);
        }
    }

    private void updateAlternateDocroot(VirtualServer vs) {
        this.removeDummyModule(vs);
        WebModuleConfig wmInfo = vs.createSystemDefaultWebModuleIfNecessary(this.habitat.getService(WebArchivist.class, new Annotation[0]));
        if (wmInfo != null) {
            this.loadStandaloneWebModule(vs, wmInfo);
        }
    }

    public void updateJvmRoute(HttpService httpService, String jvmOption) {
        String jvmRoute = null;
        if (jvmOption.contains("{") && jvmOption.contains("}")) {
            jvmRoute = this.server.getSystemPropertyValue(jvmOption = jvmOption.substring(jvmOption.indexOf("{") + 1, jvmOption.indexOf("}")));
            if (jvmRoute == null) {
                jvmRoute = System.getProperty(jvmOption);
            }
        } else if (jvmOption.contains("=")) {
            jvmRoute = jvmOption.substring(jvmOption.indexOf("=") + 1);
        }
        this.engine.setJvmRoute(jvmRoute);
        for (com.sun.enterprise.config.serverbeans.VirtualServer vsBean : httpService.getVirtualServer()) {
            VirtualServer vs = (VirtualServer)this.engine.findChild(vsBean.getId());
            for (org.apache.catalina.Container context : vs.findChildren()) {
                if (!(context instanceof StandardContext)) continue;
                ((StandardContext)context).setJvmRoute(jvmRoute);
            }
        }
        for (Connector connector : this._embedded.getConnectors()) {
            connector.setJvmRoute(jvmRoute);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, JVM_ROUTE_UPDATED, jvmRoute);
        }
    }

    protected boolean isTomcatUsingDefaultDomain() {
        return true;
    }

    private void createProbeProviders() {
        this.webModuleProbeProvider = new WebModuleProbeProvider();
        this.servletProbeProvider = new ServletProbeProvider();
        this.jspProbeProvider = new JspProbeProvider();
        this.sessionProbeProvider = new SessionProbeProvider();
        this.requestProbeProvider = new RequestProbeProvider();
    }

    private void createStatsProviders() {
        this.httpStatsProviderBootstrap = this.habitat.getService(HttpServiceStatsProviderBootstrap.class, new Annotation[0]);
        this.webStatsProviderBootstrap = this.habitat.getService(WebStatsProviderBootstrap.class, new Annotation[0]);
    }

    public Class loadCommonClass(String className) throws Exception {
        return this.clh.getCommonClassLoader().loadClass(className);
    }

    private void validateJSR299Scope(Class<?> clazz) {
        if (this.jcdiService != null && this.jcdiService.isCDIScoped(clazz)) {
            String msg = rb.getString(INVALID_ANNOTATION_SCOPE);
            msg = MessageFormat.format(msg, clazz.getName());
            throw new IllegalArgumentException(msg);
        }
    }

    private WebContainerFeatureFactory getWebContainerFeatureFactory() {
        String featureFactoryName = this.serverConfigLookup.calculateWebAvailabilityEnabledFromConfig() ? "ha" : "pe";
        this.webContainerFeatureFactory = this.habitat.getService(WebContainerFeatureFactory.class, featureFactoryName, new Annotation[0]);
        return this.webContainerFeatureFactory;
    }

    static {
        if (System.getProperty(DOL_DEPLOYMENT) != null) {
            useDOLforDeployment = Boolean.valueOf(System.getProperty(DOL_DEPLOYMENT));
        }
    }
}

