/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.cluster.SyncRequest;
import com.sun.enterprise.v3.admin.cluster.ServerSynchronizer;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service(name="_synchronize-files")
@PerLookup
@CommandLock(value=CommandLock.LockType.EXCLUSIVE)
@I18n(value="synchronize.command")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_synchronize-files", description="_synchronize-files")})
public class SynchronizeFiles
implements AdminCommand {
    @Param(name="file_list", primary=true)
    private File fileList;
    @Inject
    @Optional
    private Applications applications;
    @Inject
    @Optional
    private Servers servers;
    @Inject
    private InstanceStateService stateService;
    @Inject
    private ServerSynchronizer sync;
    private Logger logger;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(SynchronizeFiles.class);

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.logger = context.getLogger();
        SyncRequest sr = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{SyncRequest.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(null);
            sr = (SyncRequest)unmarshaller.unmarshal(this.fileList);
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("SynchronizeFiles: synchronize dir " + sr.dir);
            }
        }
        catch (Exception ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("SynchronizeFiles: Exception reading request");
                this.logger.fine(ex.toString());
            }
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(strings.getLocalString("sync.exception.reading", "SynchronizeFiles: Exception reading request"));
            report.setFailureCause(ex);
            return;
        }
        try {
            Server server = null;
            if (this.servers != null) {
                server = this.servers.getServer(sr.instance);
            }
            if (server == null) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(strings.getLocalString("sync.unknown.instance", "Unknown server instance: {0}", sr.instance));
                return;
            }
            this.sync.synchronize(server, sr, context.getOutboundPayload(), report, this.logger);
            this.stateService.setState(server.getName(), InstanceState.StateType.NO_RESPONSE, true);
            this.stateService.removeFailedCommandsForInstance(server.getName());
        }
        catch (Exception ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("SynchronizeFiles: Exception processing request");
                this.logger.fine(ex.toString());
            }
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(strings.getLocalString("sync.exception.processing", "SynchronizeFiles: Exception processing request"));
            report.setFailureCause(ex);
        }
    }
}

