/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;

@Service(name="_bootstrap-secure-admin")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_bootstrap-secure-admin", description="_bootstrap-secure-admin")})
public class BootstrapSecureAdminCommand
implements AdminCommand,
PostConstruct {
    private static final String DOWNLOADED_FILE_MIME_TYPE = "application/octet-stream";
    private static final String DOWNLOAD_DATA_REQUEST_NAME = "secure-admin";
    private File[] bootstrappedFiles = null;
    @Inject
    private ServerEnvironment env;

    @Override
    public void postConstruct() {
        this.bootstrappedFiles = new File[]{this.env.getJKS(), this.env.getTrustStore()};
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Payload.Outbound outboundPayload = context.getOutboundPayload();
        File instanceRoot = this.env.getInstanceRoot();
        try {
            for (File f : this.bootstrappedFiles) {
                outboundPayload.attachFile(DOWNLOADED_FILE_MIME_TYPE, instanceRoot.toURI().relativize(f.toURI()), DOWNLOAD_DATA_REQUEST_NAME, f);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (IOException ex) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(ex);
        }
    }
}

