/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.TransactionManagerHelper;
import com.sun.enterprise.transaction.TransactionSynchronizationRegistryImpl;
import com.sun.enterprise.transaction.UserTransactionImpl;
import com.sun.enterprise.transaction.spi.TransactionOperationsManager;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.api.naming.NamespacePrefixes;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
@NamespacePrefixes(value={"java:comp/UserTransaction", "java:comp/TransactionSynchronizationRegistry", "java:appserver/TransactionManager", "java:appserver/TransactionSynchronizationRegistry"})
public class TransactionNamingProxy
implements NamedNamingObjectProxy {
    @Inject
    private ServiceLocator habitat;
    @Inject
    private ProcessEnvironment processEnv;
    static final String USER_TX = "java:comp/UserTransaction";
    static final String USER_TX_NO_JAVA_COMP = "UserTransaction";
    static final String TRANSACTION_SYNC_REGISTRY = "java:comp/TransactionSynchronizationRegistry";
    static final String APPSERVER_TRANSACTION_SYNC_REGISTRY = "java:appserver/TransactionSynchronizationRegistry";
    static final String TRANSACTION_MGR = "java:pm/TransactionManager";
    static final String APPSERVER_TRANSACTION_MGR = "java:appserver/TransactionManager";

    @Override
    public Object handle(String name) throws NamingException {
        if (USER_TX.equals(name)) {
            this.checkUserTransactionLookupAllowed();
            return this.habitat.getService(UserTransactionImpl.class, new Annotation[0]);
        }
        if (TRANSACTION_SYNC_REGISTRY.equals(name) || APPSERVER_TRANSACTION_SYNC_REGISTRY.equals(name)) {
            return this.habitat.getService(TransactionSynchronizationRegistryImpl.class, new Annotation[0]);
        }
        if (APPSERVER_TRANSACTION_MGR.equals(name)) {
            return this.habitat.getService(TransactionManagerHelper.class, new Annotation[0]);
        }
        return null;
    }

    private void checkUserTransactionLookupAllowed() throws NamingException {
        TransactionOperationsManager toMgr;
        Object inv;
        InvocationManager iv = this.habitat.getService(InvocationManager.class, new Annotation[0]);
        if (iv != null && (inv = iv.getCurrentInvocation()) != null && (toMgr = (TransactionOperationsManager)((ComponentInvocation)inv).getTransactionOperationsManager()) != null) {
            toMgr.userTransactionLookupAllowed();
        }
    }
}

