/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.appserv.server.util.Version;
import com.sun.common.util.logging.BooleanLatch;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.module.bootstrap.EarlyLogHandler;
import com.sun.enterprise.server.logging.GFLogRecord;
import com.sun.enterprise.server.logging.LogEvent;
import com.sun.enterprise.server.logging.LogEventBroadcaster;
import com.sun.enterprise.server.logging.LogEventImpl;
import com.sun.enterprise.server.logging.LogEventListener;
import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.LogFormatHelper;
import com.sun.enterprise.server.logging.LogRotationTimer;
import com.sun.enterprise.server.logging.LogRotationTimerTask;
import com.sun.enterprise.server.logging.LoggingRuntime;
import com.sun.enterprise.server.logging.ODLLogFormatter;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.logging.AgentFormatterDelegate;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.logging.Task;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@ContractsProvided(value={GFFileHandler.class, Handler.class, LogEventBroadcaster.class, LoggingRuntime.class})
public class GFFileHandler
extends StreamHandler
implements PostConstruct,
PreDestroy,
LogEventBroadcaster,
LoggingRuntime {
    private static final int DEFAULT_ROTATION_LIMIT_BYTES = 2000000;
    public static final int DISABLE_LOG_FILE_ROTATION_VALUE = 0;
    private static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(GFFileHandler.class);
    @Inject
    ServerContext serverContext;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    @Optional
    Agent agent;
    @Inject
    private ServiceLocator habitat;
    private MeteredStream meter;
    private static final String LOGS_DIR = "logs";
    private static final String LOG_FILE_NAME = "server.log";
    private String absoluteServerLogName = null;
    private File absoluteFile = null;
    private int flushFrequency = 1;
    private int maxHistoryFiles = 10;
    private String gffileHandlerFormatter = "";
    private String currentgffileHandlerFormatter = "";
    private int limitForFileRotation = 0;
    private BlockingQueue<LogRecord> pendingRecords = new ArrayBlockingQueue<LogRecord>(5000);
    private AtomicBoolean rotationRequested = new AtomicBoolean(false);
    private Object rotationLock = new Object();
    private static final String LOG_ROTATE_DATE_FORMAT = "yyyy-MM-dd'T'HH-mm-ss";
    private static final SimpleDateFormat logRotateDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss");
    private static final String DEFAULT_LOG_FILE_FORMATTER_CLASS_NAME = UniformLogFormatter.class.getName();
    public static final int MINIMUM_ROTATION_LIMIT_VALUE = 500000;
    private BooleanLatch done = new BooleanLatch();
    private Thread pump;
    boolean dayBasedFileRotation = false;
    private String RECORD_BEGIN_MARKER = "[#|";
    private String RECORD_END_MARKER = "|#]";
    private String RECORD_FIELD_SEPARATOR = "|";
    private String RECORD_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private List<LogEventListener> logEventListeners = new ArrayList<LogEventListener>();
    String recordBeginMarker;
    String recordEndMarker;
    String recordFieldSeparator;
    String recordDateFormat;
    String logFileProperty = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postConstruct() {
        String formatterName;
        Long rotationTimeLimitValue;
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        this.logFileProperty = manager.getProperty(cname + ".file");
        if (this.logFileProperty == null || this.logFileProperty.trim().equals("")) {
            this.logFileProperty = this.env.getInstanceRoot().getAbsolutePath() + File.separator + LOGS_DIR + File.separator + LOG_FILE_NAME;
        }
        String filename = TranslatedConfigView.getTranslatedValue(this.logFileProperty).toString();
        File serverLog = new File(filename);
        this.absoluteServerLogName = filename;
        if (!serverLog.isAbsolute()) {
            serverLog = new File(this.env.getDomainRoot(), filename);
            this.absoluteServerLogName = this.env.getDomainRoot() + File.separator + filename;
        }
        this.changeFileName(serverLog);
        BufferedReader br = null;
        String strLine = "";
        int odlFormatter = 0;
        int uniformLogFormatter = 0;
        int otherFormatter = 0;
        boolean mustRotate = false;
        try {
            br = new BufferedReader(new FileReader(serverLog));
            while ((strLine = br.readLine()) != null) {
                if ((strLine = strLine.trim()).equals("")) continue;
                if (LogFormatHelper.isUniformFormatLogHeader(strLine)) {
                    ++uniformLogFormatter;
                } else if (LogFormatHelper.isODLFormatLogHeader(strLine)) {
                    ++odlFormatter;
                } else {
                    ++otherFormatter;
                }
                if (otherFormatter > 0) {
                    mustRotate = true;
                }
                break;
            }
        }
        catch (Exception e) {
            ErrorManager em = this.getErrorManager();
            if (em != null) {
                em.error(e.getMessage(), e, 0);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        if (odlFormatter > 0) {
            this.currentgffileHandlerFormatter = "com.sun.enterprise.server.logging.ODLLogFormatter";
        } else if (uniformLogFormatter > 0) {
            this.currentgffileHandlerFormatter = "com.sun.enterprise.server.logging.UniformLogFormatter";
        }
        this.initializePump();
        LogRecord lr = new LogRecord(Level.INFO, "NCLS-LOGGING-00009");
        lr.setParameters(new Object[]{Version.getFullVersion()});
        lr.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
        lr.setThreadID((int)Thread.currentThread().getId());
        lr.setLoggerName("javax.enterprise.logging");
        EarlyLogHandler.earlyMessages.add(lr);
        String propValue = null;
        propValue = manager.getProperty(cname + ".rotationOnDateChange");
        boolean rotationOnDateChange = false;
        if (propValue != null) {
            rotationOnDateChange = Boolean.parseBoolean(propValue);
        }
        if (rotationOnDateChange) {
            this.dayBasedFileRotation = true;
            rotationTimeLimitValue = 0L;
            int MILLIS_IN_DAY = 86400000;
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
            long systime = System.currentTimeMillis();
            String nextDate = dateFormat.format(date.getTime() + (long)MILLIS_IN_DAY);
            Date nextDay = null;
            try {
                nextDay = dateFormat.parse(nextDate);
            }
            catch (ParseException e) {
                nextDay = new Date();
                lr = new LogRecord(Level.WARNING, "NCLS-LOGGING-00011");
                lr.setParameters(new Object[]{nextDate});
                lr.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
                lr.setThreadID((int)Thread.currentThread().getId());
                lr.setLoggerName("javax.enterprise.logging");
                EarlyLogHandler.earlyMessages.add(lr);
            }
            long nextsystime = nextDay.getTime();
            rotationTimeLimitValue = nextsystime - systime;
            Task rotationTask = new Task(){

                public Object run() {
                    GFFileHandler.this.rotate();
                    return null;
                }
            };
            LogRotationTimer.getInstance().startTimer(new LogRotationTimerTask(rotationTask, rotationTimeLimitValue / 60000L));
        } else {
            rotationTimeLimitValue = 0L;
            try {
                propValue = manager.getProperty(cname + ".rotationTimelimitInMinutes");
                if (propValue != null) {
                    rotationTimeLimitValue = Long.parseLong(propValue);
                }
            }
            catch (NumberFormatException e) {
                lr = new LogRecord(Level.WARNING, "NCLS-LOGGING-00012");
                lr.setParameters(new Object[]{propValue, "rotationTimelimitInMinutes"});
                lr.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
                lr.setThreadID((int)Thread.currentThread().getId());
                lr.setLoggerName("javax.enterprise.logging");
                EarlyLogHandler.earlyMessages.add(lr);
            }
            if (rotationTimeLimitValue > 0L) {
                Task rotationTask = new Task(){

                    public Object run() {
                        GFFileHandler.this.rotate();
                        return null;
                    }
                };
                LogRotationTimer.getInstance().startTimer(new LogRotationTimerTask(rotationTask, rotationTimeLimitValue));
            }
        }
        Integer rotationLimitAttrValue = 2000000;
        try {
            propValue = manager.getProperty(cname + ".rotationLimitInBytes");
            if (propValue != null) {
                rotationLimitAttrValue = Integer.parseInt(propValue);
            }
        }
        catch (NumberFormatException e) {
            lr = new LogRecord(Level.WARNING, "NCLS-LOGGING-00012");
            lr.setParameters(new Object[]{propValue, "rotationLimitInBytes"});
            lr.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
            lr.setThreadID((int)Thread.currentThread().getId());
            lr.setLoggerName("javax.enterprise.logging");
            EarlyLogHandler.earlyMessages.add(lr);
        }
        if (rotationLimitAttrValue >= 500000 || rotationLimitAttrValue == 0) {
            this.setLimitForRotation(rotationLimitAttrValue);
        }
        if ((propValue = manager.getProperty(cname + ".flushFrequency")) != null) {
            try {
                this.flushFrequency = Integer.parseInt(propValue);
            }
            catch (NumberFormatException e) {
                lr = new LogRecord(Level.WARNING, "NCLS-LOGGING-00012");
                lr.setParameters(new Object[]{propValue, "flushFrequency"});
                lr.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
                lr.setThreadID((int)Thread.currentThread().getId());
                lr.setLoggerName("javax.enterprise.logging");
                EarlyLogHandler.earlyMessages.add(lr);
            }
        }
        if (this.flushFrequency <= 0) {
            this.flushFrequency = 1;
        }
        this.gffileHandlerFormatter = formatterName = (formatterName = manager.getProperty(cname + ".formatter")) == null ? DEFAULT_LOG_FILE_FORMATTER_CLASS_NAME : formatterName;
        if (mustRotate) {
            this.rotate();
        } else if (this.gffileHandlerFormatter != null && !this.gffileHandlerFormatter.equals(this.currentgffileHandlerFormatter)) {
            this.rotate();
        }
        String excludeFields = manager.getProperty("com.sun.enterprise.server.logging.GFFileHandler.excludeFields");
        boolean multiLineMode = Boolean.parseBoolean(manager.getProperty("com.sun.enterprise.server.logging.GFFileHandler.multiLineMode"));
        if (UniformLogFormatter.class.getName().equals(formatterName)) {
            this.configureUniformLogFormatter(excludeFields, multiLineMode);
        } else if (ODLLogFormatter.class.getName().equals(formatterName)) {
            this.configureODLFormatter(excludeFields, multiLineMode);
        } else {
            Formatter currentFormatter = this.getFormatter();
            if (currentFormatter == null || !currentFormatter.getClass().getName().equals(formatterName)) {
                Formatter formatter = this.findFormatterService(formatterName);
                if (formatter == null) {
                    lr = new LogRecord(Level.SEVERE, "NCLS-LOGGING-00013");
                    lr.setParameters(new Object[]{formatterName});
                    lr.setThreadID((int)Thread.currentThread().getId());
                    lr.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
                    lr.setLoggerName("javax.enterprise.logging");
                    EarlyLogHandler.earlyMessages.add(lr);
                    this.configureDefaultFormatter(excludeFields, multiLineMode);
                } else {
                    this.setFormatter(formatter);
                }
            }
        }
        formatterName = this.getFormatter().getClass().getName();
        lr = new LogRecord(Level.INFO, "NCLS-LOGGING-00010");
        lr.setParameters(new Object[]{formatterName});
        lr.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
        lr.setThreadID((int)Thread.currentThread().getId());
        lr.setLoggerName("javax.enterprise.logging");
        EarlyLogHandler.earlyMessages.add(lr);
        propValue = manager.getProperty(cname + ".maxHistoryFiles");
        try {
            if (propValue != null) {
                this.maxHistoryFiles = Integer.parseInt(propValue);
            }
        }
        catch (NumberFormatException e) {
            lr = new LogRecord(Level.WARNING, "NCLS-LOGGING-00012");
            lr.setParameters(new Object[]{propValue, "maxHistoryFiles"});
            lr.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
            lr.setThreadID((int)Thread.currentThread().getId());
            lr.setLoggerName("javax.enterprise.logging");
            EarlyLogHandler.earlyMessages.add(lr);
        }
        if (this.maxHistoryFiles < 0) {
            this.maxHistoryFiles = 10;
        }
    }

    Formatter findFormatterService(String formatterName) {
        List<Formatter> formatterServices = this.habitat.getAllServices(Formatter.class, new Annotation[0]);
        for (Formatter formatter : formatterServices) {
            if (!formatter.getClass().getName().equals(formatterName)) continue;
            return formatter;
        }
        return null;
    }

    private void configureDefaultFormatter(String excludeFields, boolean multiLineMode) {
        this.configureUniformLogFormatter(excludeFields, multiLineMode);
    }

    private void configureODLFormatter(String excludeFields, boolean multiLineMode) {
        ODLLogFormatter formatterClass = null;
        if (this.agent != null) {
            formatterClass = new ODLLogFormatter(new AgentFormatterDelegate(this.agent));
            this.setFormatter(formatterClass);
        } else {
            formatterClass = new ODLLogFormatter();
            this.setFormatter(formatterClass);
        }
        formatterClass.setExcludeFields(excludeFields);
        formatterClass.setMultiLineMode(multiLineMode);
        formatterClass.setLogEventBroadcaster(this);
    }

    private void configureUniformLogFormatter(String excludeFields, boolean multiLineMode) {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        UniformLogFormatter formatterClass = null;
        if (this.agent != null) {
            formatterClass = new UniformLogFormatter(new AgentFormatterDelegate(this.agent));
            this.setFormatter(formatterClass);
        } else {
            formatterClass = new UniformLogFormatter();
            this.setFormatter(formatterClass);
        }
        formatterClass.setExcludeFields(excludeFields);
        formatterClass.setMultiLineMode(multiLineMode);
        formatterClass.setLogEventBroadcaster(this);
        if (formatterClass != null) {
            this.recordBeginMarker = manager.getProperty(cname + ".logFormatBeginMarker");
            if (this.recordBeginMarker == null || "".equals(this.recordBeginMarker)) {
                this.recordBeginMarker = this.RECORD_BEGIN_MARKER;
            }
            this.recordEndMarker = manager.getProperty(cname + ".logFormatEndMarker");
            if (this.recordEndMarker == null || "".equals(this.recordEndMarker)) {
                this.recordEndMarker = this.RECORD_END_MARKER;
            }
            this.recordFieldSeparator = manager.getProperty(cname + ".logFormatFieldSeparator");
            if (this.recordFieldSeparator == null || "".equals(this.recordFieldSeparator) || this.recordFieldSeparator.length() > 1) {
                this.recordFieldSeparator = this.RECORD_FIELD_SEPARATOR;
            }
            this.recordDateFormat = manager.getProperty(cname + ".logFormatDateFormat");
            if (this.recordDateFormat != null && !"".equals(this.recordDateFormat)) {
                SimpleDateFormat sdf = new SimpleDateFormat(this.recordDateFormat);
                try {
                    sdf.format(new Date());
                }
                catch (Exception e) {
                    this.recordDateFormat = this.RECORD_DATE_FORMAT;
                }
            } else {
                this.recordDateFormat = this.RECORD_DATE_FORMAT;
            }
            formatterClass.setRecordBeginMarker(this.recordBeginMarker);
            formatterClass.setRecordEndMarker(this.recordEndMarker);
            formatterClass.setRecordDateFormat(this.recordDateFormat);
            formatterClass.setRecordFieldSeparator(this.recordFieldSeparator);
        }
    }

    void initializePump() {
        this.pump = new Thread(){

            @Override
            public void run() {
                while (!GFFileHandler.this.done.isSignalled()) {
                    try {
                        GFFileHandler.this.log();
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this.pump.setDaemon(true);
        this.pump.start();
    }

    @Override
    public void preDestroy() {
        if (LogFacade.LOGGING_LOGGER.isLoggable(Level.FINE)) {
            LogFacade.LOGGING_LOGGER.fine("Logger handler killed");
        }
        this.done.tryReleaseShared(1);
        this.pump.interrupt();
        int size = this.pendingRecords.size();
        if (size > 0) {
            ArrayList records = new ArrayList(size);
            this.pendingRecords.drainTo(records, size);
            for (LogRecord record : records) {
                super.publish(record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeFileName(File file) {
        if (file.equals(this.absoluteFile)) {
            return;
        }
        Object object = this.rotationLock;
        synchronized (object) {
            super.flush();
            super.close();
            try {
                this.openFile(file);
                this.absoluteFile = file;
            }
            catch (IOException ix) {
                new ErrorManager().error("FATAL ERROR: COULD NOT OPEN LOG FILE. Please Check to make sure that the directory for Logfile exists. Currently reverting back to use the  default server.log", ix, 4);
                try {
                    this.openFile(this.absoluteFile);
                }
                catch (Exception e) {
                    new ErrorManager().error("FATAL ERROR: COULD NOT RE-OPEN SERVER LOG FILE. ", e, 4);
                }
            }
        }
    }

    @Override
    public File getCurrentLogFile() {
        return this.absoluteFile;
    }

    private synchronized void setLimitForRotation(int rotationLimitInBytes) {
        this.limitForFileRotation = rotationLimitInBytes;
    }

    private void openFile(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException(LOCAL_STRINGS.getLocalString("parent.dir.create.failed", "Failed to create the parent dir {0}", parent.getAbsolutePath()));
        }
        FileOutputStream fout = new FileOutputStream(file, true);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, file.length());
        this.setOutputStream(this.meter);
    }

    void requestRotation() {
        this.rotationRequested.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpHistoryLogFiles() {
        if (this.maxHistoryFiles == 0) {
            return;
        }
        Object object = this.rotationLock;
        synchronized (object) {
            File dir = this.absoluteFile.getParentFile();
            if (dir == null) {
                return;
            }
            File[] fset = dir.listFiles();
            ArrayList<String> candidates = new ArrayList<String>();
            for (int i = 0; fset != null && i < fset.length; ++i) {
                if (LOG_FILE_NAME.equals(fset[i].getName()) || !fset[i].isFile() || !fset[i].getName().startsWith(LOG_FILE_NAME)) continue;
                candidates.add(fset[i].getAbsolutePath());
            }
            if (candidates.size() <= this.maxHistoryFiles) {
                return;
            }
            Object[] pathes = candidates.toArray();
            Arrays.sort(pathes);
            try {
                for (int i = 0; i < pathes.length - this.maxHistoryFiles; ++i) {
                    File logFile = new File((String)pathes[i]);
                    boolean delFile = logFile.delete();
                    if (delFile) continue;
                    throw new IOException("Could not delete log file: " + logFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                new ErrorManager().error("FATAL ERROR: COULD NOT DELETE LOG FILE.", e, 0);
            }
        }
    }

    public void rotate() {
        final GFFileHandler thisInstance = this;
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Object object = thisInstance.rotationLock;
                synchronized (object) {
                    if (thisInstance.meter != null && ((GFFileHandler)thisInstance).meter.written <= 0L) {
                        return null;
                    }
                    thisInstance.flush();
                    thisInstance.close();
                    try {
                        if (!GFFileHandler.this.absoluteFile.exists()) {
                            File creatingDeletedLogFile = new File(GFFileHandler.this.absoluteFile.getAbsolutePath());
                            if (creatingDeletedLogFile.createNewFile()) {
                                GFFileHandler.this.absoluteFile = creatingDeletedLogFile;
                            }
                        } else {
                            File oldFile = GFFileHandler.this.absoluteFile;
                            StringBuffer renamedFileName = new StringBuffer(GFFileHandler.this.absoluteFile + "_");
                            logRotateDateFormatter.format(new Date(), renamedFileName, new FieldPosition(0));
                            File rotatedFile = new File(renamedFileName.toString());
                            boolean renameSuccess = oldFile.renameTo(rotatedFile);
                            if (!renameSuccess) {
                                FileUtils.copy(GFFileHandler.this.absoluteFile, rotatedFile);
                                File freshServerLogFile = GFFileHandler.this.getLogFileName();
                                FileOutputStream fo = new FileOutputStream(freshServerLogFile);
                                fo.close();
                            }
                            FileOutputStream oldFileFO = new FileOutputStream(oldFile);
                            oldFileFO.close();
                            GFFileHandler.this.openFile(GFFileHandler.this.getLogFileName());
                            GFFileHandler.this.absoluteFile = GFFileHandler.this.getLogFileName();
                            if (GFFileHandler.this.dayBasedFileRotation) {
                                LogRotationTimer.getInstance().restartTimerForDayBasedRotation();
                            } else {
                                LogRotationTimer.getInstance().restartTimer();
                            }
                            GFFileHandler.this.cleanUpHistoryLogFiles();
                        }
                    }
                    catch (IOException ix) {
                        new ErrorManager().error("Error, could not rotate log file", ix, 0);
                    }
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() {
        try {
            LogRecord record = this.pendingRecords.take();
            super.publish(record);
        }
        catch (InterruptedException e) {
            return;
        }
        Vector v = new Vector();
        int msgs = this.pendingRecords.drainTo(v, this.flushFrequency);
        for (int j = 0; j < msgs; ++j) {
            super.publish((LogRecord)v.get(j));
        }
        this.flush();
        if (this.rotationRequested.get() || this.limitForFileRotation > 0 && this.meter.written >= (long)this.limitForFileRotation) {
            Object object = this.rotationLock;
            synchronized (object) {
                this.rotate();
                this.rotationRequested.set(false);
            }
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.done.isSignalled()) {
            return;
        }
        GFLogRecord recordWrapper = new GFLogRecord(record);
        recordWrapper.setThreadName(Thread.currentThread().getName());
        try {
            this.pendingRecords.add(recordWrapper);
        }
        catch (IllegalStateException e) {
            try {
                this.pendingRecords.put(recordWrapper);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Formatter formatter = this.getFormatter();
        if (!(formatter instanceof LogEventBroadcaster)) {
            LogEventImpl logEvent = new LogEventImpl(record);
            this.informLogEventListeners(logEvent);
        }
    }

    protected File getLogFileName() {
        return new File(this.absoluteServerLogName);
    }

    public boolean addLogEventListener(LogEventListener listener) {
        if (this.logEventListeners.contains(listener)) {
            return false;
        }
        return this.logEventListeners.add(listener);
    }

    public boolean removeLogEventListener(LogEventListener listener) {
        return this.logEventListeners.remove(listener);
    }

    @Override
    public void informLogEventListeners(LogEvent logEvent) {
        for (LogEventListener listener : this.logEventListeners) {
            listener.messageLogged(logEvent);
        }
    }

    private static final class MeteredStream
    extends OutputStream {
        private volatile boolean isOpen = false;
        OutputStream out;
        long written;

        MeteredStream(OutputStream out, long written) {
            this.out = out;
            this.written = written;
            this.isOpen = true;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        @Override
        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += (long)buff.length;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += (long)len;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.isOpen) {
                this.isOpen = false;
                this.flush();
                this.out.close();
            }
        }
    }
}

