/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt;

import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.SystemAdvertisement;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.mgmt.HealthMonitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class HealthMessage
implements Serializable {
    static final long serialVersionUID = -5452866103975155397L;
    private List<Entry> entries = new ArrayList<Entry>();
    private PeerID<?> srcID;

    public List<Entry> getEntries() {
        return this.entries;
    }

    public PeerID<?> getSrcID() {
        return this.srcID;
    }

    public void add(Entry entry) {
        if (!this.entries.contains(entry)) {
            this.entries.add(entry);
        }
    }

    public void remove(Entry entry) {
        if (this.entries.contains(entry)) {
            this.entries.remove(this.entries.indexOf(entry));
        }
    }

    public void setSrcID(PeerID<?> id) {
        this.srcID = id == null ? null : id;
    }

    public String toString() {
        return HealthMessage.class.getSimpleName() + "[" + this.srcID + ":" + this.entries + "]";
    }

    public static final class Entry
    implements Serializable,
    Cloneable {
        static final long serialVersionUID = 7485962183100651020L;
        final PeerID<?> id;
        final SystemAdvertisement adv;
        String state;
        long timestamp;
        final long seqID;
        transient long srcStartTime = 0L;

        public Entry(SystemAdvertisement adv, String state, long seqID) {
            this.state = state;
            this.adv = adv;
            this.id = adv.getID();
            this.timestamp = System.currentTimeMillis();
            this.seqID = seqID;
        }

        public Entry(Entry entry) {
            this(entry.adv, entry.state, entry.seqID);
        }

        public long getSeqID() {
            return this.seqID;
        }

        public long getSrcStartTime() {
            this.srcStartTime = Utility.getStartTime(this.adv);
            return this.srcStartTime == -1L ? -1L : this.srcStartTime;
        }

        public boolean isFromSameMember(Entry other) {
            return other != null && this.id.equals(other.id);
        }

        public boolean isFromSameMemberStartup(Entry other) {
            return other != null && this.id.equals(other.id) && this.getSrcStartTime() == other.getSrcStartTime();
        }

        public boolean isState(int theState) {
            return this.state.equals(HealthMonitor.states[theState]);
        }

        public boolean equals(Object obj) {
            return obj instanceof Entry && this == obj || obj != null && this.id.equals(((Entry)obj).id);
        }

        public int hashCode() {
            return this.id.hashCode() * 45191;
        }

        public String toString() {
            return "HealthMessage.Entry: Id = " + this.id.toString() + "; State = " + this.state + "; LastTimeStamp = " + this.timestamp + "; Sequence ID = " + this.seqID;
        }

        public Object clone() throws CloneNotSupportedException {
            return (Entry)super.clone();
        }
    }
}

