/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ws;

import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.ws.ReliabilityConfigNode;
import com.sun.enterprise.deployment.node.ws.WLUnSupportedNode;
import com.sun.enterprise.deployment.runtime.ws.ReliabilityConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WLWebServiceEndpointNode
extends DeploymentDescriptorNode {
    private WebServiceEndpoint descriptor = null;
    private static final XMLElement tag = new XMLElement("port-component");
    private static final List<String> UNSUPPORTED_TAGS = new ArrayList<String>();

    public WLWebServiceEndpointNode() {
        this.registerElementHandler(new XMLElement("wsdl"), WSDLNode.class);
        this.registerElementHandler(new XMLElement("service-endpoint-address"), ServiceEndpointAddressNode.class);
        this.registerElementHandler(new XMLElement("reliability-config"), ReliabilityConfigNode.class);
        for (String unsupportedTag : UNSUPPORTED_TAGS) {
            this.registerElementHandler(new XMLElement(unsupportedTag), WLUnSupportedNode.class);
        }
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return tag;
    }

    protected Map getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("auth-method", "setAuthMethod");
        table.put("realm", "setRealm");
        table.put("transport-guarantee", "setTransportGuarantee");
        table.put("stream-attachments", "setStreamAttachments");
        table.put("validate-request", "setValidateRequest");
        table.put("http-response-buffersize", "setHttpResponseBufferSize");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        String elementName = element.getQName();
        if ("port-component-name".equals(elementName)) {
            WebService webservice = (WebService)this.getParentNode().getDescriptor();
            this.descriptor = webservice.getEndpointByName(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public XMLNode getHandlerFor(XMLElement element) {
        String elementName = element.getQName();
        DeploymentDescriptorNode node = null;
        if (UNSUPPORTED_TAGS.contains(element.getQName())) {
            node = new WLUnSupportedNode(element);
        } else if ("wsdl".equals(elementName)) {
            node = new WSDLNode(this.descriptor);
            node.setParentNode(this);
        } else if ("service-endpoint-address".equals(elementName)) {
            node = new ServiceEndpointAddressNode(this.descriptor);
            node.setParentNode(this);
        } else if ("reliability-config".equals(elementName)) {
            node = new ReliabilityConfigNode();
            node.setParentNode(this);
        }
        return node;
    }

    @Override
    public Object getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void addDescriptor(Object childdescriptor) {
        if (childdescriptor instanceof ReliabilityConfig) {
            this.descriptor.setReliabilityConfig((ReliabilityConfig)childdescriptor);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, WebServiceEndpoint descriptor) {
        Node wseNode = super.writeDescriptor(parent, nodeName, descriptor);
        WLWebServiceEndpointNode.appendTextChild(wseNode, "port-component-name", descriptor.getEndpointName());
        if (descriptor.implementedByEjbComponent() && descriptor.hasAuthMethod()) {
            Element loginConfigNode = WLWebServiceEndpointNode.appendChild(wseNode, "login-config");
            WLWebServiceEndpointNode.appendTextChild((Node)loginConfigNode, "auth-method", descriptor.getAuthMethod());
            WLWebServiceEndpointNode.appendTextChild((Node)loginConfigNode, "realm", descriptor.getRealm());
        }
        if (descriptor.getTransportGuarantee() != null) {
            WLWebServiceEndpointNode.appendTextChild(wseNode, "transport-guarantee", descriptor.getTransportGuarantee());
        }
        if (descriptor.getWsdlExposed() != null) {
            new WSDLNode(descriptor).writeDescriptor(wseNode, descriptor);
        }
        if (descriptor.getStreamAttachments() != null) {
            WLWebServiceEndpointNode.appendTextChild(wseNode, "stream-attachments", descriptor.getStreamAttachments());
        }
        if (descriptor.getValidateRequest() != null) {
            WLWebServiceEndpointNode.appendTextChild(wseNode, "validate-request", descriptor.getValidateRequest());
        }
        if (descriptor.getHttpResponseBufferSize() != null) {
            WLWebServiceEndpointNode.appendTextChild(wseNode, "http-response-buffersize", descriptor.getHttpResponseBufferSize());
        }
        if (descriptor.getReliabilityConfig() != null) {
            ReliabilityConfigNode rmConfigNode = new ReliabilityConfigNode();
            rmConfigNode.writeDescriptor(wseNode, descriptor.getReliabilityConfig());
        }
        return wseNode;
    }

    static {
        UNSUPPORTED_TAGS.add("deployment-listener-list");
        UNSUPPORTED_TAGS.add("transaction-tiemout");
        UNSUPPORTED_TAGS.add("callback-protocol");
        UNSUPPORTED_TAGS.add("http-flush-resposne");
    }

    public static class ServiceEndpointAddressNode
    extends DeploymentDescriptorNode {
        private final XMLElement tag = new XMLElement("service-endpoint-address");
        WebServiceEndpoint descriptor;
        private String contextPath = "";

        public ServiceEndpointAddressNode(WebServiceEndpoint descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        protected XMLElement getXMLRootTag() {
            return this.tag;
        }

        @Override
        public Object getDescriptor() {
            return this.descriptor;
        }

        protected Map getDispatchTable() {
            Map<String, String> table = super.getDispatchTable();
            return table;
        }

        @Override
        public void setElementValue(XMLElement element, String value) {
            String elementName = element.getQName();
            if ("webservice-contextpath".equals(elementName)) {
                if (this.descriptor.implementedByEjbComponent()) {
                    this.contextPath = value;
                }
            } else if ("webservice-serviceuri".equals(elementName)) {
                String serviceuri = value;
                serviceuri = (serviceuri.startsWith("/") ? "" : "/") + serviceuri;
                this.descriptor.setEndpointAddressUri(this.contextPath + serviceuri);
            } else {
                super.setElementValue(element, value);
            }
        }

        @Override
        public Node writeDescriptor(Node parent, WebServiceEndpoint descriptor) {
            String serviceUri;
            String ctxtPath;
            String endpointAddressUri = descriptor.getEndpointAddressUri();
            if (descriptor.implementedByEjbComponent()) {
                ctxtPath = endpointAddressUri.substring(0, endpointAddressUri.lastIndexOf("/") - 1);
                serviceUri = endpointAddressUri.substring(endpointAddressUri.lastIndexOf("/"));
            } else {
                ctxtPath = descriptor.getWebComponentImpl().getWebBundleDescriptor().getContextRoot();
                serviceUri = endpointAddressUri;
            }
            Document doc = ServiceEndpointAddressNode.getOwnerDocument(parent);
            Element serviceEndpointAddress = doc.createElement("service-endpoint-address");
            Element ctxtPathEl = doc.createElement("webservice-contextpath");
            ctxtPathEl.appendChild(doc.createTextNode(ctxtPath));
            serviceEndpointAddress.appendChild(ctxtPathEl);
            Element serviceuriEl = doc.createElement("webservice-serviceuri");
            serviceuriEl.appendChild(doc.createTextNode(serviceUri));
            serviceEndpointAddress.appendChild(serviceuriEl);
            parent.appendChild(serviceEndpointAddress);
            return serviceEndpointAddress;
        }
    }

    public static class WSDLNode
    extends DeploymentDescriptorNode {
        private final XMLElement tag = new XMLElement("wsdl");
        WebServiceEndpoint descriptor;

        public WSDLNode(WebServiceEndpoint descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        protected XMLElement getXMLRootTag() {
            return this.tag;
        }

        @Override
        public Object getDescriptor() {
            return this.descriptor;
        }

        protected Map getDispatchTable() {
            Map<String, String> table = super.getDispatchTable();
            table.put("exposed", "setWsdlExposed");
            return table;
        }

        @Override
        public Node writeDescriptor(Node parent, WebServiceEndpoint descriptor) {
            if (descriptor.getWsdlExposed() != null) {
                Document doc = WSDLNode.getOwnerDocument(parent);
                Element wsdl = doc.createElement("wsdl");
                Element exposed = doc.createElement("exposed");
                exposed.appendChild(doc.createTextNode(descriptor.getWsdlExposed()));
                wsdl.appendChild(exposed);
                parent.appendChild(wsdl);
                return wsdl;
            }
            return null;
        }
    }
}

