/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.resource.spi.ResourceAdapter;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ActiveRAFactory {
    private static Logger _logger = LogDomains.getLogger(ActiveRAFactory.class, "javax.enterprise.resource.resourceadapter");
    @Inject
    private ServiceLocator activeRAHabitat;

    public ActiveResourceAdapter createActiveResourceAdapter(ConnectorDescriptor cd, String moduleName, ClassLoader loader) throws ConnectorRuntimeException {
        ActiveResourceAdapter activeResourceAdapter = null;
        ClassLoader originalContextClassLoader = null;
        ProcessEnvironment.ProcessType processType = ConnectorRuntime.getRuntime().getEnvironment();
        ResourceAdapter ra = null;
        String raClass = cd.getResourceAdapterClass();
        try {
            if (raClass != null && !raClass.equals("")) {
                ra = processType == ProcessEnvironment.ProcessType.Server ? (ResourceAdapter)loader.loadClass(raClass).newInstance() : (ResourceAdapter)Thread.currentThread().getContextClassLoader().loadClass(raClass).newInstance();
            }
            originalContextClassLoader = Utility.setContextClassLoader(loader);
            activeResourceAdapter = this.instantiateActiveResourceAdapter(cd, moduleName, loader, ra);
        }
        catch (ClassNotFoundException Ex) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Error in creating active RAR");
            cre.initCause(Ex);
            _logger.log(Level.SEVERE, "rardeployment.class_not_found", raClass);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        catch (InstantiationException Ex) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Error in creating active RAR");
            cre.initCause(Ex);
            _logger.log(Level.SEVERE, "rardeployment.class_instantiation_error", raClass);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        catch (IllegalAccessException Ex) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Error in creating active RAR");
            cre.initCause(Ex);
            _logger.log(Level.SEVERE, "rardeployment.illegalaccess_error", raClass);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        finally {
            if (originalContextClassLoader != null) {
                Utility.setContextClassLoader(originalContextClassLoader);
            }
        }
        return activeResourceAdapter;
    }

    private ActiveResourceAdapter instantiateActiveResourceAdapter(ConnectorDescriptor cd, String moduleName, ClassLoader loader, ResourceAdapter ra) throws ConnectorRuntimeException {
        ActiveResourceAdapter activeResourceAdapter = this.getActiveRA(cd, moduleName);
        activeResourceAdapter.init(ra, cd, moduleName, loader);
        return activeResourceAdapter;
    }

    private ActiveResourceAdapter getActiveRA(ConnectorDescriptor cd, String moduleName) throws ConnectorRuntimeException {
        List<ActiveResourceAdapter> activeRAs = this.activeRAHabitat.getAllServices(ActiveResourceAdapter.class, new Annotation[0]);
        for (ActiveResourceAdapter activeRA : activeRAs) {
            if (!activeRA.handles(cd, moduleName)) continue;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "found active-RA for the module [ " + moduleName + " ] " + activeRA.getClass().getName());
            }
            return activeRA;
        }
        if (cd.getInBoundDefined()) {
            _logger.log(Level.INFO, "Deployed RAR [ " + moduleName + " ] has inbound artifacts, but the runtime " + "does not support it. Providing only outbound support ");
            return this.activeRAHabitat.getService(ActiveResourceAdapter.class, "ActiveOutboundResourceAdapter", new Annotation[0]);
        }
        throw new ConnectorRuntimeException("Unable to get active RA for module " + moduleName);
    }
}

