/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.schemadoc;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.glassfish.api.admin.config.PropertyDesc;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.Dom;

public class ClassDef {
    private final String def;
    private List<String> interfaces;
    private Set<ClassDef> subclasses = new HashSet<ClassDef>();
    private Map<String, String> types = new HashMap<String, String>();
    private Map<String, Attribute> attributes = new TreeMap<String, Attribute>();
    private boolean deprecated;
    private Set<PropertyDesc> properties = new TreeSet<PropertyDesc>(new Comparator<PropertyDesc>(){

        @Override
        public int compare(PropertyDesc left, PropertyDesc right) {
            return left.name().compareTo(right.name());
        }
    });

    public ClassDef(String def, List<String> interfaces) {
        this.def = def;
        this.interfaces = interfaces;
    }

    public String getDef() {
        return this.def;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDef classDef = (ClassDef)o;
        return !(this.def != null ? !this.def.equals(classDef.def) : classDef.def != null);
    }

    public int hashCode() {
        return this.def != null ? this.def.hashCode() : 0;
    }

    public void addSubclass(ClassDef classDef) {
        this.subclasses.add(classDef);
    }

    public Set<ClassDef> getSubclasses() {
        return this.subclasses;
    }

    public void addAggregatedType(String name, String type2) {
        this.types.put(name, type2);
    }

    public Map<String, String> getAggregatedTypes() {
        return this.types;
    }

    public String toString() {
        return this.def;
    }

    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String name, Attribute annotation) {
        this.attributes.put(Dom.convertName(name), annotation);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(Dom.convertName(name));
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public Set<PropertyDesc> getProperties() {
        return this.properties;
    }

    public void addProperty(PropertyDesc prop) {
        this.properties.add(prop);
    }

    public String getXmlName() {
        return Dom.convertName(this.def.substring(this.def.lastIndexOf(".") + 1));
    }
}

