/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl.operations;

import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class MemberRemoveOperation
extends AbstractClusterOperation {
    private Address deadAddress;

    public MemberRemoveOperation() {
    }

    public MemberRemoveOperation(Address deadAddress) {
        this.deadAddress = deadAddress;
    }

    @Override
    public void run() {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        Address caller = this.getCallerAddress();
        if (caller != null && (caller.equals(this.deadAddress) || caller.equals(clusterService.getMasterAddress()))) {
            ILogger logger2 = this.getLogger();
            if (logger2.isFinestEnabled()) {
                logger2.finest("Removing " + this.deadAddress + ", called from " + caller);
            }
            clusterService.removeAddress(this.deadAddress);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.deadAddress = new Address();
        this.deadAddress.readData(in);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.deadAddress.writeData(out);
    }
}

