/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.client.adapter;

import fish.payara.ejb.http.client.adapter.ClientAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.naming.Context;
import javax.naming.NamingException;

public final class CompositeClientAdapter
implements ClientAdapter {
    private final List<ClientAdapter> adapters;

    private CompositeClientAdapter(Builder builder) {
        this.adapters = new ArrayList<ClientAdapter>(builder.adapters);
    }

    @Override
    public Optional<Object> makeLocalProxy(String jndiName, Context remoteContext) throws NamingException {
        for (ClientAdapter adapter : this.adapters) {
            Optional<Object> result = adapter.makeLocalProxy(jndiName, remoteContext);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ClientAdapter> adapters = new ArrayList<ClientAdapter>();

        public CompositeClientAdapter build() {
            return new CompositeClientAdapter(this);
        }

        public Builder register(Class<? extends ClientAdapter> ... adapterClasses) {
            for (Class<? extends ClientAdapter> adapterClass : adapterClasses) {
                ClientAdapter instance = Builder.instantiate(adapterClass);
                this.register(instance);
            }
            return this;
        }

        public Builder register(ClientAdapter ... adapterInstances) {
            Stream.of(adapterInstances).forEach(this::register);
            return this;
        }

        private void register(ClientAdapter adapterSupplier) {
            this.adapters.add(adapterSupplier);
        }

        static ClientAdapter instantiate(Class<? extends ClientAdapter> adapterClass) {
            try {
                return adapterClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Cannot instantiate " + adapterClass.getName(), e);
            }
        }
    }
}

