/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.client;

import fish.payara.ejb.http.client.EjbHttpProxyHandlerV1;
import fish.payara.ejb.http.client.Lookup;
import fish.payara.ejb.http.protocol.ErrorResponse;
import fish.payara.ejb.http.protocol.LookupRequest;
import fish.payara.ejb.http.protocol.LookupResponse;
import fish.payara.ejb.http.protocol.SerializationType;
import fish.payara.ejb.http.protocol.rs.ObjectStreamMessageBodyReader;
import fish.payara.ejb.http.protocol.rs.ObjectStreamMessageBodyWriter;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Map;
import javax.naming.NamingException;

public class LookupV1
extends Lookup {
    private final Client client;
    private final WebTarget v1lookup;
    private final String mediaType;

    LookupV1(Map<String, Object> environment, Client client, WebTarget v1lookup) {
        super(environment);
        this.client = (Client)((Client)client.register(ObjectStreamMessageBodyWriter.class)).register(ObjectStreamMessageBodyReader.class);
        this.v1lookup = (WebTarget)((WebTarget)v1lookup.register(ObjectStreamMessageBodyReader.class)).register(ObjectStreamMessageBodyWriter.class);
        this.mediaType = environment.containsKey("fish.payara.ejb.http.serialization") ? SerializationType.valueOf(environment.get("fish.payara.ejb.http.serialization").toString().toUpperCase()).getMediaType() : "application/json";
    }

    @Override
    Object lookup(String jndiName) throws NamingException {
        Response response;
        block11: {
            Entity body = Entity.entity((Object)new LookupRequest(jndiName), (String)this.mediaType);
            response = this.v1lookup.request(new String[]{this.mediaType}).buildPost(body).invoke();
            if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
                String className = ((LookupResponse)response.readEntity(LookupResponse.class)).typeName;
                try {
                    Class<?> remoteBusinessInterface = Class.forName(className);
                    Object obj = LookupV1.newProxy(remoteBusinessInterface, this.client.target(response.getLocation()), this.mediaType, jndiName, this.environment);
                    return obj;
                }
                catch (ClassNotFoundException ex) {
                    throw LookupV1.wrap("Local class " + className + " does not exist for JNDI name: " + className, ex);
                }
            }
            if (response.getMediaType().toString().equals(this.mediaType)) break block11;
            throw new NamingException((String)response.readEntity(String.class));
        }
        Exception ex = LookupV1.deserialise((ErrorResponse)response.readEntity(ErrorResponse.class));
        if (ex instanceof NamingException) {
            throw (NamingException)ex;
        }
        throw LookupV1.wrap("Lookup failed for `" + jndiName + "` [" + this.mediaType + "]. Remote exception: ", ex);
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    static Exception deserialise(ErrorResponse error) {
        Exception ex = null;
        try {
            ex = (Exception)Class.forName(error.exceptionType).getConstructor(String.class).newInstance(error.message);
        }
        catch (Exception e) {
            ex = new NamingException("Remote exception: " + error.exceptionType + ": " + error.message);
        }
        if (error.cause != null) {
            ((Throwable)ex).initCause(LookupV1.deserialise(error.cause));
        }
        return ex;
    }

    private static <C> C newProxy(Class<C> remoteBusinessInterface, WebTarget invoke, String mediaType, String jndiName, Map<String, Object> jndiOptions) {
        return (C)Proxy.newProxyInstance(AccessController.doPrivileged(remoteBusinessInterface::getClassLoader), new Class[]{remoteBusinessInterface}, (InvocationHandler)new EjbHttpProxyHandlerV1(mediaType, invoke, jndiName, jndiOptions));
    }
}

