/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.client;

import fish.payara.ejb.http.client.Lookup;
import fish.payara.ejb.http.client.LookupDiscoveryResponse;
import fish.payara.ejb.http.client.LookupDiscoveryServiceImpl;
import fish.payara.ejb.http.client.LookupV0;
import fish.payara.ejb.http.client.LookupV1;
import fish.payara.ejb.http.client.adapter.ClientAdapter;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.Configuration;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.util.Hashtable;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

class RemoteEJBContext
implements Context {
    private static final Logger logger = Logger.getLogger(LookupV0.class.getName());
    private ClientAdapter clientAdapter;
    private Hashtable<String, Object> environment;
    private Lookup lookup;

    public RemoteEJBContext(Hashtable<String, Object> environment) {
        Object adapter;
        this.environment = environment;
        if (environment.containsKey("fish.payara.clientAdapter") && (adapter = environment.get("fish.payara.clientAdapter")) instanceof ClientAdapter) {
            this.clientAdapter = (ClientAdapter)adapter;
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("Lookup name cannot be null");
        }
        String url = (String)this.environment.get("java.naming.provider.url");
        try {
            Optional<Object> resolvedAdapter;
            if (this.clientAdapter != null && (resolvedAdapter = this.clientAdapter.makeLocalProxy(name, this)).isPresent()) {
                return resolvedAdapter.get();
            }
            URI remotePayaraURI = new URL(url).toURI();
            return this.lookup(remotePayaraURI).lookup(name);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Exception e) {
            throw RemoteEJBContext.newNamingException(name, e);
        }
    }

    private synchronized Lookup lookup(URI root) throws NamingException {
        if (this.lookup == null) {
            this.lookup = this.determineLookup(root);
        }
        return this.lookup;
    }

    private Lookup determineLookup(URI root) throws NamingException {
        try {
            Client client = this.getClientBuilder().build();
            LookupDiscoveryResponse discovery = new LookupDiscoveryServiceImpl().discover(client, root);
            Integer version = this.getVersion(discovery);
            if (discovery.isV1target() && (version == null || version == 1)) {
                logger.log(Level.INFO, "Discovered v1 at {0}", discovery.getV1lookup().getUri());
                return new LookupV1(this.environment, client, discovery.getV1lookup());
            }
            if (discovery.isV0target() && (version == null || version == 0)) {
                logger.log(Level.INFO, "Discovered v0 at {0}", discovery.getV0lookup().getUri());
                return new LookupV0(this.environment, client.target(discovery.getResolvedRoot()), discovery.getV0lookup());
            }
            throw new NamingException("EJB HTTP client V0 is not supported, out of ideas for now");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw RemoteEJBContext.newNamingException("Cannot access lookup endpoint at " + root, e);
        }
    }

    private Integer getVersion(LookupDiscoveryResponse discovery) {
        Object versionSetting = this.environment.get("fish.payara.ejb.http.version");
        if (versionSetting == null) {
            return null;
        }
        int version = versionSetting instanceof String ? Integer.parseInt(versionSetting.toString()) : ((Number)versionSetting).intValue();
        return version == 1 && discovery.isV1target() || version == 0 && discovery.isV0target() ? Integer.valueOf(version) : null;
    }

    private ClientBuilder getClientBuilder() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object value;
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (this.environment.containsKey("fish.payara.connectTimeout")) {
            clientBuilder.connectTimeout(RemoteEJBContext.getLong(this.environment.get("fish.payara.connectTimeout")).longValue(), TimeUnit.MICROSECONDS);
        }
        if (this.environment.containsKey("fish.payara.executorService")) {
            clientBuilder.executorService(RemoteEJBContext.getInstance(this.environment.get("fish.payara.executorService"), ExecutorService.class));
        }
        if (this.environment.containsKey("fish.payara.hostnameVerifier")) {
            clientBuilder.hostnameVerifier(RemoteEJBContext.getInstance(this.environment.get("fish.payara.hostnameVerifier"), HostnameVerifier.class));
        }
        if (this.environment.containsKey("fish.payara.keyStore")) {
            clientBuilder.keyStore(RemoteEJBContext.getInstance(this.environment.get("fish.payara.keyStore"), KeyStore.class), RemoteEJBContext.getPassword(this.environment.containsKey("keyStorePassword") ? this.environment.get("keyStorePassword") : this.environment.get("fish.payara.keyStorePassword")));
        }
        if (this.environment.containsKey("fish.payara.readTimeout")) {
            clientBuilder.readTimeout(RemoteEJBContext.getLong(this.environment.get("fish.payara.readTimeout")).longValue(), TimeUnit.MICROSECONDS);
        }
        if (this.environment.containsKey("fish.payara.scheduledExecutorService")) {
            clientBuilder.scheduledExecutorService(RemoteEJBContext.getInstance(this.environment.get("fish.payara.scheduledExecutorService"), ScheduledExecutorService.class));
        }
        if (this.environment.containsKey("fish.payara.sslContext")) {
            clientBuilder.sslContext(RemoteEJBContext.getInstance(this.environment.get("fish.payara.sslContext"), SSLContext.class));
        }
        if (this.environment.containsKey("fish.payara.trustStore")) {
            clientBuilder.trustStore(RemoteEJBContext.getInstance(this.environment.get("fish.payara.trustStore"), KeyStore.class));
        }
        if (this.environment.containsKey("fish.payara.withConfig")) {
            clientBuilder.withConfig(RemoteEJBContext.getInstance(this.environment.get("fish.payara.withConfig"), Configuration.class));
        }
        if (this.environment.containsKey("fish.payara.requestFilter")) {
            value = this.environment.get("fish.payara.requestFilter");
            if (value instanceof Class && ClientRequestFilter.class.isAssignableFrom((Class)value)) {
                clientBuilder.register((Class)value);
            } else if (value instanceof ClientRequestFilter) {
                clientBuilder.register((Object)((ClientRequestFilter)value));
            }
        }
        if (this.environment.containsKey("fish.payara.responseFilter")) {
            value = this.environment.get("fish.payara.responseFilter");
            if (value instanceof Class && ClientResponseFilter.class.isAssignableFrom((Class)value)) {
                clientBuilder.register((Class)value);
            } else if (value instanceof ClientResponseFilter) {
                clientBuilder.register((Object)((ClientResponseFilter)value));
            }
        }
        String providerPrincipal = (String)this.environment.get("fish.payara.provider.principal");
        String providerCredentials = (String)this.environment.get("fish.payara.provider.credentials");
        if (providerPrincipal != null && providerCredentials != null) {
            String authType = (String)this.environment.get("fish.payara.provider.authType");
            if (null == authType || "BASIC".equals(authType)) {
                clientBuilder.register((Object)HttpAuthenticationFeature.basic((String)providerPrincipal, (String)providerCredentials));
            } else if ("DIGEST".equals(authType)) {
                clientBuilder.register((Object)HttpAuthenticationFeature.digest((String)providerPrincipal, (String)providerCredentials));
            }
        }
        return clientBuilder;
    }

    private static NamingException newNamingException(String name, Exception cause) {
        NamingException namingException = new NamingException("Could not lookup: " + name);
        namingException.initCause(cause);
        return namingException;
    }

    private static <T> T getInstance(Object value, Class<T> clazz) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        if (value instanceof String) {
            return clazz.cast(Class.forName((String)value).newInstance());
        }
        throw new IllegalStateException("Value " + value + " has to be of type String or " + clazz);
    }

    private static Long getLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        throw new IllegalStateException("Value " + value + " has to be of type String or Number");
    }

    private static char[] getPassword(Object value) {
        if (value instanceof String) {
            return ((String)value).toCharArray();
        }
        if (value instanceof char[]) {
            return (char[])value;
        }
        throw new IllegalArgumentException("No password provided");
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
        this.environment.clear();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new UnsupportedOperationException();
    }
}

