/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.client;

import fish.payara.ejb.http.client.LookupDiscoveryResponse;
import fish.payara.ejb.http.client.LookupDiscoveryService;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import javax.naming.NamingException;

class LookupDiscoveryServiceImpl
implements LookupDiscoveryService {
    static final String INVOKER_V1_REL = "https://payara.fish/ejb-http-invoker/v1";
    static final String INVOKER_V0_REL = "https://payara.fish/ejb-http-invoker/v0";

    LookupDiscoveryServiceImpl() {
    }

    @Override
    public LookupDiscoveryResponse discover(Client client, URI root) throws NamingException {
        try (Response optionResponse = client.target(root).request().head();){
            Response.Status.Family responseFamily = optionResponse.getStatusInfo().getFamily();
            if (responseFamily == Response.Status.Family.REDIRECTION) {
                URI resolvedRoot = root.resolve(optionResponse.getLocation());
                try (Response redirctedOptionResponse = LookupDiscoveryServiceImpl.followRedirect(client, resolvedRoot);){
                    LookupDiscoveryResponse lookupDiscoveryResponse = LookupDiscoveryServiceImpl.createDiscovery(client, resolvedRoot, redirctedOptionResponse);
                    return lookupDiscoveryResponse;
                }
            }
            LookupDiscoveryResponse lookupDiscoveryResponse = LookupDiscoveryServiceImpl.createDiscovery(client, root, optionResponse);
            return lookupDiscoveryResponse;
        }
    }

    private static LookupDiscoveryResponse createDiscovery(Client client, URI root, Response optionResponse) throws NamingException {
        Response.Status.Family responseFamily = optionResponse.getStatusInfo().getFamily();
        if (responseFamily == Response.Status.Family.SUCCESSFUL) {
            return LookupDiscoveryServiceImpl.discoverLinks(client, root, optionResponse);
        }
        String reasonPhrase = optionResponse.getStatusInfo().getReasonPhrase();
        if (responseFamily == Response.Status.Family.CLIENT_ERROR) {
            if (optionResponse.getStatusInfo().toEnum() == Response.Status.NOT_FOUND) {
                return LookupDiscoveryServiceImpl.discoverV0(client, root);
            }
            throw new NamingException("Invoker is not available at <" + root + ">: " + reasonPhrase);
        }
        if (responseFamily == Response.Status.Family.SERVER_ERROR) {
            throw new NamingException("Server is not available at <" + root + ">: " + reasonPhrase);
        }
        throw new NamingException("Unexpected status of invoker root resource <" + root + ">: " + reasonPhrase);
    }

    private static LookupDiscoveryResponse discoverV0(Client client, URI resolvedRoot) throws NamingException {
        WebTarget invokerServletTarget = client.target(resolvedRoot).path("ejb/");
        try (Response v0response = invokerServletTarget.request().head();){
            if (v0response.getStatusInfo().toEnum() == Response.Status.OK) {
                LookupDiscoveryResponse lookupDiscoveryResponse = new LookupDiscoveryResponse(resolvedRoot, invokerServletTarget.path("lookup"));
                return lookupDiscoveryResponse;
            }
            throw new NamingException("Invoker V0 not found at <" + invokerServletTarget.getUri() + ">: " + v0response.getStatusInfo().getReasonPhrase());
        }
    }

    private static Response followRedirect(Client client, URI root) throws NamingException {
        Response redirectedResponse = client.target(root).request().head();
        if (redirectedResponse.getStatusInfo().getFamily() == Response.Status.Family.REDIRECTION) {
            throw new NamingException("Multiple redirects when finding root resource: <" + root + "> -> <" + root + "> -> (not followed) <" + redirectedResponse.getLocation() + ">");
        }
        return redirectedResponse;
    }

    private static LookupDiscoveryResponse discoverLinks(Client client, URI resolvedRoot, Response optionResponse) throws NamingException {
        Link v0Link = optionResponse.getLink(INVOKER_V0_REL);
        Link v1Link = optionResponse.getLink(INVOKER_V1_REL);
        if (v0Link == null && v1Link == null) {
            return LookupDiscoveryServiceImpl.discoverV0(client, resolvedRoot);
        }
        return new LookupDiscoveryResponse(resolvedRoot, v0Link == null ? null : client.target(resolvedRoot.resolve(v0Link.getUri())), v1Link == null ? null : client.target(resolvedRoot.resolve(v1Link.getUri())));
    }
}

