/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.client;

import fish.payara.ejb.http.client.Lookup;
import fish.payara.ejb.http.client.LookupV1;
import fish.payara.ejb.http.protocol.ErrorResponse;
import fish.payara.ejb.http.protocol.InvokeMethodRequest;
import fish.payara.ejb.http.protocol.InvokeMethodResponse;
import fish.payara.ejb.http.protocol.rs.InvokeMethodResponseJsonBodyReader;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Map;

final class EjbHttpProxyHandlerV1
implements InvocationHandler {
    private final String mediaType;
    private final WebTarget invoke;
    private final String jndiName;
    private final Map<String, Object> jndiOptions;

    public EjbHttpProxyHandlerV1(String mediaType, WebTarget invoke, String jndiName, Map<String, Object> jndiOptions) {
        this.jndiName = jndiName;
        this.jndiOptions = jndiOptions;
        this.invoke = mediaType.equals("application/json") ? (WebTarget)invoke.register(InvokeMethodResponseJsonBodyReader.class) : invoke;
        this.mediaType = mediaType;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args == null && method.getName().equals("toString")) {
            return this.toString();
        }
        if (args == null && method.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (args != null && args.length == 1 && method.getName().equals("equals")) {
            return this.equals(args[0]);
        }
        return this.invokeRemote(method, args);
    }

    private Object invokeRemote(Method method, Object[] args) throws Exception {
        InvokeMethodRequest request = this.createRequest(method, args);
        Throwable throwable = null;
        try (Response response = this.invoke.request(new String[]{this.mediaType}).buildPost(Entity.entity((Object)request, (String)this.mediaType)).invoke();){
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                Object object = ((InvokeMethodResponse)response.readEntity(InvokeMethodResponse.class, (Annotation[])InvokeMethodResponse.ResultType.of((Method)method))).result;
                return object;
            }
            try {
                ErrorResponse error = (ErrorResponse)response.readEntity(ErrorResponse.class);
                throw LookupV1.deserialise(error);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private InvokeMethodRequest createRequest(Method method, Object[] args) {
        String principal = this.jndiOptions.containsKey("java.naming.security.principal") ? Lookup.base64Encode(this.jndiOptions.get("java.naming.security.principal")) : "";
        String credentials = this.jndiOptions.containsKey("java.naming.security.credentials") ? Lookup.base64Encode(this.jndiOptions.get("java.naming.security.credentials")) : "";
        String[] argTypes = (String[])Arrays.asList(method.getParameterTypes()).stream().map(type -> type.getName()).toArray(String[]::new);
        String[] argActualTypes = args == null ? new String[]{} : (String[])Arrays.asList(args).stream().map(arg -> arg == null ? null : arg.getClass().getName()).toArray(String[]::new);
        for (int i = 0; i < argTypes.length; ++i) {
            if (argActualTypes[i] != null) continue;
            argActualTypes[i] = argTypes[i];
        }
        return new InvokeMethodRequest(principal, credentials, this.jndiName, method.getName(), argTypes, argActualTypes, this.packArguments(args), null);
    }

    private Object packArguments(Object[] args) {
        Object[] argValues = args;
        if ("application/x-java-object".equals(this.mediaType)) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(argValues);
            }
            catch (IOException e) {
                throw new UndeclaredThrowableException(e);
            }
            argValues = bos.toByteArray();
        }
        return argValues;
    }
}

