/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.protocol.rs;

import fish.payara.ejb.http.protocol.InvokeMethodResponse;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;

public class InvokeMethodResponseDeserializer
implements JsonbDeserializer<InvokeMethodResponse> {
    private final Type methodReturntype;

    public InvokeMethodResponseDeserializer(Type methodReturntype) {
        this.methodReturntype = methodReturntype;
    }

    public InvokeMethodResponse deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        String type = null;
        Object result = null;
        boolean resultPresent = false;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            if (event == JsonParser.Event.KEY_NAME && parser.getString().equals("type")) {
                parser.next();
                type = parser.getString();
                continue;
            }
            if (event != JsonParser.Event.KEY_NAME || !parser.getString().equals("result")) continue;
            Type resultClass = this.determineClass(type);
            result = ctx.deserialize(resultClass, parser);
            resultPresent = true;
        }
        if (!resultPresent) {
            result = JsonbBuilder.create().fromJson("null", this.determineClass(type));
        }
        return new InvokeMethodResponse(result);
    }

    private Type determineClass(String type) {
        if (this.methodReturntype instanceof ParameterizedType || type == null) {
            return this.methodReturntype;
        }
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            return this.methodReturntype;
        }
    }
}

