/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.protocol;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.stream.Stream;
import javax.json.bind.annotation.JsonbPropertyOrder;

@JsonbPropertyOrder(value={"type", "result"})
public class InvokeMethodResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String type;
    public final Object result;

    public InvokeMethodResponse(Object result) {
        this(result == null ? "" : result.getClass().getName(), result);
    }

    public InvokeMethodResponse(String type, Object result) {
        this.type = type;
        this.result = result;
    }

    public static class ResultType
    implements Annotation {
        public final Type type;

        @Override
        public Class<? extends Annotation> annotationType() {
            return ResultType.class;
        }

        public ResultType(Method method) {
            this.type = method.getGenericReturnType();
        }

        public static Annotation[] of(Method method) {
            return new Annotation[]{new ResultType(method)};
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean isPresent(Annotation[] annotations) {
            if (annotations == null) return false;
            if (!Stream.of(annotations).anyMatch(ResultType.class::isInstance)) return false;
            return true;
        }

        public static ResultType find(Annotation[] annotations) {
            Optional<Object> found = Optional.empty();
            if (annotations != null) {
                found = Stream.of(annotations).filter(ResultType.class::isInstance).map(ResultType.class::cast).findAny();
            }
            return (ResultType)found.orElseThrow(() -> new IllegalArgumentException("ResultType annotation is not present"));
        }
    }
}

