/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cloud.connectors.kafka.outbound;

import fish.payara.cloud.connectors.kafka.api.KafkaConnection;
import fish.payara.cloud.connectors.kafka.outbound.KafkaManagedConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.resource.ResourceException;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;

class KafkaConnectionImpl
implements KafkaConnection {
    private KafkaManagedConnection realConn;

    public KafkaConnectionImpl(KafkaManagedConnection realConn) {
        this.realConn = realConn;
    }

    @Override
    public void close() throws ResourceException {
        this.checkValidity();
        try {
            this.realConn.remove(this);
            this.realConn = null;
        }
        catch (Exception ex) {
            throw new ResourceException((Throwable)ex);
        }
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord record) throws ResourceException {
        this.checkValidity();
        return this.realConn.send(record);
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord record, Callback callback) throws ResourceException {
        this.checkValidity();
        return this.realConn.send(record, callback);
    }

    @Override
    public void flush() throws ResourceException {
        this.checkValidity();
        this.realConn.flush();
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) throws ResourceException {
        this.checkValidity();
        return this.realConn.partitionsFor(topic);
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() throws ResourceException {
        this.checkValidity();
        return this.realConn.metrics();
    }

    KafkaManagedConnection getRealConn() {
        return this.realConn;
    }

    void setRealConn(KafkaManagedConnection realConn) {
        this.realConn = realConn;
    }

    private void checkValidity() throws ResourceException {
        if (this.realConn == null) {
            throw new ResourceException("Not Associated with a Kafka Producer");
        }
    }
}

