/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.notification.requesttracing;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class RequestTraceSpanLog
implements Serializable {
    private final long timeMillis;
    private final Map<String, String> logEntries;

    public RequestTraceSpanLog() {
        this.timeMillis = System.currentTimeMillis();
        this.logEntries = new LinkedHashMap<String, String>();
    }

    public RequestTraceSpanLog(long timestampMillis) {
        this.timeMillis = timestampMillis;
        this.logEntries = new LinkedHashMap<String, String>();
    }

    public RequestTraceSpanLog(String logName) {
        this.timeMillis = System.currentTimeMillis();
        this.logEntries = new LinkedHashMap<String, String>();
        this.logEntries.put("logEvent", logName);
    }

    public RequestTraceSpanLog(long timestampMillis, String logName) {
        this.timeMillis = timestampMillis;
        this.logEntries = new LinkedHashMap<String, String>();
        this.logEntries.put("logEvent", logName);
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public Map<String, String> getLogEntries() {
        return this.logEntries;
    }

    public void addLogEntry(String entry, String value) {
        if (value != null) {
            this.logEntries.put(entry, value.replaceAll("\"", "\\\""));
        } else {
            this.logEntries.put(entry, value);
        }
    }
}

