/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.notification.requesttracing;

import io.opentracing.SpanContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class RequestTraceSpanContext
implements Serializable,
SpanContext {
    private static final long serialVersionUID = 20180803L;
    private final UUID spanId;
    private UUID traceId;
    private final Map<String, String> baggageItems;

    protected RequestTraceSpanContext() {
        this.spanId = UUID.randomUUID();
        this.traceId = UUID.randomUUID();
        this.baggageItems = new HashMap<String, String>();
    }

    protected RequestTraceSpanContext(UUID traceId) {
        this.spanId = UUID.randomUUID();
        this.traceId = traceId;
        this.baggageItems = new HashMap<String, String>();
    }

    public RequestTraceSpanContext(UUID traceId, UUID parentId) {
        this.spanId = parentId;
        this.traceId = traceId;
        this.baggageItems = new HashMap<String, String>();
    }

    public RequestTraceSpanContext(UUID traceId, UUID parentId, Map<String, String> baggageItems) {
        this.spanId = parentId;
        this.traceId = traceId;
        this.baggageItems = new HashMap<String, String>(baggageItems);
    }

    public UUID getSpanId() {
        return this.spanId;
    }

    public UUID getTraceId() {
        return this.traceId;
    }

    public void setTraceId(UUID traceId) {
        this.traceId = traceId;
    }

    public void addBaggageItem(String name, String value) {
        if (value != null) {
            this.baggageItems.put(name, value.replaceAll("\"", "\\\""));
        } else {
            this.baggageItems.put(name, value);
        }
    }

    public Map<String, String> getBaggageItems() {
        return this.baggageItems;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.getBaggageItems().entrySet();
    }
}

