/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal.jdom;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.filter.ContentFilter;
import org.jdom2.filter.Filter;
import org.jdom2.input.SAXBuilder;
import org.jdom2.located.LocatedJDOMFactory;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.util.IteratorIterable;

public final class JDomDocumentIO
implements Closeable {
    private final Path xmlFile;
    private final String lineSeparator;
    private final String body;
    private final String head;
    private final String tail;
    private final Document document;

    public JDomDocumentIO(Path xmlFile) throws IOException {
        this(xmlFile, System.lineSeparator());
    }

    public JDomDocumentIO(Path xmlFile, String lineSeparator) throws IOException {
        this.xmlFile = Objects.requireNonNull(xmlFile, "xmlFile");
        this.lineSeparator = Objects.requireNonNull(lineSeparator, "lineSeparator");
        this.body = JDomDocumentIO.normalizeLineEndings(Files.readString(xmlFile, StandardCharsets.UTF_8), lineSeparator);
        SAXBuilder builder = new SAXBuilder();
        builder.setJDOMFactory((JDOMFactory)new LocatedJDOMFactory());
        try {
            this.document = builder.build((Reader)new StringReader(this.body));
        }
        catch (JDOMException e) {
            throw new IOException(e);
        }
        JDomDocumentIO.normaliseLineEndings(this.document, lineSeparator);
        int headIndex = this.body.indexOf("<" + this.document.getRootElement().getName());
        this.head = headIndex >= 0 ? this.body.substring(0, headIndex) : null;
        String lastTag = "</" + this.document.getRootElement().getName() + ">";
        int tailIndex = this.body.lastIndexOf(lastTag);
        this.tail = tailIndex >= 0 ? this.body.substring(tailIndex + lastTag.length()) : null;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public void close() throws IOException {
        ByteArrayOutputStream output;
        Format format = Format.getRawFormat();
        format.setLineSeparator(this.lineSeparator);
        XMLOutputter out = new XMLOutputter(format);
        try (ByteArrayOutputStream outputStream = output = new ByteArrayOutputStream();){
            if (this.head != null) {
                outputStream.write(this.head.getBytes(StandardCharsets.UTF_8));
            }
            out.output(this.document.getRootElement(), (OutputStream)outputStream);
            if (this.tail != null) {
                outputStream.write(this.tail.getBytes(StandardCharsets.UTF_8));
            }
        }
        String newBody = output.toString(StandardCharsets.UTF_8);
        if (!Objects.equals(this.body, newBody)) {
            Files.writeString(this.xmlFile, (CharSequence)newBody, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    private static void normaliseLineEndings(Document document, String lineSeparator) {
        Comment c;
        IteratorIterable i = document.getDescendants((Filter)new ContentFilter(8));
        while (i.hasNext()) {
            c = (Comment)i.next();
            c.setText(JDomDocumentIO.normalizeLineEndings(c.getText(), lineSeparator));
        }
        i = document.getDescendants((Filter)new ContentFilter(2));
        while (i.hasNext()) {
            c = (CDATA)i.next();
            c.setText(JDomDocumentIO.normalizeLineEndings(c.getText(), lineSeparator));
        }
    }

    private static String normalizeLineEndings(String text, String separator) {
        String norm = text;
        if (text != null) {
            norm = text.replaceAll("(\r\n)|(\n)|(\r)", separator);
        }
        return norm;
    }
}

