/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal.jdom;

import eu.maveniverse.maven.toolbox.shared.internal.jdom.JDomContentHelper;
import eu.maveniverse.maven.toolbox.shared.internal.jdom.JDomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;

public class JDomCleanupHelper {
    public static void cleanup(Element rootElement) {
        for (String cleanUpEmptyElement : List.of("modules", "properties", "plugins", "pluginManagement", "dependencies", "dependencyManagement")) {
            JDomCleanupHelper.cleanupEmptyElements(rootElement, cleanUpEmptyElement);
        }
        JDomCleanupHelper.cleanupEmptyProfiles(rootElement, List.of("project"));
    }

    public static void cleanupEmptyProfiles(Element rootElement, List<String> profilesParents) {
        IteratorIterable filteredElements = rootElement.getDescendants((Filter)new ElementFilter("profiles"));
        ArrayList<Element> profiles = new ArrayList<Element>();
        for (Element profilesElement : filteredElements) {
            profiles.add(profilesElement);
        }
        for (Element profilesElement : profiles) {
            if (!profilesParents.contains(profilesElement.getParentElement().getName())) continue;
            JDomCleanupHelper.removeElementWithEmptyChildren(profilesElement, "profile", Arrays.asList("id", "activation"));
            if (profilesElement.getDescendants((Filter)new ElementFilter("profile")).hasNext()) continue;
            JDomUtils.removeChildAndItsCommentFromContent(profilesElement.getParentElement(), (Content)profilesElement);
        }
    }

    public static void cleanupEmptyElements(Element rootElement, String tag) {
        IteratorIterable filteredElements = rootElement.getDescendants((Filter)new ElementFilter(tag));
        ArrayList<Element> elementsToRemoveIfEmpty = new ArrayList<Element>();
        for (Element element : filteredElements) {
            elementsToRemoveIfEmpty.add(element);
        }
        for (Element elementToRemove : elementsToRemoveIfEmpty) {
            List children = elementToRemove.getChildren();
            if (!children.isEmpty()) continue;
            JDomUtils.removeChildAndItsCommentFromContent(elementToRemove.getParentElement(), (Content)elementToRemove);
        }
    }

    public static void squashMultilines(Element rootElement) {
        ArrayList newLineGroups = new ArrayList();
        ArrayList<Text> currentGroup = new ArrayList<Text>();
        for (Content content : rootElement.getDescendants()) {
            if (JDomContentHelper.hasNewlines(content)) {
                Element parent;
                if (!currentGroup.isEmpty() && !(parent = ((Text)currentGroup.get(0)).getParent()).equals((Object)content.getParentElement())) {
                    newLineGroups.add(currentGroup);
                    currentGroup = new ArrayList();
                }
                currentGroup.add((Text)content);
                continue;
            }
            if (currentGroup.isEmpty()) continue;
            newLineGroups.add(currentGroup);
            currentGroup = new ArrayList();
        }
        if (!currentGroup.isEmpty()) {
            newLineGroups.add(currentGroup);
        }
        for (List list : newLineGroups) {
            int newlineCount = 0;
            for (Text text : list) {
                newlineCount += StringUtils.countMatches((String)text.getText(), (String)"\n");
            }
            if (newlineCount <= 2) continue;
            Text last = (Text)list.get(list.size() - 1);
            last.setText("\n\n" + last.getText().replaceAll("\n", ""));
            list.remove(last);
            for (Text text : list) {
                text.getParentElement().removeContent((Content)text);
                text.detach();
            }
        }
    }

    private static void removeElementWithEmptyChildren(Element parent, String tagName, List<String> ignoreChildren) {
        IteratorIterable filteredElements = parent.getDescendants((Filter)new ElementFilter(tagName));
        ArrayList<Object> contentToBeRemoved = new ArrayList<Object>();
        for (Element element : filteredElements) {
            boolean empty = true;
            for (Element child : element.getChildren()) {
                if (ignoreChildren.contains(child.getName()) || child.getChildren().isEmpty()) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            contentToBeRemoved.add(element);
            contentToBeRemoved.addAll(JDomCleanupHelper.getAttachedComments(element));
        }
        for (Content content : contentToBeRemoved) {
            JDomUtils.removeChildAndItsCommentFromContent(parent, content);
        }
    }

    private static List<Content> getAttachedComments(Element element) {
        ArrayList<Content> contents = new ArrayList<Content>();
        List<Content> siblings = JDomCleanupHelper.getDirectContents(element.getParentElement());
        int indexOfElement = siblings.indexOf(element);
        for (int i = indexOfElement - 1; i >= 0; --i) {
            if (JDomContentHelper.isNewline(siblings.get(i))) {
                contents.add(siblings.get(i));
                --i;
            }
            if (i < 0 || !(siblings.get(i) instanceof Comment)) {
                if (i < 0 || !JDomContentHelper.isMultiNewLine(siblings.get(i))) break;
                contents.add(siblings.get(i));
                break;
            }
            contents.add(siblings.get(i));
        }
        return contents;
    }

    private static List<Content> getDirectContents(Element element) {
        ArrayList<Content> children = new ArrayList<Content>();
        Element parentElement = element.getParentElement();
        if (null == parentElement) {
            return children;
        }
        for (Content descendant : parentElement.getDescendants()) {
            if (!descendant.getParent().equals((Object)element)) continue;
            children.add(descendant);
        }
        return children;
    }
}

