/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.eclipse.aether.artifact.Artifact;

public final class UnpackSink
implements Artifacts.Sink {
    private final Output output;
    private final Path directory;
    private final boolean directoryCreated;
    private final Predicate<Artifact> artifactMatcher;
    private final boolean failIfUnmatched;
    private final Function<Artifact, Artifact> artifactMapper;
    private final Function<Artifact, String> artifactRootMapper;
    private final Function<String, String> fileNameMapper;
    private final boolean allowRootOverwrite;
    private final boolean allowEntryOverwrite;
    private final boolean dryRun;
    private final HashSet<Path> writtenPaths;

    public static UnpackSink unpack(Output output, Path path, Function<Artifact, String> artifactRootMapper, boolean allowEntryOverwrite, boolean dryRun) throws IOException {
        return new UnpackSink(output, path, ArtifactMatcher.unique(), false, a -> a, artifactRootMapper, Function.identity(), true, allowEntryOverwrite, dryRun);
    }

    private UnpackSink(Output output, Path directory, Predicate<Artifact> artifactMatcher, boolean failIfUnmatched, Function<Artifact, Artifact> artifactMapper, Function<Artifact, String> artifactRootMapper, Function<String, String> fileNameMapper, boolean allowRootOverwrite, boolean allowEntryOverwrite, boolean dryRun) throws IOException {
        this.output = Objects.requireNonNull(output, "output");
        this.directory = Objects.requireNonNull(directory, "directory").toAbsolutePath();
        if (Files.exists(directory, new LinkOption[0]) && !Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("directory must not exists, or must be a directory");
        }
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
            this.directoryCreated = true;
        } else {
            this.directoryCreated = false;
        }
        this.artifactMatcher = Objects.requireNonNull(artifactMatcher, "artifactMatcher");
        this.failIfUnmatched = failIfUnmatched;
        this.artifactMapper = Objects.requireNonNull(artifactMapper, "artifactMapper");
        this.artifactRootMapper = Objects.requireNonNull(artifactRootMapper, "artifactRootMapper");
        this.fileNameMapper = Objects.requireNonNull(fileNameMapper, "fileNameMapper");
        this.allowRootOverwrite = allowRootOverwrite;
        this.allowEntryOverwrite = allowEntryOverwrite;
        this.dryRun = dryRun;
        this.writtenPaths = new HashSet();
    }

    public Path getDirectory() {
        return this.directory;
    }

    @Override
    public void accept(Artifact artifact) throws IOException {
        block20: {
            block19: {
                Objects.requireNonNull(artifact, "artifact");
                this.output.chatter("Accept artifact {}", artifact);
                if (!this.artifactMatcher.test(artifact)) break block19;
                this.output.chatter("  matched", new Object[0]);
                String targetName = this.artifactRootMapper.apply(this.artifactMapper.apply(artifact));
                this.output.chatter("  mapped to name {}", targetName);
                Path target = this.directory.resolve(targetName).toAbsolutePath();
                if (!target.startsWith(this.directory)) {
                    throw new IOException("Path escape prevented; check mappings");
                }
                if (!this.writtenPaths.add(target) && !this.allowRootOverwrite) {
                    throw new IOException("Root overwrite prevented; check mappings");
                }
                switch (artifact.getExtension()) {
                    case "jar": {
                        if (!this.dryRun) {
                            this.unjar(target, artifact.getFile().toPath());
                            break;
                        }
                        break block20;
                    }
                    case "zip": {
                        if (!this.dryRun) {
                            this.unzip(target, artifact.getFile().toPath());
                            break;
                        }
                        break block20;
                    }
                    case "tar.gz": {
                        if (!this.dryRun) {
                            this.untar(target, (InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(artifact.getFile().toPath(), new OpenOption[0]))));
                            break;
                        }
                        break block20;
                    }
                    case "tar.bz2": {
                        if (!this.dryRun) {
                            this.untar(target, (InputStream)new BZip2CompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(artifact.getFile().toPath(), new OpenOption[0]))));
                            break;
                        }
                        break block20;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown archive");
                    }
                }
                break block20;
            }
            if (this.failIfUnmatched) {
                throw new IllegalArgumentException("not matched");
            }
        }
    }

    private void untar(Path target, InputStream input) throws IOException {
        try (TarArchiveInputStream tar = new TarArchiveInputStream(input);){
            TarArchiveEntry entry;
            while ((entry = tar.getNextEntry()) != null) {
                if (!tar.canReadEntryData((ArchiveEntry)entry)) {
                    this.output.warn("Cannot read entry {}", entry.getName());
                    continue;
                }
                Path f = this.mapToOutput(target, entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(f, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
                this.mayCopy(f, (InputStream)tar, entry.getLastModifiedTime());
            }
        }
    }

    private void unzip(Path target, Path zipFile) throws IOException {
        try (ZipFile zip = ((ZipFile.Builder)ZipFile.builder().setFile(zipFile.toFile())).get();){
            Enumeration zipArchiveEntryEnumeration = zip.getEntries();
            while (zipArchiveEntryEnumeration.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)zipArchiveEntryEnumeration.nextElement();
                if (!zip.canReadEntryData(entry)) {
                    this.output.warn("Cannot read entry {}", entry.getName());
                    continue;
                }
                Path f = this.mapToOutput(target, entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(f, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
                this.mayCopy(f, zip.getInputStream(entry), entry.getLastModifiedTime());
            }
        }
    }

    private void unjar(Path target, Path jarFile) throws IOException {
        try (JarArchiveInputStream jar = new JarArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(jarFile, new OpenOption[0])));){
            JarArchiveEntry entry;
            while ((entry = jar.getNextEntry()) != null) {
                if (!jar.canReadEntryData((ArchiveEntry)entry)) {
                    this.output.warn("Cannot read entry {}", entry.getName());
                    continue;
                }
                Path f = this.mapToOutput(target, entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(f, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
                this.mayCopy(f, (InputStream)jar, entry.getLastModifiedTime());
            }
        }
    }

    private Path mapToOutput(Path target, String entryName) throws IOException {
        Path f = target.resolve(this.fileNameMapper.apply(entryName)).toAbsolutePath();
        if (!f.startsWith(target)) {
            throw new IOException("Path escape prevented");
        }
        return f;
    }

    private void mayCopy(Path target, InputStream inputStream, FileTime fileTime) throws IOException {
        if (Files.exists(target, new LinkOption[0]) && !this.allowEntryOverwrite) {
            throw new IOException("Entry overwrite prevented; overlap in archives");
        }
        try (OutputStream o = Files.newOutputStream(target, new OpenOption[0]);){
            inputStream.transferTo(o);
            if (fileTime != null) {
                Files.setLastModifiedTime(target, fileTime);
            }
        }
    }

    @Override
    public void cleanup(Exception e) {
        if (this.dryRun) {
            return;
        }
        this.writtenPaths.forEach(p -> {
            try (Stream<Path> stream = Files.walk(p, new FileVisitOption[0]).sorted(Comparator.reverseOrder());){
                stream.forEach(f -> {
                    try {
                        Files.delete(f);
                    }
                    catch (IOException ioex) {
                        this.output.warn("Could not delete {}", p, ioex);
                    }
                });
            }
            catch (IOException ioex) {
                this.output.warn("Could not walk {}", p, ioex);
            }
        });
        if (this.directoryCreated) {
            try {
                Files.deleteIfExists(this.directory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
    }
}

