/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.mima.extensions.mmr.MavenModelReader;
import eu.maveniverse.maven.mima.extensions.mmr.ModelRequest;
import eu.maveniverse.maven.mima.extensions.mmr.ModelResponse;
import eu.maveniverse.maven.toolbox.shared.ProjectLocator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;

public class ProjectLocatorImpl
implements ProjectLocator {
    private final RepositorySystemSession session;
    private final MavenModelReader mavenModelReader;

    public ProjectLocatorImpl(RepositorySystemSession session, MavenModelReader mavenModelReader) {
        this.session = Objects.requireNonNull(session, "session");
        this.mavenModelReader = Objects.requireNonNull(mavenModelReader, "mavenModelReader");
    }

    @Override
    public Optional<ProjectLocator.Project> locateProject(Artifact artifact) {
        try {
            ModelResponse modelResponse = this.mavenModelReader.readModel(ModelRequest.builder().setArtifact(artifact).setRequestContext("projectLocator").setTrace(new RequestTrace((Object)artifact)).build());
            Model em = modelResponse.getEffectiveModel();
            String ext = em.getPackaging();
            ArtifactType type = this.session.getArtifactTypeRegistry().get(em.getPackaging());
            if (type != null) {
                ext = type.getExtension();
            }
            DefaultArtifact pa = new DefaultArtifact(em.getGroupId(), em.getArtifactId(), ext, em.getVersion());
            DefaultArtifact pp = null;
            if (em.getParent() != null) {
                Parent ep = em.getParent();
                pp = new DefaultArtifact(ep.getGroupId(), ep.getArtifactId(), "pom", ep.getVersion());
            }
            List<Dependency> pd = em.getDependencies().stream().map(d -> RepositoryUtils.toDependency((org.apache.maven.model.Dependency)d, (ArtifactTypeRegistry)this.session.getArtifactTypeRegistry())).collect(Collectors.toList());
            return Optional.of(new ModelProject((Artifact)pa, (Artifact)pp, pd, this));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static final class ModelProject
    implements ProjectLocator.Project {
        private final Artifact artifact;
        private final Artifact parent;
        private final List<Dependency> dependencies;
        private final ProjectLocator origin;

        private ModelProject(Artifact artifact, Artifact parent, List<Dependency> dependencies, ProjectLocator origin) {
            this.artifact = Objects.requireNonNull(artifact, "artifact");
            this.parent = parent;
            this.dependencies = Objects.requireNonNull(dependencies, "dependencies");
            this.origin = origin;
        }

        @Override
        public Optional<Artifact> getParent() {
            return Optional.ofNullable(this.parent);
        }

        @Override
        public Artifact artifact() {
            return this.artifact;
        }

        public Artifact parent() {
            return this.parent;
        }

        @Override
        public List<Dependency> dependencies() {
            return this.dependencies;
        }

        @Override
        public ProjectLocator origin() {
            return this.origin;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ModelProject that = (ModelProject)obj;
            return Objects.equals(this.artifact, that.artifact) && Objects.equals(this.parent, that.parent) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.origin, that.origin);
        }

        public int hashCode() {
            return Objects.hash(this.artifact, this.parent, this.dependencies, this.origin);
        }

        public String toString() {
            return "ModelProject[artifact=" + String.valueOf(this.artifact) + ", parent=" + String.valueOf(this.parent) + ", dependencies=" + String.valueOf(this.dependencies) + ", origin=" + String.valueOf(this.origin) + "]";
        }
    }
}

