/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.ArtifactMapper;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.internal.jdom.JDomPomTransformer;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.aether.artifact.Artifact;

public final class PomTransformerSink
implements Artifacts.Sink {
    private static final String BLANK_POM = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n\n    <groupId>org.acme</groupId>\n    <artifactId>pom</artifactId>\n    <version>1.0-SNAPSHOT</version>\n    <packaging>pom</packaging>\n</project>\n";
    private final Output output;
    private final Path pom;
    private final Predicate<Artifact> artifactMatcher;
    private final Function<Artifact, Artifact> artifactMapper;
    private final Function<Artifact, Consumer<JDomPomTransformer.TransformationContext>> transformation;
    private final ArrayList<Consumer<JDomPomTransformer.TransformationContext>> applicableTransformations;

    public static PomTransformerSink transform(Output output, Path pom, ToolboxCommando.OpSubject subject, ToolboxCommando.Op op) throws IOException {
        return PomTransformerSink.transform(output, pom, () -> BLANK_POM, ArtifactMatcher.any(), ArtifactMapper.identity(), subject, op);
    }

    public static PomTransformerSink transform(Output output, Path pom, Supplier<String> pomSupplier, Predicate<Artifact> artifactMatcher, Function<Artifact, Artifact> artifactMapper, ToolboxCommando.OpSubject subject, ToolboxCommando.Op op) throws IOException {
        return new PomTransformerSink(output, pom, pomSupplier, artifactMatcher, artifactMapper, subject, op);
    }

    private PomTransformerSink(Output output, Path pom, Supplier<String> blankPomSupplier, Predicate<Artifact> artifactMatcher, Function<Artifact, Artifact> artifactMapper, ToolboxCommando.OpSubject subject, ToolboxCommando.Op op) throws IOException {
        this.output = Objects.requireNonNull(output, "output");
        this.pom = Objects.requireNonNull(pom, "pom").toAbsolutePath();
        if (!Files.isRegularFile(pom, new LinkOption[0])) {
            Files.createDirectories(pom.getParent(), new FileAttribute[0]);
            Files.writeString(pom, (CharSequence)blankPomSupplier.get(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        this.artifactMatcher = Objects.requireNonNull(artifactMatcher, "artifactMatcher");
        this.artifactMapper = Objects.requireNonNull(artifactMapper, "artifactMapper");
        Objects.requireNonNull(subject, "subject");
        Objects.requireNonNull(op, "op");
        Function<Artifact, Consumer<JDomPomTransformer.TransformationContext>> tr = null;
        block0 : switch (op) {
            case UPSERT: 
            case UPDATE: {
                switch (subject) {
                    case MANAGED_PLUGINS: {
                        tr = JDomPomTransformer.updateManagedPlugin(op == ToolboxCommando.Op.UPSERT);
                        break;
                    }
                    case PLUGINS: {
                        tr = JDomPomTransformer.updatePlugin(op == ToolboxCommando.Op.UPSERT);
                        break;
                    }
                    case MANAGED_DEPENDENCIES: {
                        tr = JDomPomTransformer.updateManagedDependency(op == ToolboxCommando.Op.UPSERT);
                        break;
                    }
                    case DEPENDENCIES: {
                        tr = JDomPomTransformer.updateDependency(op == ToolboxCommando.Op.UPSERT);
                    }
                }
                break;
            }
            case DELETE: {
                switch (subject) {
                    case MANAGED_PLUGINS: {
                        tr = JDomPomTransformer.deleteManagedPlugin();
                        break block0;
                    }
                    case PLUGINS: {
                        tr = JDomPomTransformer.deletePlugin();
                        break block0;
                    }
                    case MANAGED_DEPENDENCIES: {
                        tr = JDomPomTransformer.deleteManagedDependency();
                        break block0;
                    }
                    case DEPENDENCIES: {
                        tr = JDomPomTransformer.deleteDependency();
                    }
                }
            }
        }
        if (tr == null) {
            throw new IllegalArgumentException("Unknown subject: " + String.valueOf((Object)subject) + " and/or op: " + String.valueOf((Object)op));
        }
        this.transformation = tr;
        this.applicableTransformations = new ArrayList();
    }

    public Path getPomPath() {
        return this.pom;
    }

    @Override
    public void accept(Artifact artifact) throws IOException {
        Consumer<JDomPomTransformer.TransformationContext> transformation;
        Objects.requireNonNull(artifact, "artifact");
        if (this.artifactMatcher.test(artifact) && (transformation = this.transformation.apply(this.artifactMapper.apply(artifact))) != null) {
            this.output.chatter("Accepted {}", artifact);
            this.applicableTransformations.add(transformation);
        }
    }

    @Override
    public void cleanup(Exception e) {
        try {
            Files.deleteIfExists(this.pom);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        JDomPomTransformer jDomPomTransformer = new JDomPomTransformer();
        jDomPomTransformer.apply(this.pom, this.applicableTransformations);
    }
}

