/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.LocalRepository;

public final class InstallingSink
implements Artifacts.Sink {
    private final Output output;
    private final RepositorySystem system;
    private final RepositorySystemSession session;
    private final InstallRequest installRequest;
    private final boolean dryRun;

    public static InstallingSink installing(Output output, RepositorySystem system, RepositorySystemSession session, boolean dryRun) {
        return new InstallingSink(output, system, session, dryRun);
    }

    private InstallingSink(Output output, RepositorySystem system, RepositorySystemSession session, boolean dryRun) {
        this.output = Objects.requireNonNull(output, "output");
        this.system = Objects.requireNonNull(system, "system");
        this.session = Objects.requireNonNull(session, "session");
        this.installRequest = new InstallRequest();
        this.installRequest.setTrace(RequestTrace.newChild(null, (Object)this));
        this.dryRun = dryRun;
    }

    public LocalRepository getLocalRepository() {
        return this.session.getLocalRepository();
    }

    @Override
    public void accept(Collection<Artifact> artifacts) {
        Objects.requireNonNull(artifacts, "artifacts");
        this.installRequest.setArtifacts(artifacts);
    }

    @Override
    public void accept(Artifact artifact) {
        Objects.requireNonNull(artifact, "artifact");
        this.installRequest.addArtifact(artifact);
    }

    @Override
    public void close() throws InstallationException {
        this.output.chatter("Installing {} artifacts", this.installRequest.getArtifacts().size());
        if (!this.dryRun) {
            this.system.install(this.session, this.installRequest);
        }
    }
}

