/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;

public final class DeployingSink
implements Artifacts.Sink {
    private final Output output;
    private final RepositorySystem system;
    private final RepositorySystemSession session;
    private final DeployRequest deployRequest;
    private final boolean dryRun;

    public static DeployingSink deploying(Output output, RepositorySystem system, RepositorySystemSession session, RemoteRepository repository, boolean dryRun) {
        return new DeployingSink(output, system, session, repository, dryRun);
    }

    private DeployingSink(Output output, RepositorySystem system, RepositorySystemSession session, RemoteRepository repository, boolean dryRun) {
        this.output = Objects.requireNonNull(output, "output");
        this.system = Objects.requireNonNull(system, "system");
        this.session = Objects.requireNonNull(session, "session");
        this.deployRequest = new DeployRequest();
        this.deployRequest.setRepository(repository);
        this.deployRequest.setTrace(RequestTrace.newChild(null, (Object)this));
        this.dryRun = dryRun;
    }

    public RemoteRepository getRemoteRepository() {
        return this.deployRequest.getRepository();
    }

    @Override
    public void accept(Collection<Artifact> artifacts) {
        Objects.requireNonNull(artifacts, "artifacts");
        this.deployRequest.setArtifacts(artifacts);
    }

    @Override
    public void accept(Artifact artifact) {
        Objects.requireNonNull(artifact, "artifact");
        this.deployRequest.addArtifact(artifact);
    }

    @Override
    public void close() throws DeploymentException {
        this.output.chatter("Deploying {} artifacts", this.deployRequest.getArtifacts().size());
        if (!this.dryRun) {
            this.system.deploy(this.session, this.deployRequest);
        }
    }
}

