/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.HTTPProxy;
import eu.maveniverse.maven.mima.context.MavenSystemHome;
import eu.maveniverse.maven.mima.context.MavenUserHome;
import eu.maveniverse.maven.mima.context.Runtime;
import eu.maveniverse.maven.mima.context.internal.RuntimeSupport;
import eu.maveniverse.maven.mima.extensions.mmr.MavenModelReader;
import eu.maveniverse.maven.toolbox.shared.ArtifactMapper;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactNameMapper;
import eu.maveniverse.maven.toolbox.shared.ArtifactRecorder;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.DependencyMatcher;
import eu.maveniverse.maven.toolbox.shared.ReactorLocator;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.Sink;
import eu.maveniverse.maven.toolbox.shared.Source;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.internal.ArtifactRecorderImpl;
import eu.maveniverse.maven.toolbox.shared.internal.ArtifactSinks;
import eu.maveniverse.maven.toolbox.shared.internal.ArtifactSources;
import eu.maveniverse.maven.toolbox.shared.internal.DependencyGraphDecorators;
import eu.maveniverse.maven.toolbox.shared.internal.DependencyGraphDumper;
import eu.maveniverse.maven.toolbox.shared.internal.DependencySinks;
import eu.maveniverse.maven.toolbox.shared.internal.LibYearSink;
import eu.maveniverse.maven.toolbox.shared.internal.ToolboxResolverImpl;
import eu.maveniverse.maven.toolbox.shared.internal.ToolboxSearchApiImpl;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.StringCharacterIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.search.api.MAVEN;
import org.apache.maven.search.api.SearchBackend;
import org.apache.maven.search.api.SearchRequest;
import org.apache.maven.search.api.SearchResponse;
import org.apache.maven.search.api.request.BooleanQuery;
import org.apache.maven.search.api.request.Field;
import org.apache.maven.search.api.request.FieldQuery;
import org.apache.maven.search.api.request.Query;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.util.ChecksumUtils;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.util.graph.visitor.CloningDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.util.listener.ChainedRepositoryListener;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionScheme;

public class ToolboxCommandoImpl
implements ToolboxCommando {
    private final Output output;
    private final Context context;
    private final RepositorySystemSession session;
    private final VersionScheme versionScheme;
    private final ToolboxSearchApiImpl toolboxSearchApi;
    private final ArtifactRecorderImpl artifactRecorder;
    private final ToolboxResolverImpl toolboxResolver;
    private final Map<String, RemoteRepository> knownSearchRemoteRepositories;

    public ToolboxCommandoImpl(Output output, Context context) {
        this.output = Objects.requireNonNull(output, "output");
        this.context = Objects.requireNonNull(context, "context");
        this.versionScheme = new GenericVersionScheme();
        this.toolboxSearchApi = new ToolboxSearchApiImpl(output);
        this.artifactRecorder = new ArtifactRecorderImpl();
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(context.repositorySystemSession());
        session.setRepositoryListener(ChainedRepositoryListener.newInstance((RepositoryListener)session.getRepositoryListener(), (RepositoryListener)this.artifactRecorder));
        this.session = session;
        this.toolboxResolver = new ToolboxResolverImpl(output, context.repositorySystem(), (RepositorySystemSession)session, new MavenModelReader(context), context.remoteRepositories(), this.versionScheme);
        this.knownSearchRemoteRepositories = Collections.unmodifiableMap(this.createKnownSearchRemoteRepositories());
    }

    public Path basedir() {
        return this.context.basedir();
    }

    public Output output() {
        return this.output;
    }

    public RepositorySystem repositorySystem() {
        return this.context.repositorySystem();
    }

    public RepositorySystemSession session() {
        return this.session;
    }

    public List<RemoteRepository> remoteRepositories() {
        return this.context.remoteRepositories();
    }

    public ArtifactRecorder recorder() {
        return this.artifactRecorder;
    }

    protected Map<String, RemoteRepository> createKnownSearchRemoteRepositories() {
        HashMap<String, RemoteRepository> rr = new HashMap<String, RemoteRepository>();
        rr.put(ContextOverrides.CENTRAL.getId(), this.parseRemoteRepository(ContextOverrides.CENTRAL.getId() + "::central::" + ContextOverrides.CENTRAL.getUrl()));
        rr.put("sonatype-oss-releases", this.parseRemoteRepository("sonatype-oss-releases::nx2::https://oss.sonatype.org/content/repositories/releases/"));
        rr.put("sonatype-oss-staging", this.parseRemoteRepository("sonatype-oss-staging::nx2::https://oss.sonatype.org/content/groups/staging/"));
        rr.put("sonatype-s01-releases", this.parseRemoteRepository("sonatype-s01-releases::nx2::https://s01.oss.sonatype.org/content/repositories/releases/"));
        rr.put("sonatype-s01-staging", this.parseRemoteRepository("sonatype-s01-staging::nx2::https://s01.oss.sonatype.org/content/groups/staging/"));
        rr.put("apache-releases", this.parseRemoteRepository("apache-releases::nx2::https://repository.apache.org/content/repositories/releases/"));
        rr.put("apache-staging", this.parseRemoteRepository("apache-staging::nx2::https://repository.apache.org/content/groups/staging/"));
        rr.put("apache-maven-staging", this.parseRemoteRepository("apache-maven-staging::nx2::https://repository.apache.org/content/groups/maven-staging-group/"));
        return rr;
    }

    @Override
    public Result<String> dump() {
        Runtime runtime = this.context.getRuntime();
        this.output.marker(Output.Verbosity.TIGHT).emphasize("Toolbox {}").normal(" (MIMA Runtime '{}' version {})").say(this.getVersion(), runtime.name(), runtime.version());
        this.output.doTell("", new Object[0]);
        this.output.tell("          Maven version {}", runtime.mavenVersion());
        this.output.tell("                Managed {}", runtime.managedRepositorySystem());
        this.output.tell("                Basedir {}", this.context.basedir());
        this.output.tell("                Offline {}", this.context.repositorySystemSession().isOffline());
        MavenSystemHome mavenSystemHome = this.context.mavenSystemHome();
        this.output.tell("", new Object[0]);
        this.output.tell("             MAVEN_HOME {}", mavenSystemHome == null ? "undefined" : mavenSystemHome.basedir());
        if (mavenSystemHome != null) {
            this.output.tell("           settings.xml {}", mavenSystemHome.settingsXml());
            this.output.tell("         toolchains.xml {}", mavenSystemHome.toolchainsXml());
        }
        MavenUserHome mavenUserHome = this.context.mavenUserHome();
        this.output.tell("", new Object[0]);
        this.output.tell("              USER_HOME {}", mavenUserHome.basedir());
        this.output.tell("           settings.xml {}", mavenUserHome.settingsXml());
        this.output.tell("  settings-security.xml {}", mavenUserHome.settingsSecurityXml());
        this.output.tell("       local repository {}", mavenUserHome.localRepository());
        this.output.tell("", new Object[0]);
        this.output.tell("               PROFILES", new Object[0]);
        this.output.tell("                 Active {}", this.context.contextOverrides().getActiveProfileIds());
        this.output.tell("               Inactive {}", this.context.contextOverrides().getInactiveProfileIds());
        this.output.tell("", new Object[0]);
        this.output.tell("    REMOTE REPOSITORIES", new Object[0]);
        for (RemoteRepository repository : this.context.remoteRepositories()) {
            if (repository.getMirroredRepositories().isEmpty()) {
                this.output.tell("                        {}", repository);
                continue;
            }
            this.output.tell("                        {}, mirror of", repository);
            for (RemoteRepository mirrored : repository.getMirroredRepositories()) {
                this.output.tell("                          {}", mirrored);
            }
        }
        if (this.context.httpProxy() != null) {
            HTTPProxy proxy = this.context.httpProxy();
            this.output.tell("", new Object[0]);
            this.output.tell("             HTTP PROXY", new Object[0]);
            this.output.tell("                    url {}://{}:{}", proxy.getProtocol(), proxy.getHost(), proxy.getPort());
            this.output.tell("          nonProxyHosts {}", proxy.getNonProxyHosts());
        }
        if (this.output.isHeard(Output.Verbosity.SUGGEST)) {
            this.output.suggest("", new Object[0]);
            this.output.suggest("        USER PROPERTIES", new Object[0]);
            this.context.repositorySystemSession().getUserProperties().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> this.output.suggest("                         {}={}", e.getKey(), e.getValue()));
            this.output.suggest("      SYSTEM PROPERTIES", new Object[0]);
            this.context.repositorySystemSession().getSystemProperties().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> this.output.suggest("                         {}={}", e.getKey(), e.getValue()));
            this.output.suggest("      CONFIG PROPERTIES", new Object[0]);
            this.context.repositorySystemSession().getConfigProperties().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> this.output.suggest("                         {}={}", e.getKey(), e.getValue()));
            this.output.suggest("", new Object[0]);
            if (this.output.isHeard(Output.Verbosity.CHATTER)) {
                this.output.tell("OUTPUT TEST:", new Object[0]);
                this.output.chatter("Chatter: {}", "Message", new RuntimeException("runtime"));
                this.output.suggest("Suggest: {}", "Message", new RuntimeException("runtime"));
                this.output.tell("Tell: {}", "Message", new RuntimeException("runtime"));
                this.output.doTell("Do Tell: {}", "Message", new RuntimeException("runtime"));
            }
        }
        return Result.success("Success");
    }

    @Override
    public ArtifactMapper parseArtifactMapperSpec(String spec) {
        return ArtifactMapper.build(this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public ArtifactMatcher parseArtifactMatcherSpec(String spec) {
        return ArtifactMatcher.build(this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public ArtifactNameMapper parseArtifactNameMapperSpec(String spec) {
        return ArtifactNameMapper.build(this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public DependencyMatcher parseDependencyMatcherSpec(String spec) {
        return DependencyMatcher.build(this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public ArtifactVersionMatcher parseArtifactVersionMatcherSpec(String spec) {
        return ArtifactVersionMatcher.build(this.versionScheme, this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public ArtifactVersionSelector parseArtifactVersionSelectorSpec(String spec) {
        return ArtifactVersionSelector.build(this.versionScheme, this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public RemoteRepository parseRemoteRepository(String spec) {
        return this.toolboxResolver.parseRemoteRepository(spec);
    }

    @Override
    public Source<Artifact> artifactSource(String spec) {
        return ArtifactSources.build(this.context.repositorySystemSession().getConfigProperties(), this, spec);
    }

    @Override
    public Sink<Artifact> artifactSink(String spec) {
        return ArtifactSinks.build(this.context.repositorySystemSession().getConfigProperties(), this, spec);
    }

    @Override
    public Sink<Dependency> dependencySink(String spec) {
        return DependencySinks.build(this.context.repositorySystemSession().getConfigProperties(), this, spec);
    }

    @Override
    public ResolutionRoot loadGav(String gav, Collection<String> boms) throws InvalidVersionSpecificationException, VersionRangeResolutionException, ArtifactDescriptorException {
        return this.toolboxResolver.loadGav(gav, boms);
    }

    @Override
    public Artifact toArtifact(Dependency dependency) {
        try {
            return this.toolboxResolver.mayResolveArtifactVersion(dependency.getArtifact(), ArtifactVersionSelector.last());
        }
        catch (VersionRangeResolutionException | InvalidVersionSpecificationException e) {
            this.output.warn("Could not resolve artifact version: {}", dependency.getArtifact(), e);
            return dependency.getArtifact();
        }
    }

    @Override
    public Result<String> classpath(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot) throws Exception {
        this.output.suggest("Resolving {}", resolutionRoot.getArtifact());
        resolutionRoot = this.toolboxResolver.loadRoot(resolutionRoot);
        DependencyResult dependencyResult = this.toolboxResolver.resolve(resolutionScope, resolutionRoot.getArtifact(), resolutionRoot.getDependencies(), resolutionRoot.getManagedDependencies());
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        dependencyResult.getRoot().accept((DependencyVisitor)nlg);
        String classpath = nlg.getClassPath();
        this.output.doTell(classpath, new Object[0]);
        if (nlg.getFiles().isEmpty()) {
            return Result.failure("No files");
        }
        return Result.success(classpath);
    }

    @Override
    public Result<List<Artifact>> copy(Source<Artifact> source, Sink<Artifact> sink) throws Exception {
        try (Source<Artifact> source2 = source;){
            Result<List<Artifact>> result;
            block12: {
                Sink<Artifact> sink2 = sink;
                try {
                    ArtifactSinks.CollectingArtifactSink collectingArtifactSink = ArtifactSinks.collectingArtifactSink();
                    ArtifactSinks.teeArtifactSink(sink, collectingArtifactSink).accept(source.get().map(a -> {
                        try {
                            if (a.getFile() == null) {
                                ArtifactResult ar = this.toolboxResolver.resolveArtifact((Artifact)a);
                                if (ar.isResolved()) {
                                    return ar.getArtifact();
                                }
                                return null;
                            }
                            return a;
                        }
                        catch (ArtifactResolutionException e) {
                            throw new RuntimeException(e);
                        }
                    }).filter(Objects::nonNull));
                    this.output.tell("Copied {} artifacts", collectingArtifactSink.collect().size());
                    result = Result.success(collectingArtifactSink.collect());
                    if (sink2 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (sink2 != null) {
                        try {
                            sink2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sink2.close();
            }
            return result;
        }
    }

    @Override
    public Result<List<Artifact>> copyTransitive(ResolutionScope resolutionScope, Collection<ResolutionRoot> resolutionRoots, Sink<Artifact> sink) throws Exception {
        ArrayList<Artifact> artifactResults = new ArrayList<Artifact>();
        for (ResolutionRoot resolutionRoot : resolutionRoots) {
            this.output.suggest("Resolving {}", resolutionRoot.getArtifact());
            resolutionRoot = this.toolboxResolver.loadRoot(resolutionRoot);
            DependencyResult dependencyResult = this.toolboxResolver.resolve(resolutionScope, resolutionRoot.getArtifact(), resolutionRoot.getDependencies(), resolutionRoot.getManagedDependencies());
            artifactResults.addAll((resolutionRoot.isLoad() ? dependencyResult.getArtifactResults() : dependencyResult.getArtifactResults().subList(1, dependencyResult.getArtifactResults().size() - 1)).stream().filter(ArtifactResult::isResolved).map(ArtifactResult::getArtifact).toList());
        }
        return this.copy(artifactResults::stream, sink);
    }

    @Override
    public Result<List<Artifact>> copyRecorded(boolean stopRecording, Sink<Artifact> sink) throws Exception {
        this.artifactRecorder.setActive(!stopRecording);
        return this.copy(this.artifactRecorder, sink);
    }

    @Override
    public Result<Map<String, List<RemoteRepository>>> listRepositories(ResolutionScope resolutionScope, Map<String, ResolutionRoot> resolutionRoots) throws Exception {
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        for (Map.Entry<String, ResolutionRoot> entry : resolutionRoots.entrySet()) {
            String contextName = entry.getKey();
            ResolutionRoot resolutionRoot = entry.getValue();
            this.output.chatter("Loading root of {} {}", contextName, resolutionRoot.getArtifact());
            ResolutionRoot root = this.toolboxResolver.loadRoot(resolutionRoot);
            this.output.chatter("Collecting graph of: {}", resolutionRoot.getArtifact());
            CollectResult collectResult = this.toolboxResolver.collect(resolutionScope, root.getArtifact(), root.getDependencies(), root.getManagedDependencies(), false);
            final LinkedHashMap repositories = new LinkedHashMap();
            final Dependency sentinel = new Dependency((Artifact)new DefaultArtifact("sentinel:sentinel:sentinel"), "");
            this.remoteRepositories().forEach(r -> repositories.put(r, sentinel));
            final ArrayDeque path = new ArrayDeque();
            collectResult.getRoot().accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){

                public boolean visitEnter(DependencyNode node) {
                    Dependency parent = path.peek() == null ? sentinel : (Dependency)path.peek();
                    node.getRepositories().forEach(r -> repositories.putIfAbsent(r, parent));
                    path.push(node.getDependency() != null ? node.getDependency() : sentinel);
                    return true;
                }

                public boolean visitLeave(DependencyNode node) {
                    path.pop();
                    return true;
                }
            }));
            if (repositories.isEmpty()) {
                this.output.tell("No remote repository is used by {} {}.", contextName, resolutionRoot.getArtifact());
                result.put(contextName, Collections.emptyList());
                continue;
            }
            this.output.tell("Remote repositories used by {} {}.", contextName, resolutionRoot.getArtifact());
            Map<Boolean, List<RemoteRepository>> repoGroupByMirrors = repositories.keySet().stream().collect(Collectors.groupingBy(repo -> repo.getMirroredRepositories().isEmpty()));
            repoGroupByMirrors.getOrDefault(Boolean.TRUE, Collections.emptyList()).forEach(r -> {
                this.output.tell(" * {}", r);
                Dependency firstIntroduced = (Dependency)repositories.get(r);
                this.output.tell("   First introduced on {}", firstIntroduced == sentinel ? "root" : firstIntroduced);
            });
            HashMap<RemoteRepository, RemoteRepository> mirrorMap = new HashMap<RemoteRepository, RemoteRepository>();
            repoGroupByMirrors.getOrDefault(Boolean.FALSE, Collections.emptyList()).forEach(repo -> repo.getMirroredRepositories().forEach(mrepo -> mirrorMap.put((RemoteRepository)mrepo, (RemoteRepository)repo)));
            mirrorMap.forEach((r, mirror) -> {
                this.output.tell(" * {}", r);
                Dependency firstIntroduced = (Dependency)repositories.get(mirror);
                this.output.tell("   First introduced on {}", firstIntroduced == sentinel ? "root" : firstIntroduced);
                this.output.tell("   Mirrored by {}", mirror);
            });
            result.put(contextName, List.copyOf(repositories.keySet()));
        }
        return Result.success(result);
    }

    @Override
    public Result<List<Artifact>> listAvailablePlugins(Collection<String> groupIds) throws Exception {
        this.output.suggest("Listing plugins in groupIds: {}", groupIds);
        List<Artifact> plugins = this.toolboxResolver.listAvailablePlugins(groupIds);
        plugins.forEach(p -> this.output.tell(p.toString(), new Object[0]));
        return plugins.isEmpty() ? Result.failure("No plugins") : Result.success(plugins);
    }

    @Override
    public Result<String> recordStart() {
        boolean result = this.artifactRecorder.setActive(true);
        if (result) {
            this.artifactRecorder.clear();
            this.output.tell("Started recorder...", new Object[0]);
        } else {
            this.output.tell("Recorder was already started.", new Object[0]);
        }
        return result ? Result.success("Started") : Result.failure("No recorder state changed");
    }

    @Override
    public Result<ToolboxCommando.RecordStats> recordStats() {
        boolean active = this.artifactRecorder.isActive();
        int recordedCount = this.artifactRecorder.recordedCount();
        this.output.tell("Recorder is {}; recorded {} artifacts so far", active ? "started" : "stopped", recordedCount);
        return Result.success(new ToolboxCommando.RecordStats(active, recordedCount));
    }

    @Override
    public Result<String> recordStop() {
        boolean result = this.artifactRecorder.setActive(false);
        if (result) {
            this.output.tell("Stopped recorder, recorded {} artifacts", this.artifactRecorder.recordedCount());
        } else {
            this.output.tell("Recorder was not started.", new Object[0]);
        }
        return result ? Result.success("Stopped") : Result.failure("No recorder state changed");
    }

    @Override
    public Result<List<Artifact>> resolve(Source<Artifact> artifactSource, boolean sources, boolean javadoc, boolean signature, Sink<Artifact> sink) throws Exception {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        List<Artifact> artifacts = artifactSource.get().toList();
        this.output.suggest("Resolving {}", artifacts);
        try (ArtifactSinks.TeeArtifactSink artifactSink = ArtifactSinks.teeArtifactSink(sink, ArtifactSinks.statArtifactSink(0, true, this.output));){
            List<Artifact> artifactResults = this.toolboxResolver.resolveArtifacts(artifacts).stream().map(ArtifactResult::getArtifact).toList();
            result.addAll(artifactResults);
            artifactSink.accept(artifactResults);
            if (sources || javadoc || signature) {
                HashSet<Artifact> subartifacts = new HashSet<Artifact>();
                artifacts.forEach(a -> {
                    if (sources && a.getClassifier().isEmpty()) {
                        subartifacts.add((Artifact)new SubArtifact(a, "sources", "jar"));
                    }
                    if (javadoc && a.getClassifier().isEmpty()) {
                        subartifacts.add((Artifact)new SubArtifact(a, "javadoc", "jar"));
                    }
                    if (signature && !a.getExtension().endsWith(".asc")) {
                        subartifacts.add((Artifact)new SubArtifact(a, "*", "*.asc"));
                    }
                });
                if (!subartifacts.isEmpty()) {
                    this.output.suggest("Resolving (best effort) {}", subartifacts);
                    try {
                        List<Artifact> subartifactResults = this.toolboxResolver.resolveArtifacts(subartifacts).stream().map(ArtifactResult::getArtifact).toList();
                        result.addAll(subartifactResults);
                        artifactSink.accept(subartifactResults);
                    }
                    catch (ArtifactResolutionException e) {
                        List<Artifact> bestEffort = e.getResults().stream().filter(ArtifactResult::isResolved).map(ArtifactResult::getArtifact).toList();
                        result.addAll(bestEffort);
                        artifactSink.accept(bestEffort);
                    }
                }
            }
            Result<List<Artifact>> result2 = result.isEmpty() ? Result.failure("No artifacts") : Result.success(result);
            return result2;
        }
    }

    @Override
    public Result<List<Artifact>> resolveTransitive(ResolutionScope resolutionScope, Collection<ResolutionRoot> resolutionRoots, boolean sources, boolean javadoc, boolean signature, Sink<Artifact> sink) throws Exception {
        ArtifactSinks.StatArtifactSink stat = ArtifactSinks.statArtifactSink(0, false, this.output);
        try (ArtifactSinks.TeeArtifactSink artifactSink = ArtifactSinks.teeArtifactSink(sink, stat);){
            for (ResolutionRoot resolutionRoot : resolutionRoots) {
                this.doResolveTransitive(resolutionScope, resolutionRoot, sources, javadoc, signature, ArtifactSinks.teeArtifactSink(ArtifactSinks.nonClosingArtifactSink(artifactSink), ArtifactSinks.statArtifactSink(1, true, this.output)));
            }
        }
        return stat.getSeenArtifacts().isEmpty() ? Result.failure("No artifacts") : Result.success(stat.getSeenArtifacts());
    }

    private void doResolveTransitive(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot, boolean sources, boolean javadoc, boolean signature, Sink<Artifact> sink) throws Exception {
        try (Sink<Artifact> artifactSink = sink;){
            this.output.suggest("Resolving {}", resolutionRoot.getArtifact());
            resolutionRoot = this.toolboxResolver.loadRoot(resolutionRoot);
            DependencyResult dependencyResult = this.toolboxResolver.resolve(resolutionScope, resolutionRoot.getArtifact(), resolutionRoot.getDependencies(), resolutionRoot.getManagedDependencies());
            List adjustedResults = resolutionRoot.isLoad() ? dependencyResult.getArtifactResults() : (dependencyResult.getArtifactResults().size() == 1 ? Collections.emptyList() : dependencyResult.getArtifactResults().subList(1, dependencyResult.getArtifactResults().size() - 1));
            artifactSink.accept(adjustedResults.stream().map(ArtifactResult::getArtifact).collect(Collectors.toList()));
            if (sources || javadoc || signature) {
                HashSet<Artifact> subartifacts = new HashSet<Artifact>();
                adjustedResults.stream().map(ArtifactResult::getArtifact).forEach(a -> {
                    if (sources && a.getClassifier().isEmpty()) {
                        subartifacts.add((Artifact)new SubArtifact(a, "sources", "jar"));
                    }
                    if (javadoc && a.getClassifier().isEmpty()) {
                        subartifacts.add((Artifact)new SubArtifact(a, "javadoc", "jar"));
                    }
                    if (signature && !a.getExtension().endsWith(".asc")) {
                        subartifacts.add((Artifact)new SubArtifact(a, "*", "*.asc"));
                    }
                });
                if (!subartifacts.isEmpty()) {
                    this.output.suggest("Resolving (best effort) {}", subartifacts);
                    try {
                        List<ArtifactResult> subartifactResults = this.toolboxResolver.resolveArtifacts(subartifacts);
                        artifactSink.accept(subartifactResults.stream().map(ArtifactResult::getArtifact).collect(Collectors.toList()));
                    }
                    catch (ArtifactResolutionException e) {
                        artifactSink.accept(e.getResults().stream().filter(ArtifactResult::isResolved).map(ArtifactResult::getArtifact).collect(Collectors.toList()));
                    }
                }
            }
        }
    }

    @Override
    public Result<CollectResult> tree(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot, boolean verboseTree, final DependencyMatcher dependencyMatcher) throws Exception {
        this.output.suggest("Loading root of: {}", resolutionRoot.getArtifact());
        ResolutionRoot root = this.toolboxResolver.loadRoot(resolutionRoot);
        this.output.suggest("Collecting graph of: {}", resolutionRoot.getArtifact());
        CollectResult collectResult = this.toolboxResolver.collect(resolutionScope, root.getArtifact(), root.getDependencies(), root.getManagedDependencies(), verboseTree);
        CloningDependencyVisitor cloningDependencyVisitor = new CloningDependencyVisitor();
        collectResult.getRoot().accept((DependencyVisitor)new FilteringDependencyVisitor((DependencyVisitor)cloningDependencyVisitor, new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                return node.getDependency() == null || dependencyMatcher.test(node.getDependency());
            }
        }));
        DependencyNode clone = cloningDependencyVisitor.getRootNode();
        clone.accept((DependencyVisitor)new DependencyGraphDumper(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(DependencyGraphDumper.premanagedProperties()), this.output.tool(DependencyGraphDecorators.TreeDecorator.class, DependencyGraphDecorators.defaultSupplier())));
        collectResult.setRoot(clone);
        return Result.success(collectResult);
    }

    @Override
    public Result<CollectResult> dirtyTree(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot, int maxLevel, boolean verboseTree, final DependencyMatcher dependencyMatcher) throws Exception {
        this.output.suggest("Loading root of: {}", resolutionRoot.getArtifact());
        ResolutionRoot root = this.toolboxResolver.loadRoot(resolutionRoot);
        this.output.suggest("Collecting graph of: {}", resolutionRoot.getArtifact());
        CollectResult collectResult = this.toolboxResolver.collect(resolutionScope, root.getArtifact(), root.getDependencies(), root.getManagedDependencies(), maxLevel, verboseTree);
        CloningDependencyVisitor cloningDependencyVisitor = new CloningDependencyVisitor();
        collectResult.getRoot().accept((DependencyVisitor)new FilteringDependencyVisitor((DependencyVisitor)cloningDependencyVisitor, new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                return node.getDependency() == null || dependencyMatcher.test(node.getDependency());
            }
        }));
        DependencyNode clone = cloningDependencyVisitor.getRootNode();
        clone.accept((DependencyVisitor)new DependencyGraphDumper(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(DependencyGraphDumper.premanagedProperties()), this.output.tool(DependencyGraphDecorators.TreeDecorator.class, DependencyGraphDecorators.defaultSupplier())));
        collectResult.setRoot(clone);
        return Result.success(collectResult);
    }

    @Override
    public Result<List<List<Artifact>>> treeFind(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot, boolean verboseTree, ArtifactMatcher artifactMatcher) throws Exception {
        this.output.suggest("Loading root of: {}", resolutionRoot.getArtifact());
        ResolutionRoot root = this.toolboxResolver.loadRoot(resolutionRoot);
        this.output.suggest("Collecting graph of: {}", resolutionRoot.getArtifact());
        CollectResult collectResult = this.toolboxResolver.collect(resolutionScope, root.getArtifact(), root.getDependencies(), root.getManagedDependencies(), verboseTree);
        PathRecordingDependencyVisitor pathRecordingDependencyVisitor = new PathRecordingDependencyVisitor((node, parents) -> node.getArtifact() != null && artifactMatcher.test(node.getArtifact()));
        collectResult.getRoot().accept((DependencyVisitor)pathRecordingDependencyVisitor);
        ArrayList<List<Artifact>> result = new ArrayList<List<Artifact>>();
        if (!pathRecordingDependencyVisitor.getPaths().isEmpty()) {
            for (List path : pathRecordingDependencyVisitor.getPaths()) {
                result.add(path.stream().map(DependencyNode::getArtifact).toList());
                Object indent = "";
                for (DependencyNode node2 : path) {
                    this.output.tell("{}-> {}", indent, node2.getArtifact());
                    indent = (String)indent + "  ";
                }
            }
        }
        return Result.success(result);
    }

    @Override
    public Result<List<Dependency>> dmList(ResolutionRoot resolutionRoot, boolean verboseList) throws Exception {
        AtomicInteger counter = new AtomicInteger(0);
        List<Dependency> result = this.toolboxResolver.loadRoot(resolutionRoot).getManagedDependencies();
        result.forEach(d -> this.output.tell(" {}. {}", counter.incrementAndGet(), d.getScope().trim().isEmpty() ? d.getArtifact() : d));
        return Result.success(result);
    }

    @Override
    public Result<CollectResult> dmTree(ResolutionRoot resolutionRoot, boolean verboseTree) throws Exception {
        resolutionRoot = this.toolboxResolver.loadRoot(resolutionRoot);
        CollectResult collectResult = this.toolboxResolver.collectDm(resolutionRoot.getArtifact(), resolutionRoot.getManagedDependencies(), verboseTree);
        collectResult.getRoot().accept((DependencyVisitor)new DependencyGraphDumper(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(DependencyGraphDumper.premanagedProperties()), this.output.tool(DependencyGraphDecorators.DmTreeDecorator.class, DependencyGraphDecorators.defaultSupplier())));
        return Result.success(collectResult);
    }

    @Override
    public Result<CollectResult> parentChildTree(ReactorLocator reactorLocator) {
        CollectResult collectResult = this.toolboxResolver.parentChildTree(reactorLocator);
        collectResult.getRoot().accept((DependencyVisitor)new DependencyGraphDumper(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(new Function[0]), this.output.tool(DependencyGraphDecorators.ParentChildTreeDecorator.class, DependencyGraphDecorators.defaultSupplier())));
        return Result.success(collectResult);
    }

    @Override
    public Result<CollectResult> subprojectTree(ReactorLocator reactorLocator) throws Exception {
        CollectResult collectResult = this.toolboxResolver.subprojectTree(reactorLocator);
        collectResult.getRoot().accept((DependencyVisitor)new DependencyGraphDumper(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(new Function[0]), this.output.tool(DependencyGraphDecorators.SubprojectTreeDecorator.class, DependencyGraphDecorators.defaultSupplier())));
        return Result.success(collectResult);
    }

    @Override
    public Result<CollectResult> projectDependencyTree(ReactorLocator reactorLocator, boolean showExternal) {
        CollectResult collectResult = this.toolboxResolver.projectDependencyTree(reactorLocator, showExternal);
        collectResult.getRoot().accept((DependencyVisitor)new DependencyGraphDumper(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(new Function[0]), this.output.tool(DependencyGraphDecorators.ProjectDependenciesTreeDecorator.class, DependencyGraphDecorators.defaultSupplier())));
        return Result.success(collectResult);
    }

    @Override
    public Map<String, RemoteRepository> getKnownSearchRemoteRepositories() {
        return this.knownSearchRemoteRepositories;
    }

    @Override
    public Result<Map<Artifact, Boolean>> exists(RemoteRepository remoteRepository, String gav, boolean pom, boolean sources, boolean javadoc, boolean signature, boolean allRequired, String repositoryVendor) throws IOException {
        HashMap<Object, Boolean> result = new HashMap<Object, Boolean>();
        ArrayList<Object> missingOnes = new ArrayList<Object>();
        ArrayList<Object> existingOnes = new ArrayList<Object>();
        try (SearchBackend backend = this.toolboxSearchApi.getRemoteRepositoryBackend(this.context.repositorySystemSession(), remoteRepository, repositoryVendor);){
            DefaultArtifact artifact = new DefaultArtifact(gav);
            boolean exists = this.toolboxSearchApi.exists(backend, (Artifact)artifact);
            result.put(artifact, exists);
            if (!exists) {
                missingOnes.add(artifact);
            } else {
                existingOnes.add(artifact);
            }
            BiConsumer<Artifact, Boolean> reporter = (a, e) -> {
                if (e.booleanValue()) {
                    this.output.marker(Output.Verbosity.NORMAL).normal("Artifact {} ").outstanding("EXISTS").say(a);
                } else {
                    this.output.marker(Output.Verbosity.NORMAL).normal("Artifact {} ").scary("NOT EXISTS").say(a);
                }
            };
            reporter.accept((Artifact)artifact, exists);
            if (pom && !"pom".equals(artifact.getExtension())) {
                SubArtifact poma = new SubArtifact((Artifact)artifact, null, "pom");
                exists = this.toolboxSearchApi.exists(backend, (Artifact)poma);
                result.put(poma, exists);
                if (!exists && allRequired) {
                    missingOnes.add(poma);
                } else if (allRequired) {
                    existingOnes.add(poma);
                }
                reporter.accept((Artifact)poma, exists);
            }
            if (sources) {
                SubArtifact sourcesa = new SubArtifact((Artifact)artifact, "sources", "jar");
                exists = this.toolboxSearchApi.exists(backend, (Artifact)sourcesa);
                result.put(sourcesa, exists);
                if (!exists && allRequired) {
                    missingOnes.add(sourcesa);
                } else if (allRequired) {
                    existingOnes.add(sourcesa);
                }
                reporter.accept((Artifact)sourcesa, exists);
            }
            if (javadoc) {
                SubArtifact javadoca = new SubArtifact((Artifact)artifact, "javadoc", "jar");
                exists = this.toolboxSearchApi.exists(backend, (Artifact)javadoca);
                result.put(javadoca, exists);
                if (!exists && allRequired) {
                    missingOnes.add(javadoca);
                } else if (allRequired) {
                    existingOnes.add(javadoca);
                }
                reporter.accept((Artifact)javadoca, exists);
            }
            if (signature) {
                SubArtifact signaturea = new SubArtifact((Artifact)artifact, null, artifact.getExtension() + ".asc");
                exists = this.toolboxSearchApi.exists(backend, (Artifact)signaturea);
                result.put(signaturea, exists);
                if (!exists && allRequired) {
                    missingOnes.add(signaturea);
                } else if (allRequired) {
                    existingOnes.add(signaturea);
                }
                reporter.accept((Artifact)signaturea, exists);
            }
        }
        this.output.tell("", new Object[0]);
        this.output.marker(Output.Verbosity.TIGHT).emphasize("Checked TOTAL of {} (existing: {} not existing: {})").say(existingOnes.size() + missingOnes.size(), existingOnes.size(), missingOnes.size());
        return missingOnes.isEmpty() ? Result.success(result) : Result.failure("Missing artifacts");
    }

    @Override
    public Result<Map<String, Artifact>> identify(RemoteRepository remoteRepository, Collection<String> targets, boolean decorated) throws IOException {
        Map<String, Artifact> result;
        HashMap<String, String> sha1s = new HashMap<String, String>();
        for (String target : targets) {
            if (Files.exists(Paths.get(target, new String[0]), new LinkOption[0])) {
                try {
                    this.output.tell("Calculating SHA1 of file {}", target);
                    MessageDigest sha1md = MessageDigest.getInstance("SHA-1");
                    byte[] buf = new byte[8192];
                    try (FileInputStream fis = new FileInputStream(target);){
                        int read = fis.read(buf);
                        while (read != -1) {
                            sha1md.update(buf, 0, read);
                            read = fis.read(buf);
                        }
                    }
                    sha1s.put(target, ChecksumUtils.toHexString((byte[])sha1md.digest()));
                    continue;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("SHA1 MessageDigest unavailable", e);
                }
            }
            sha1s.put(target, target);
        }
        try (SearchBackend backend = this.toolboxSearchApi.getSmoBackend(this.context.repositorySystemSession(), remoteRepository);){
            result = this.toolboxSearchApi.identify(this.session(), backend, sha1s.values());
        }
        sha1s.forEach((key, value) -> {
            String hit;
            Artifact a = (Artifact)result.get(value);
            String string = hit = a != null ? a.toString() : "UNKNOWN";
            if (decorated) {
                if (!Objects.equals(key, value)) {
                    this.output.marker(Output.Verbosity.TIGHT).outstanding("{} ({}) = {}").say(value, key, hit);
                } else {
                    this.output.marker(Output.Verbosity.TIGHT).outstanding("{} = {}").say(value, hit);
                }
            } else {
                this.output.marker(Output.Verbosity.TIGHT).outstanding(hit).say(new Object[0]);
            }
        });
        return result.isEmpty() ? Result.failure("No matches") : Result.success(result);
    }

    @Override
    public Result<List<String>> list(RemoteRepository remoteRepository, String gavoid, String repositoryVendor) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (SearchBackend backend = this.toolboxSearchApi.getRemoteRepositoryBackend(this.context.repositorySystemSession(), remoteRepository, repositoryVendor);){
            String[] elements = gavoid.split(":");
            if (elements.length < 1 || elements.length > 3) {
                throw new IllegalArgumentException("Invalid gavoid");
            }
            FieldQuery query = FieldQuery.fieldQuery((Field)MAVEN.GROUP_ID, (String)elements[0]);
            if (elements.length > 1) {
                query = BooleanQuery.and((Query)query, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.ARTIFACT_ID, (String)elements[1])});
            }
            Predicate<String> versionPredicate = null;
            if (elements.length > 2) {
                try {
                    VersionConstraint versionConstraint = this.versionScheme.parseVersionConstraint(elements[2]);
                    if (versionConstraint.getRange() != null) {
                        versionPredicate = s -> {
                            try {
                                return versionConstraint.containsVersion(this.versionScheme.parseVersion(s));
                            }
                            catch (InvalidVersionSpecificationException e) {
                                return false;
                            }
                        };
                    }
                }
                catch (InvalidVersionSpecificationException versionConstraint) {
                    // empty catch block
                }
                if (versionPredicate == null) {
                    query = BooleanQuery.and((Query)query, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.VERSION, (String)elements[2])});
                }
            }
            SearchRequest searchRequest = new SearchRequest((Query)query);
            SearchResponse searchResponse = backend.search(searchRequest);
            List<String> gavoids = this.toolboxSearchApi.renderGavoid(searchResponse.getPage(), versionPredicate);
            for (String g : gavoids) {
                result.add(g);
                this.output.tell(g, new Object[0]);
            }
        }
        return Result.success(result);
    }

    @Override
    public Result<List<Artifact>> search(RemoteRepository remoteRepository, String expression) throws IOException {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        try (SearchBackend backend = this.toolboxSearchApi.getSmoBackend(this.context.repositorySystemSession(), remoteRepository);){
            Query query;
            try {
                query = this.toolboxSearchApi.toSmoQuery((Artifact)new DefaultArtifact(expression));
            }
            catch (IllegalArgumentException e) {
                query = Query.query((String)expression);
            }
            SearchRequest searchRequest = new SearchRequest(query);
            SearchResponse searchResponse = backend.search(searchRequest);
            Collection<Artifact> artifacts = this.toolboxSearchApi.renderArtifacts(this.session(), searchResponse.getPage(), null);
            for (Artifact artifact : artifacts) {
                result.add(artifact);
                this.output.tell(artifact.toString(), new Object[0]);
                this.output.suggest(artifact.getProperties().toString(), new Object[0]);
            }
            while (searchResponse.getCurrentHits() > 0) {
                searchResponse = backend.search(searchResponse.getSearchRequest().nextPage());
                artifacts = this.toolboxSearchApi.renderArtifacts(this.session(), searchResponse.getPage(), null);
                for (Artifact artifact : artifacts) {
                    result.add(artifact);
                    this.output.tell(artifact.toString(), new Object[0]);
                    this.output.suggest(artifact.getProperties().toString(), new Object[0]);
                }
            }
        }
        return Result.success(result);
    }

    @Override
    public Result<Boolean> verify(RemoteRepository remoteRepository, String gav, String sha1, String repositoryVendor) throws IOException {
        try (SearchBackend backend = this.toolboxSearchApi.getRemoteRepositoryBackend(this.context.repositorySystemSession(), remoteRepository, repositoryVendor);){
            DefaultArtifact artifact = new DefaultArtifact(gav);
            boolean verified = this.toolboxSearchApi.verify(backend, (Artifact)new DefaultArtifact(gav), sha1);
            this.output.tell("Artifact SHA1({})={}: {}", artifact, sha1, verified ? "MATCHED" : "NOT MATCHED");
            Result<Boolean> result = Result.success(verified);
            return result;
        }
    }

    @Override
    public Result<Float> libYear(String subject, ResolutionScope resolutionScope, ResolutionRoot resolutionRoot, boolean transitive, boolean upToDate, Predicate<Version> versionPredicate, BiFunction<Artifact, List<Version>, String> artifactVersionSelector, String repositoryVendor) throws Exception {
        LibYearSink sink;
        ArrayList<SearchBackend> searchBackends = new ArrayList<SearchBackend>();
        for (RemoteRepository remoteRepository : this.context.remoteRepositories()) {
            searchBackends.add(this.toolboxSearchApi.getRemoteRepositoryBackend(this.context.repositorySystemSession(), remoteRepository, repositoryVendor));
        }
        try (LibYearSink libYearSink = sink = LibYearSink.libYear(this.output, subject, this.context, this.toolboxResolver, this.toolboxSearchApi, upToDate, versionPredicate, artifactVersionSelector, searchBackends);){
            try {
                final ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
                ResolutionRoot root = this.toolboxResolver.loadRoot(resolutionRoot);
                if (transitive) {
                    final CollectResult collectResult = this.toolboxResolver.collect(resolutionScope, root.getArtifact(), root.getDependencies(), root.getManagedDependencies(), false);
                    collectResult.getRoot().accept(new DependencyVisitor(){

                        public boolean visitEnter(DependencyNode node) {
                            if (node != collectResult.getRoot()) {
                                artifacts.add(node.getArtifact());
                            }
                            return true;
                        }

                        public boolean visitLeave(DependencyNode node) {
                            return true;
                        }
                    });
                } else {
                    artifacts.addAll(resolutionRoot.getDependencies().stream().map(this::toArtifact).toList());
                }
                sink.accept(artifacts);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Result.success(Float.valueOf(sink.getTotalLibyear()));
    }

    @Override
    public Result<Map<Artifact, List<Version>>> versions(String context, Source<Artifact> artifactSource, Predicate<Version> versionPredicate) throws Exception {
        List<Artifact> artifacts = artifactSource.get().toList();
        HashMap<Artifact, List<Version>> result = new HashMap<Artifact, List<Version>>();
        this.output.marker(Output.Verbosity.NORMAL).emphasize("Checking newest versions of {} ({})").say(context, artifacts.size());
        for (Artifact artifact : artifacts) {
            List<Version> newer = this.toolboxResolver.findNewerVersions(artifact, versionPredicate);
            result.put(artifact, newer);
            if (!newer.isEmpty()) {
                Version latest = newer.getLast();
                String all = newer.stream().map(Object::toString).collect(Collectors.joining(", "));
                this.output.marker(Output.Verbosity.NORMAL).scary("* {} -> {}").say(ArtifactIdUtils.toId((Artifact)artifact), latest);
                this.output.marker(Output.Verbosity.SUGGEST).detail("  Available: {}").say(all);
                continue;
            }
            this.output.marker(Output.Verbosity.NORMAL).outstanding("* {} is up to date").say(ArtifactIdUtils.toId((Artifact)artifact));
        }
        return Result.success(result);
    }

    public static String humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.1f %ciB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }

    public static String discoverArtifactVersion(String groupId, String artifactId, String defVal) {
        Map<String, String> mavenPomProperties = ToolboxCommandoImpl.loadPomProperties(groupId, artifactId);
        String versionString = mavenPomProperties.getOrDefault("version", "").trim();
        if (!versionString.startsWith("${")) {
            return versionString;
        }
        return defVal;
    }

    public static Map<String, String> loadPomProperties(String groupId, String artifactId) {
        return ToolboxCommandoImpl.loadClasspathProperties("/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
    }

    public static Map<String, String> loadClasspathProperties(String resource) {
        Properties props = new Properties();
        try (InputStream is = RuntimeSupport.class.getResourceAsStream(resource);){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
    }
}

