/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.internal.ToolboxResolverImpl;
import eu.maveniverse.maven.toolbox.shared.internal.ToolboxSearchApiImpl;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.maven.search.api.Record;
import org.apache.maven.search.api.SearchBackend;
import org.apache.maven.search.api.SearchRequest;
import org.apache.maven.search.api.SearchResponse;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.version.Version;

public final class LibYearSink
implements Artifacts.Sink {
    private final Output output;
    private final String subject;
    private final Context context;
    private final ToolboxResolverImpl toolboxResolver;
    private final ToolboxSearchApiImpl toolboxSearchApi;
    private final boolean upToDate;
    private final Predicate<Version> versionFilter;
    private final BiFunction<Artifact, List<Version>, String> versionSelector;
    private final LocalDate now;
    private final CopyOnWriteArraySet<Artifact> artifacts;
    private final DoubleAdder totalLibyearAdder;
    private final List<SearchBackend> searchBackends;

    public static LibYearSink libYear(Output output, String subject, Context context, ToolboxResolverImpl toolboxResolver, ToolboxSearchApiImpl toolboxSearchApi, boolean upToDate, Predicate<Version> versionFilter, BiFunction<Artifact, List<Version>, String> versionSelector, List<SearchBackend> searchBackends) {
        return new LibYearSink(output, subject, context, toolboxResolver, toolboxSearchApi, upToDate, versionFilter, versionSelector, searchBackends);
    }

    private LibYearSink(Output output, String subject, Context context, ToolboxResolverImpl toolboxResolver, ToolboxSearchApiImpl toolboxSearchApi, boolean upToDate, Predicate<Version> versionFilter, BiFunction<Artifact, List<Version>, String> versionSelector, List<SearchBackend> searchBackends) {
        this.output = Objects.requireNonNull(output, "logger");
        this.subject = Objects.requireNonNull(subject, "subject");
        this.context = Objects.requireNonNull(context, "context");
        this.toolboxResolver = Objects.requireNonNull(toolboxResolver, "toolboxResolver");
        this.toolboxSearchApi = Objects.requireNonNull(toolboxSearchApi, "toolboxSearchApi");
        this.upToDate = upToDate;
        this.versionFilter = Objects.requireNonNull(versionFilter);
        this.versionSelector = Objects.requireNonNull(versionSelector);
        this.now = Instant.now().atZone(ZoneId.systemDefault()).toLocalDate();
        this.artifacts = new CopyOnWriteArraySet();
        this.totalLibyearAdder = new DoubleAdder();
        this.searchBackends = Objects.requireNonNull(searchBackends);
    }

    public float getTotalLibyear() {
        return this.totalLibyearAdder.floatValue();
    }

    public ConcurrentMap<Artifact, LibYear> getLibYear() {
        ConcurrentHashMap result = (ConcurrentHashMap)this.context.repositorySystemSession().getData().get(LibYear.class);
        if (result == null) {
            result = new ConcurrentHashMap();
            this.context.repositorySystemSession().getData().set(LibYear.class, result);
        }
        return result;
    }

    @Override
    public void accept(Artifact artifact) throws IOException {
        Objects.requireNonNull(artifact, "artifact");
        this.getLibYear().computeIfAbsent(artifact, a -> {
            this.output.chatter("Accepted and calculating libYear for {}", artifact);
            String currentVersion = artifact.getVersion();
            Instant currentVersionInstant = null;
            List<Version> allVersions = null;
            String latestVersion = currentVersion;
            Instant latestVersionInstant = null;
            try {
                currentVersionInstant = this.artifactPublishDate(artifact);
                allVersions = this.toolboxResolver.findNewerVersions(artifact, this.versionFilter);
                latestVersion = this.versionSelector.apply(artifact, allVersions);
                latestVersionInstant = Objects.equals(currentVersion, latestVersion) ? currentVersionInstant : this.artifactPublishDate(artifact.setVersion(latestVersion));
            }
            catch (VersionRangeResolutionException versionRangeResolutionException) {
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return new LibYear(currentVersion, currentVersionInstant, allVersions, latestVersion, latestVersionInstant);
        });
        this.artifacts.add(artifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws DeploymentException {
        try {
            TreeMap outdatedWithLibyear = new TreeMap(Collections.reverseOrder());
            TreeSet<String> outdatedWithoutLibyear = new TreeSet<String>();
            TreeSet<String> upToDateByAge = new TreeSet<String>();
            for (Artifact artifact : this.artifacts) {
                float libCurrentYearsAge;
                LibYear libYear = (LibYear)this.getLibYear().get(artifact);
                if (libYear == null) continue;
                if (libYear.isUpToDate()) {
                    libCurrentYearsAge = libYear.yearsBetween(libYear.currentVersionDate, this.now);
                    if (libCurrentYearsAge != -1.0f) {
                        upToDateByAge.add(String.format("%s %s (%s) [latest is %.2f years old]", ArtifactIdUtils.toVersionlessId((Artifact)artifact), libYear.currentVersion, libYear.currentVersionDate, Float.valueOf(libCurrentYearsAge)));
                        continue;
                    }
                    upToDateByAge.add(String.format("%s %s (%s) [latest age unknown]", ArtifactIdUtils.toVersionlessId((Artifact)artifact), libYear.currentVersion, libYear.currentVersionDate == null ? "?" : libYear.currentVersionDate));
                    continue;
                }
                libCurrentYearsAge = libYear.yearsBetween(libYear.currentVersionDate, libYear.latestVersionDate);
                float libLatestYearsAge = libYear.yearsBetween(libYear.latestVersionDate, this.now);
                if (libCurrentYearsAge != -1.0f && !libYear.currentVersionDate.isAfter(libYear.latestVersionDate)) {
                    this.totalLibyearAdder.add(libCurrentYearsAge);
                    outdatedWithLibyear.computeIfAbsent(Float.valueOf(libCurrentYearsAge), k -> new CopyOnWriteArrayList()).add(String.format("%.2f years from %s %s (%s) => %s (%s) [latest is %.2f years old]", Float.valueOf(libCurrentYearsAge), ArtifactIdUtils.toVersionlessId((Artifact)artifact), libYear.currentVersion, libYear.currentVersionDate, libYear.latestVersion, libYear.latestVersionDate, Float.valueOf(libLatestYearsAge)));
                    continue;
                }
                outdatedWithoutLibyear.add(String.format("%s %s (%s) => %s (%s)", ArtifactIdUtils.toVersionlessId((Artifact)artifact), libYear.currentVersion, libYear.currentVersionDate == null ? "?" : libYear.currentVersionDate, libYear.latestVersion, libYear.latestVersionDate == null ? "?" : libYear.latestVersionDate));
            }
            this.output.marker(Output.Verbosity.NORMAL).emphasize("Calculated libYear for {}").say(this.subject);
            this.output.tell("", new Object[0]);
            if (!outdatedWithLibyear.isEmpty()) {
                this.output.marker(Output.Verbosity.NORMAL).emphasize("  Outdated versions with known age").say(new Object[0]);
                outdatedWithLibyear.values().stream().flatMap(Collection::stream).forEach(l -> this.output.marker(Output.Verbosity.NORMAL).scary("  " + l).say(new Object[0]));
                this.output.tell("", new Object[0]);
            }
            if (!outdatedWithoutLibyear.isEmpty()) {
                this.output.marker(Output.Verbosity.NORMAL).emphasize("  Outdated versions without known age").say(new Object[0]);
                outdatedWithoutLibyear.forEach(l -> this.output.marker(Output.Verbosity.NORMAL).scary("  " + l).say(new Object[0]));
                this.output.tell("", new Object[0]);
            }
            if (this.upToDate && !upToDateByAge.isEmpty()) {
                this.output.marker(Output.Verbosity.NORMAL).emphasize("  Up to date versions").say(new Object[0]);
                upToDateByAge.forEach(l -> this.output.marker(Output.Verbosity.NORMAL).outstanding("  " + l).say(new Object[0]));
                this.output.tell("", new Object[0]);
            }
            this.output.marker(Output.Verbosity.TIGHT).emphasize("Total of {} years from {} outdated dependencies for {}").say(String.format("%.2f", Float.valueOf(this.getTotalLibyear())), outdatedWithLibyear.values().stream().mapToInt(List::size).sum() + outdatedWithoutLibyear.size(), this.subject);
            this.output.tell("", new Object[0]);
        }
        finally {
            this.searchBackends.forEach(b -> {
                try {
                    b.close();
                }
                catch (Exception e) {
                    this.output.tell("Could not close SearchBackend", e);
                }
            });
        }
    }

    private Instant artifactPublishDate(Artifact artifact) throws IOException {
        for (SearchBackend backend : this.searchBackends) {
            Long lastUpdated;
            SearchRequest searchRequest;
            SearchResponse searchResponse = backend.search(searchRequest = new SearchRequest(this.toolboxSearchApi.toRrQuery(artifact)));
            if (searchResponse.getCurrentHits() <= 0 || (lastUpdated = ((Record)searchResponse.getPage().getFirst()).getLastUpdated()) == null) continue;
            return Instant.ofEpochMilli(lastUpdated);
        }
        return null;
    }

    public static final class LibYear {
        public static final float UNKNOWN_AGE = -1.0f;
        public final String currentVersion;
        public final Instant currentVersionInstant;
        public final LocalDate currentVersionDate;
        public final List<Version> allVersions;
        public final String latestVersion;
        public final Instant latestVersionInstant;
        public final LocalDate latestVersionDate;

        private LibYear(String currentVersion, Instant currentVersionInstant, List<Version> allVersions, String latestVersion, Instant latestVersionInstant) {
            this.currentVersion = currentVersion;
            this.currentVersionInstant = currentVersionInstant;
            this.currentVersionDate = currentVersionInstant != null ? currentVersionInstant.atZone(ZoneId.systemDefault()).toLocalDate() : null;
            this.allVersions = List.copyOf(allVersions);
            this.latestVersion = latestVersion;
            this.latestVersionInstant = latestVersionInstant;
            this.latestVersionDate = latestVersionInstant != null ? latestVersionInstant.atZone(ZoneId.systemDefault()).toLocalDate() : null;
        }

        public boolean isUpToDate() {
            return Objects.equals(this.currentVersion, this.latestVersion);
        }

        public float yearsBetween(LocalDate from, LocalDate to) {
            if (from != null && to != null) {
                return (float)ChronoUnit.WEEKS.between(from, to) / 52.0f;
            }
            return -1.0f;
        }
    }
}

