/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.HashMap;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.RemoteRepository;

public final class Java11HttpClientFactory {
    public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);

    public static HttpClient buildHttpClient(RepositorySystemSession session, RemoteRepository repository) {
        return Java11HttpClientFactory.buildHttpClient(DEFAULT_TIMEOUT, session, repository);
    }

    private static HttpClient buildHttpClient(Duration timeout, RepositorySystemSession session, RemoteRepository repository) {
        HttpClient.Builder builder = HttpClient.newBuilder().connectTimeout(timeout).followRedirects(HttpClient.Redirect.NEVER);
        final HashMap<Authenticator.RequestorType, PasswordAuthentication> authentications = new HashMap<Authenticator.RequestorType, PasswordAuthentication>();
        try (AuthenticationContext repoAuthContext = AuthenticationContext.forRepository((RepositorySystemSession)session, (RemoteRepository)repository);){
            if (repoAuthContext != null) {
                authentications.put(Authenticator.RequestorType.SERVER, new PasswordAuthentication(repoAuthContext.get("username"), repoAuthContext.get("password").toCharArray()));
            }
        }
        if (repository.getProxy() != null) {
            builder.proxy(ProxySelector.of(new InetSocketAddress(repository.getProxy().getHost(), repository.getProxy().getPort())));
            try (AuthenticationContext proxyAuthContext = AuthenticationContext.forProxy((RepositorySystemSession)session, (RemoteRepository)repository);){
                if (proxyAuthContext != null) {
                    authentications.put(Authenticator.RequestorType.PROXY, new PasswordAuthentication(proxyAuthContext.get("username"), proxyAuthContext.get("password").toCharArray()));
                }
            }
        }
        if (!authentications.isEmpty()) {
            builder.authenticator(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return (PasswordAuthentication)authentications.get((Object)this.getRequestorType());
                }
            });
        }
        return builder.build();
    }
}

