/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.toolbox.shared.ArtifactMapper;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactNameMapper;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.DependencyMatcher;
import eu.maveniverse.maven.toolbox.shared.ReactorLocator;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.Sink;
import eu.maveniverse.maven.toolbox.shared.Source;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommandoVersion;
import eu.maveniverse.maven.toolbox.shared.internal.ToolboxCommandoImpl;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;

public interface ToolboxCommando {
    public static ToolboxCommando create(Output output, Context context) {
        Objects.requireNonNull(output, "output");
        Objects.requireNonNull(context, "context");
        return new ToolboxCommandoImpl(output, context);
    }

    default public String getVersion() {
        return ToolboxCommandoVersion.getVersion();
    }

    public Result<String> dump();

    public ArtifactMapper parseArtifactMapperSpec(String var1);

    public ArtifactMatcher parseArtifactMatcherSpec(String var1);

    public ArtifactNameMapper parseArtifactNameMapperSpec(String var1);

    public DependencyMatcher parseDependencyMatcherSpec(String var1);

    public ArtifactVersionMatcher parseArtifactVersionMatcherSpec(String var1);

    public ArtifactVersionSelector parseArtifactVersionSelectorSpec(String var1);

    public RemoteRepository parseRemoteRepository(String var1);

    public Source<Artifact> artifactSource(String var1);

    public Sink<Artifact> artifactSink(String var1);

    public Sink<Dependency> dependencySink(String var1);

    default public ResolutionRoot loadGav(String gav) throws InvalidVersionSpecificationException, VersionRangeResolutionException, ArtifactDescriptorException {
        return this.loadGav(gav, Collections.emptyList());
    }

    public ResolutionRoot loadGav(String var1, Collection<String> var2) throws InvalidVersionSpecificationException, VersionRangeResolutionException, ArtifactDescriptorException;

    default public Collection<ResolutionRoot> loadGavs(Collection<String> gav, Collection<String> boms) throws InvalidVersionSpecificationException, VersionRangeResolutionException, ArtifactDescriptorException {
        ArrayList<ResolutionRoot> result = new ArrayList<ResolutionRoot>(gav.size());
        for (String gavEntry : gav) {
            result.add(this.loadGav(gavEntry, boms));
        }
        return result;
    }

    public Artifact toArtifact(Dependency var1);

    public Result<String> classpath(ResolutionScope var1, ResolutionRoot var2) throws Exception;

    public Result<List<Artifact>> copy(Source<Artifact> var1, Sink<Artifact> var2) throws Exception;

    public Result<List<Artifact>> copyTransitive(ResolutionScope var1, Collection<ResolutionRoot> var2, Sink<Artifact> var3) throws Exception;

    public Result<List<Artifact>> copyRecorded(boolean var1, Sink<Artifact> var2) throws Exception;

    default public Result<List<RemoteRepository>> listRepositories(ResolutionScope resolutionScope, String context, ResolutionRoot resolutionRoot) throws Exception {
        HashMap<String, ResolutionRoot> resolutionRoots = new HashMap<String, ResolutionRoot>();
        resolutionRoots.put(context, resolutionRoot);
        Result<Map<String, List<RemoteRepository>>> result = this.listRepositories(resolutionScope, resolutionRoots);
        return result.isSuccess() ? Result.success(result.getData().orElseThrow().get(context)) : Result.failure(result.getMessage());
    }

    public Result<Map<String, List<RemoteRepository>>> listRepositories(ResolutionScope var1, Map<String, ResolutionRoot> var2) throws Exception;

    public Result<List<Artifact>> listAvailablePlugins(Collection<String> var1) throws Exception;

    public Result<String> recordStart();

    public Result<RecordStats> recordStats();

    public Result<String> recordStop();

    public Result<List<Artifact>> resolve(Source<Artifact> var1, boolean var2, boolean var3, boolean var4, Sink<Artifact> var5) throws Exception;

    public Result<List<Artifact>> resolveTransitive(ResolutionScope var1, Collection<ResolutionRoot> var2, boolean var3, boolean var4, boolean var5, Sink<Artifact> var6) throws Exception;

    public Result<CollectResult> tree(ResolutionScope var1, ResolutionRoot var2, boolean var3, DependencyMatcher var4) throws Exception;

    public Result<CollectResult> dirtyTree(ResolutionScope var1, ResolutionRoot var2, int var3, boolean var4, DependencyMatcher var5) throws Exception;

    public Result<List<List<Artifact>>> treeFind(ResolutionScope var1, ResolutionRoot var2, boolean var3, ArtifactMatcher var4) throws Exception;

    public Result<List<Dependency>> dmList(ResolutionRoot var1, boolean var2) throws Exception;

    public Result<CollectResult> dmTree(ResolutionRoot var1, boolean var2) throws Exception;

    public Result<CollectResult> parentChildTree(ReactorLocator var1) throws Exception;

    public Result<CollectResult> subprojectTree(ReactorLocator var1) throws Exception;

    public Result<CollectResult> projectDependencyTree(ReactorLocator var1, boolean var2) throws Exception;

    public Map<String, RemoteRepository> getKnownSearchRemoteRepositories();

    public Result<Map<Artifact, Boolean>> exists(RemoteRepository var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, String var8) throws IOException;

    public Result<Map<String, Artifact>> identify(RemoteRepository var1, Collection<String> var2, boolean var3) throws IOException;

    public Result<List<String>> list(RemoteRepository var1, String var2, String var3) throws IOException;

    public Result<List<Artifact>> search(RemoteRepository var1, String var2) throws IOException;

    public Result<Boolean> verify(RemoteRepository var1, String var2, String var3, String var4) throws IOException;

    public Result<Float> libYear(String var1, ResolutionScope var2, ResolutionRoot var3, boolean var4, boolean var5, Predicate<Version> var6, BiFunction<Artifact, List<Version>, String> var7, String var8) throws Exception;

    public Result<Map<Artifact, List<Version>>> versions(String var1, Source<Artifact> var2, Predicate<Version> var3) throws Exception;

    public static final class RecordStats {
        public final boolean active;
        public final int recordedCount;

        public RecordStats(boolean active, int recordedCount) {
            this.active = active;
            this.recordedCount = recordedCount;
        }
    }
}

