/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactNameMapper;
import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.internal.IndexFileWriter;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.aether.artifact.Artifact;

public final class DirectorySink
implements Artifacts.Sink {
    private final Output output;
    private final Path directory;
    private final boolean directoryCreated;
    private final Mode mode;
    private final Predicate<Artifact> artifactMatcher;
    private final boolean failIfUnmatched;
    private final Function<Artifact, String> artifactNameMapper;
    private final boolean allowOverwrite;
    private final HashSet<Path> writtenPaths;
    private final Path indexFile;
    private final IndexFileWriter indexFileWriter;
    private final StandardCopyOption[] copyFlags;

    public static DirectorySink flat(Output output, Path path, ArtifactNameMapper artifactNameMapper) throws IOException {
        return new DirectorySink(output, path, Mode.COPY, ArtifactMatcher.unique(), false, artifactNameMapper, false);
    }

    public static DirectorySink repository(Output output, Path path) throws IOException {
        return new DirectorySink(output, path, Mode.COPY, ArtifactMatcher.and(ArtifactMatcher.not(ArtifactMatcher.snapshot()), ArtifactMatcher.unique()), true, ArtifactNameMapper.repositoryDefault(), false);
    }

    private DirectorySink(Output output, Path directory, Mode mode, Predicate<Artifact> artifactMatcher, boolean failIfUnmatched, Function<Artifact, String> artifactNameMapper, boolean allowOverwrite) throws IOException {
        StandardCopyOption[] standardCopyOptionArray;
        this.output = Objects.requireNonNull(output, "output");
        this.directory = Objects.requireNonNull(directory, "directory").toAbsolutePath();
        this.mode = Objects.requireNonNull(mode, "mode");
        if (Files.exists(directory, new LinkOption[0]) && !Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("directory must not exists, or must be a directory");
        }
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
            this.directoryCreated = true;
        } else {
            this.directoryCreated = false;
        }
        this.artifactMatcher = Objects.requireNonNull(artifactMatcher, "artifactMatcher");
        this.failIfUnmatched = failIfUnmatched;
        this.artifactNameMapper = Objects.requireNonNull(artifactNameMapper, "artifactNameMapper");
        this.allowOverwrite = allowOverwrite;
        this.writtenPaths = new HashSet();
        this.indexFile = directory.resolve(".index");
        this.indexFileWriter = new IndexFileWriter(this.indexFile, !this.directoryCreated);
        if (allowOverwrite) {
            StandardCopyOption[] standardCopyOptionArray2 = new StandardCopyOption[2];
            standardCopyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
            standardCopyOptionArray = standardCopyOptionArray2;
            standardCopyOptionArray2[1] = StandardCopyOption.COPY_ATTRIBUTES;
        } else {
            StandardCopyOption[] standardCopyOptionArray3 = new StandardCopyOption[1];
            standardCopyOptionArray = standardCopyOptionArray3;
            standardCopyOptionArray3[0] = StandardCopyOption.COPY_ATTRIBUTES;
        }
        this.copyFlags = standardCopyOptionArray;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public Path getIndexFile() {
        return this.indexFile;
    }

    @Override
    public void accept(Artifact artifact) throws IOException {
        Objects.requireNonNull(artifact, "artifact");
        if (this.artifactMatcher.test(artifact)) {
            String name = this.artifactNameMapper.apply(artifact);
            Path target = this.directory.resolve(name).toAbsolutePath();
            if (!target.startsWith(this.directory)) {
                throw new IOException("Path escape prevented; check mappings");
            }
            if (!this.writtenPaths.add(target) && !this.allowOverwrite) {
                throw new IOException("Overwrite prevented; check mappings");
            }
            this.output.chatter("Accepting artifact {} -> ", artifact, target);
            this.indexFileWriter.write(artifact, name);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            switch (this.mode.ordinal()) {
                case 0: {
                    Files.copy(artifact.getFile().toPath(), target, (CopyOption[])this.copyFlags);
                    break;
                }
                case 1: {
                    Files.createLink(target, artifact.getFile().toPath());
                    break;
                }
                case 2: {
                    Files.createSymbolicLink(target, artifact.getFile().toPath(), new FileAttribute[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown mode");
                }
            }
        } else if (this.failIfUnmatched) {
            throw new IllegalArgumentException("not matched");
        }
    }

    @Override
    public void cleanup(Exception e) {
        this.indexFileWriter.fail();
        this.writtenPaths.forEach(p -> {
            try {
                Files.deleteIfExists(p);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        if (this.directoryCreated) {
            try {
                Files.deleteIfExists(this.directory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.indexFileWriter.close();
    }

    public static enum Mode {
        COPY,
        LINK,
        SYMLINK;

    }
}

