/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;

public interface ArtifactVersionSelector
extends BiFunction<Artifact, List<Version>, String> {
    public static ArtifactVersionSelector identity() {
        return new ArtifactVersionSelector(){

            @Override
            public String apply(Artifact artifact, List<Version> versions) {
                return artifact.getVersion();
            }
        };
    }

    public static ArtifactVersionSelector last() {
        return new ArtifactVersionSelector(){

            @Override
            public String apply(Artifact artifact, List<Version> versions) {
                return versions.isEmpty() ? (String)ArtifactVersionSelector.identity().apply(artifact, versions) : versions.get(versions.size() - 1).toString();
            }
        };
    }

    public static ArtifactVersionSelector first() {
        return new ArtifactVersionSelector(){

            @Override
            public String apply(Artifact artifact, List<Version> versions) {
                return versions.isEmpty() ? (String)ArtifactVersionSelector.identity().apply(artifact, versions) : versions.get(0).toString();
            }
        };
    }

    public static ArtifactVersionSelector major() {
        return new ArtifactVersionSelector(){

            @Override
            public String apply(Artifact artifact, List<Version> versions) {
                String ver = artifact.getVersion();
                int firstDot = ver.indexOf(46);
                if (firstDot > 0) {
                    String prefix = ver.substring(0, firstDot);
                    for (int i = versions.size() - 1; i >= 0; --i) {
                        String version = versions.get(i).toString();
                        if (!version.startsWith(prefix)) continue;
                        return version;
                    }
                }
                return (String)ArtifactVersionSelector.identity().apply(artifact, versions);
            }
        };
    }

    public static ArtifactVersionSelector minor() {
        return new ArtifactVersionSelector(){

            @Override
            public String apply(Artifact artifact, List<Version> versions) {
                int secondDot;
                String ver = artifact.getVersion();
                int firstDot = ver.indexOf(46);
                if (firstDot > 0 && (secondDot = ver.indexOf(46, firstDot + 1)) > firstDot) {
                    String prefix = ver.substring(0, secondDot);
                    for (int i = versions.size() - 1; i >= 0; --i) {
                        String version = versions.get(i).toString();
                        if (!version.startsWith(prefix)) continue;
                        return version;
                    }
                }
                return (String)ArtifactVersionSelector.identity().apply(artifact, versions);
            }
        };
    }

    public static ArtifactVersionSelector filtered(final Predicate<Version> filter, final ArtifactVersionSelector selector) {
        Objects.requireNonNull(filter, "filter");
        Objects.requireNonNull(selector, "selector");
        return new ArtifactVersionSelector(){

            @Override
            public String apply(Artifact artifact, List<Version> versions) {
                return (String)selector.apply(artifact, versions.stream().filter(filter).collect(Collectors.toList()));
            }
        };
    }

    public static ArtifactVersionSelector noPreviews(ArtifactVersionSelector selector) {
        return ArtifactVersionSelector.filtered(ArtifactVersionMatcher.not(ArtifactVersionMatcher.preview()), selector);
    }

    public static ArtifactVersionSelector noSnapshots(ArtifactVersionSelector selector) {
        return ArtifactVersionSelector.filtered(ArtifactVersionMatcher.not(ArtifactVersionMatcher.snapshot()), selector);
    }

    public static ArtifactVersionSelector noSnapshotsAndPreviews(ArtifactVersionSelector selector) {
        return ArtifactVersionSelector.filtered(ArtifactVersionMatcher.and(ArtifactVersionMatcher.not(ArtifactVersionMatcher.snapshot()), ArtifactVersionMatcher.not(ArtifactVersionMatcher.preview())), selector);
    }

    public static ArtifactVersionSelector build(VersionScheme versionScheme, Map<String, ?> properties, String spec) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(spec, "spec");
        ArtifactVersionSelectorBuilder builder = new ArtifactVersionSelectorBuilder(versionScheme, properties);
        SpecParser.parse(spec).accept(builder);
        return builder.build();
    }

    public static class ArtifactVersionSelectorBuilder
    extends SpecParser.Builder {
        private final VersionScheme versionScheme;

        public ArtifactVersionSelectorBuilder(VersionScheme versionScheme, Map<String, ?> properties) {
            super(properties);
            this.versionScheme = Objects.requireNonNull(versionScheme);
        }

        @Override
        public boolean visitEnter(SpecParser.Node node) {
            return super.visitEnter(node) && !"filtered".equals(node.getValue());
        }

        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "identity": {
                    this.params.add(ArtifactVersionSelector.identity());
                    break;
                }
                case "first": {
                    this.params.add(ArtifactVersionSelector.first());
                    break;
                }
                case "last": {
                    this.params.add(ArtifactVersionSelector.last());
                    break;
                }
                case "major": {
                    this.params.add(ArtifactVersionSelector.major());
                    break;
                }
                case "minor": {
                    this.params.add(ArtifactVersionSelector.minor());
                    break;
                }
                case "filtered": {
                    if (node.getChildren().size() != 2) {
                        throw new IllegalArgumentException("op filtered accepts only 2 argument");
                    }
                    ArtifactVersionSelectorBuilder selectorBuilder = new ArtifactVersionSelectorBuilder(this.versionScheme, this.properties);
                    node.getChildren().get(1).accept(selectorBuilder);
                    ArtifactVersionSelector selector = selectorBuilder.build();
                    ArtifactVersionMatcher.ArtifactVersionMatcherBuilder matcherBuilder = new ArtifactVersionMatcher.ArtifactVersionMatcherBuilder(this.versionScheme, this.properties);
                    node.getChildren().get(0).accept(matcherBuilder);
                    ArtifactVersionMatcher matcher = matcherBuilder.build();
                    node.getChildren().clear();
                    this.params.add(ArtifactVersionSelector.filtered(matcher, selector));
                    break;
                }
                case "noPreviews": {
                    this.params.add(ArtifactVersionSelector.noPreviews(this.typedParam(ArtifactVersionSelector.class, node.getValue())));
                    break;
                }
                case "noSnapshots": {
                    this.params.add(ArtifactVersionSelector.noSnapshots(this.typedParam(ArtifactVersionSelector.class, node.getValue())));
                    break;
                }
                case "noSnapshotsAndPreviews": {
                    this.params.add(ArtifactVersionSelector.noSnapshotsAndPreviews(this.typedParam(ArtifactVersionSelector.class, node.getValue())));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        public ArtifactVersionSelector build() {
            return this.build(ArtifactVersionSelector.class);
        }
    }
}

