/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.DependencyMatcher;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import picocli.CommandLine;

@Mojo(name="versions", threadSafe=true)
public class VersionsMojo
extends MPMojoSupport {
    @Parameter(property="depSpec", defaultValue="any()")
    private String depSpec;
    @Parameter(property="artifactVersionMatcherSpec", defaultValue="noSnapshotsAndPreviews()")
    private String artifactVersionMatcherSpec;
    @CommandLine.Option(names={"--artifactVersionSelectorSpec"}, defaultValue="last()", description={"Artifact version selector spec (default 'last()')"})
    @Parameter(property="artifactVersionSelectorSpec", defaultValue="last()")
    private String artifactVersionSelectorSpec;
    @Parameter(property="applyToPom")
    private boolean applyToPom;

    protected Result<Boolean> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        DependencyMatcher dependencyMatcher = toolboxCommando.parseDependencyMatcherSpec(this.depSpec);
        ArtifactVersionMatcher artifactVersionMatcher = toolboxCommando.parseArtifactVersionMatcherSpec(this.artifactVersionMatcherSpec);
        ArtifactVersionSelector artifactVersionSelector = toolboxCommando.parseArtifactVersionSelectorSpec(this.artifactVersionSelectorSpec);
        Result managedDependencies = toolboxCommando.versions("managed dependencies", () -> this.projectManagedDependenciesAsResolutionRoots(dependencyMatcher).stream().map(ResolutionRoot::getArtifact), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        Result dependencies = toolboxCommando.versions("dependencies", () -> this.projectDependenciesAsResolutionRoots(dependencyMatcher).stream().map(ResolutionRoot::getArtifact), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        if (this.applyToPom) {
            List managedDependenciesUpdates = toolboxCommando.calculateUpdates((Map)managedDependencies.getData().orElseThrow(), (BiFunction)artifactVersionSelector);
            List dependenciesUpdates = toolboxCommando.calculateUpdates((Map)dependencies.getData().orElseThrow(), (BiFunction)artifactVersionSelector);
            if (!managedDependenciesUpdates.isEmpty() || !dependenciesUpdates.isEmpty()) {
                try (ToolboxCommando.EditSession editSession = toolboxCommando.createEditSession(this.mavenProject.getFile().toPath());){
                    if (!managedDependenciesUpdates.isEmpty()) {
                        toolboxCommando.doEdit(editSession, ToolboxCommando.OpSubject.MANAGED_DEPENDENCIES, ToolboxCommando.Op.UPDATE, managedDependenciesUpdates::stream);
                    }
                    if (!dependenciesUpdates.isEmpty()) {
                        toolboxCommando.doEdit(editSession, ToolboxCommando.OpSubject.DEPENDENCIES, ToolboxCommando.Op.UPDATE, dependenciesUpdates::stream);
                    }
                }
            }
        }
        return Result.success((Object)true);
    }
}

