/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPPluginMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.util.List;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

@Mojo(name="check-exclusions", threadSafe=true)
public class CheckExclusionsMojo
extends MPPluginMojoSupport {
    @Parameter(property="verboseTree", defaultValue="false", required=true)
    private boolean verboseTree;

    protected Result<Boolean> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        ResolutionRoot project = this.projectAsResolutionRoot();
        for (Dependency dependency : project.getDependencies()) {
            for (Exclusion exclusion : dependency.getExclusions()) {
                ResolutionRoot dependencyRoot = this.isReactorDependency(dependency) ? ResolutionRoot.ofNotLoaded((Artifact)dependency.getArtifact()).build() : ResolutionRoot.ofLoaded((Artifact)dependency.getArtifact()).build();
                this.getOutput().marker(Output.Verbosity.NORMAL).normal("Checking dependency ").emphasize(dependency.toString()).normal(" exclusion ").emphasize(exclusion.toString()).normal(" paths").say(new Object[0]);
                Result paths = toolboxCommando.treeFind(ResolutionScope.RUNTIME, dependencyRoot, this.verboseTree, this.artifactMatcher(dependency.getArtifact(), exclusion));
                if (paths.getData().isPresent() && ((List)paths.getData().orElseThrow()).isEmpty()) {
                    this.getOutput().marker(Output.Verbosity.NORMAL).scary("Is unused").say(new Object[0]);
                } else {
                    this.getOutput().marker(Output.Verbosity.NORMAL).outstanding("Is used").say(new Object[0]);
                }
                this.getOutput().doTell("", new Object[0]);
            }
        }
        return Result.success((Object)true);
    }

    protected ArtifactMatcher artifactMatcher(Artifact root, Exclusion exclusion) {
        return ArtifactMatcher.and((ArtifactMatcher[])new ArtifactMatcher[]{ArtifactMatcher.not((ArtifactMatcher)ArtifactMatcher.artifact((String)root.toString())), ArtifactMatcher.artifact((String)(this.asteriskOrString(exclusion.getGroupId()) + ":" + this.asteriskOrString(exclusion.getArtifactId()) + ":" + this.asteriskOrString(exclusion.getClassifier()) + ":" + this.asteriskOrString(exclusion.getExtension()) + ":*"))});
    }

    protected String asteriskOrString(String str) {
        if (str == null || str.trim().isEmpty()) {
            return "*";
        }
        return str;
    }
}

