/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavSearchMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import picocli.CommandLine;

@CommandLine.Command(name="exists", description={"Checks Maven Artifact existence"})
@Mojo(name="gav-exists", requiresProject=false, threadSafe=true)
public class GavExistsMojo
extends GavSearchMojoSupport {
    @CommandLine.Parameters(index="0", description={"The GAV to check for"})
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--pom"}, description={"Check POM presence as well (derive coordinates from GAV)"})
    @Parameter(property="pom", defaultValue="false")
    private boolean pom;
    @CommandLine.Option(names={"--sources"}, description={"Check sources JAR as well (derive coordinates from GAV)"})
    @Parameter(property="sources", defaultValue="false")
    private boolean sources;
    @CommandLine.Option(names={"--javadoc"}, description={"Check javadoc JAR as well (derive coordinates from GAV)"})
    @Parameter(property="javadoc", defaultValue="false")
    private boolean javadoc;
    @CommandLine.Option(names={"--signature"}, description={"Check GnuPG signature as well (derive coordinates from GAV)"})
    @Parameter(property="signature", defaultValue="false")
    private boolean signature;
    @CommandLine.Option(names={"--all-required"}, description={"If set, any missing derived artifact will be reported as failure as well. Otherwise just the specified GAVs presence is required"})
    @Parameter(property="allRequired", defaultValue="false")
    private boolean allRequired;

    protected Result<Map<Artifact, Boolean>> doExecute() throws IOException {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.exists(this.getRemoteRepository(toolboxCommando), this.gav, this.pom, this.sources, this.javadoc, this.signature, this.allRequired, null);
    }
}

