/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin;

import eu.maveniverse.maven.toolbox.shared.output.AnsiOutput;
import eu.maveniverse.maven.toolbox.shared.output.LoggerOutput;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import eu.maveniverse.maven.toolbox.shared.output.PrintStreamOutput;
import java.util.Objects;
import org.jline.jansi.Ansi;
import org.slf4j.LoggerFactory;

public final class OutputFactory {
    private OutputFactory() {
    }

    private static void dumpOutputStatus(Output output) {
        if (output.isHeard(Output.Verbosity.CHATTER)) {
            output.chatter("Using output {}", new Object[]{output.getClass().getSimpleName()});
            output.chatter("Output verbosity '{}'", new Object[]{output.getVerbosity()});
            output.chatter("ANSI detected={} and enabled={}", new Object[]{Ansi.isDetected(), Ansi.isEnabled()});
        }
    }

    public static Output createMojoOutput(boolean batchMode, boolean errors, Output.Verbosity verbosity) {
        Objects.requireNonNull(verbosity, "verbosity");
        LoggerOutput output = new LoggerOutput(LoggerFactory.getLogger(OutputFactory.class), verbosity);
        if (!batchMode && System.console() != null) {
            if (!Ansi.isEnabled()) {
                Ansi.setEnabled((boolean)true);
            }
            output = new AnsiOutput((Output)output);
        }
        OutputFactory.dumpOutputStatus((Output)output);
        return output;
    }

    public static Output createCliOutput(boolean batchMode, boolean errors, Output.Verbosity verbosity) {
        Objects.requireNonNull(verbosity, "verbosity");
        PrintStreamOutput output = new PrintStreamOutput(System.out, verbosity, errors);
        if (!batchMode && System.console() != null) {
            if (!Ansi.isEnabled()) {
                Ansi.setEnabled((boolean)true);
            }
            output = new AnsiOutput((Output)output);
        }
        OutputFactory.dumpOutputStatus((Output)output);
        return output;
    }
}

