/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin;

import eu.maveniverse.maven.toolbox.plugin.MPMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.version.InvalidVersionSpecificationException;

public abstract class MPPluginMojoSupport
extends MPMojoSupport {
    @Parameter(property="pluginKey")
    private String pluginKey;

    protected <T extends InputLocationTracker> Predicate<T> definedInModel(Model model) {
        Objects.requireNonNull(model, "model");
        String modelId = model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion();
        return tracker -> {
            InputLocation location;
            if (tracker != null && (location = tracker.getLocation((Object)"")) != null) {
                InputSource source = location.getSource();
                return source != null && Objects.equals(source.getModelId(), modelId);
            }
            return false;
        };
    }

    protected Function<Model, BuildBase> projectBuildBaseSelector() {
        return model -> {
            if (model != null) {
                return model.getBuild();
            }
            return null;
        };
    }

    protected Function<Model, BuildBase> profileBuildBaseSelector(String profileId) {
        Objects.requireNonNull(profileId, "profileId");
        return model -> {
            if (model != null) {
                for (Profile profile : model.getProfiles()) {
                    if (!profileId.equals(profile.getId())) continue;
                    return profile.getBuild();
                }
            }
            return null;
        };
    }

    protected Function<BuildBase, List<Plugin>> buildManagedPluginsExtractor() {
        return build -> {
            if (build != null && build.getPluginManagement() != null) {
                return build.getPluginManagement().getPlugins();
            }
            return null;
        };
    }

    protected Function<BuildBase, List<Plugin>> buildPluginsExtractor() {
        return build -> {
            if (build != null) {
                return build.getPlugins();
            }
            return null;
        };
    }

    protected Function<Plugin, ResolutionRoot> pluginToResolutionRoot(ToolboxCommando toolboxCommando) {
        return plugin -> {
            if (plugin != null) {
                try {
                    ResolutionRoot root = toolboxCommando.loadGav(plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion());
                    if (!plugin.getDependencies().isEmpty()) {
                        root = root.builder().withDependencies(this.toDependencies(plugin.getDependencies())).build();
                    }
                    return root;
                }
                catch (ArtifactDescriptorException | VersionRangeResolutionException | InvalidVersionSpecificationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return null;
        };
    }

    protected ResolutionRoot pluginAsResolutionRoot(ToolboxCommando toolboxCommando, boolean mandatoryPluginKey) {
        Plugin plugin = null;
        if (this.pluginKey == null || this.pluginKey.trim().isEmpty()) {
            if (mandatoryPluginKey) {
                throw new IllegalArgumentException("Parameter 'pluginKey' must be set");
            }
            return null;
        }
        if (this.pluginKey.startsWith(":")) {
            String pluginGroup;
            Iterator iterator = this.mojoSettings.getPluginGroups().iterator();
            while (iterator.hasNext() && (plugin = this.mavenProject.getPlugin((pluginGroup = (String)iterator.next()) + this.pluginKey)) == null) {
            }
        } else {
            plugin = this.mavenProject.getPlugin(this.pluginKey);
            if (plugin == null) {
                for (Plugin p : this.mavenProject.getBuildPlugins()) {
                    if (!p.getKey().contains(this.pluginKey)) continue;
                    plugin = p;
                    break;
                }
            }
        }
        if (plugin == null) {
            return null;
        }
        return this.pluginToResolutionRoot(toolboxCommando).apply(plugin);
    }

    protected List<ResolutionRoot> allProjectManagedPluginsAsResolutionRoots(ToolboxCommando toolboxCommando) {
        return this.allProjectManagedPluginsAsResolutionRoots(toolboxCommando, this.mavenProject);
    }

    protected List<ResolutionRoot> allProjectPluginsAsResolutionRoots(ToolboxCommando toolboxCommando) {
        return this.allProjectPluginsAsResolutionRoots(toolboxCommando, this.mavenProject);
    }

    protected List<ResolutionRoot> allProjectManagedPluginsAsResolutionRoots(ToolboxCommando toolboxCommando, MavenProject mavenProject) {
        return this.pluginResolutionRoots(this.projectBuildBaseSelector(), this.buildManagedPluginsExtractor(), this.definedInModel(mavenProject.getModel()), this.pluginToResolutionRoot(toolboxCommando), mavenProject);
    }

    protected List<ResolutionRoot> allProjectPluginsAsResolutionRoots(ToolboxCommando toolboxCommando, MavenProject mavenProject) {
        return this.pluginResolutionRoots(this.projectBuildBaseSelector(), this.buildPluginsExtractor(), this.definedInModel(mavenProject.getModel()), this.pluginToResolutionRoot(toolboxCommando), mavenProject);
    }

    protected List<ResolutionRoot> allManagedPluginsAsResolutionRoots(ToolboxCommando toolboxCommando, MavenProject mavenProject) {
        return this.pluginResolutionRoots(this.projectBuildBaseSelector(), this.buildManagedPluginsExtractor(), p -> true, this.pluginToResolutionRoot(toolboxCommando), mavenProject);
    }

    protected List<ResolutionRoot> allPluginsAsResolutionRoots(ToolboxCommando toolboxCommando, MavenProject mavenProject) {
        return this.pluginResolutionRoots(this.projectBuildBaseSelector(), this.buildPluginsExtractor(), p -> true, this.pluginToResolutionRoot(toolboxCommando), mavenProject);
    }

    protected List<ResolutionRoot> allProfileManagedPluginsAsResolutionRoots(ToolboxCommando toolboxCommando, String profileId) {
        return this.pluginResolutionRoots(this.profileBuildBaseSelector(profileId), this.buildManagedPluginsExtractor(), this.definedInModel(this.mavenProject.getModel()), this.pluginToResolutionRoot(toolboxCommando), this.mavenProject);
    }

    protected List<ResolutionRoot> allProfilePluginsAsResolutionRoots(ToolboxCommando toolboxCommando, String profileId) {
        return this.pluginResolutionRoots(this.profileBuildBaseSelector(profileId), this.buildPluginsExtractor(), this.definedInModel(this.mavenProject.getModel()), this.pluginToResolutionRoot(toolboxCommando), this.mavenProject);
    }

    private <T> List<T> pluginResolutionRoots(Function<Model, BuildBase> selector, Function<BuildBase, List<Plugin>> extractor, Predicate<Plugin> predicate, Function<Plugin, T> transformer, MavenProject mavenProject) {
        ArrayList<T> result = new ArrayList<T>();
        List<Plugin> plugins = extractor.apply(selector.apply(mavenProject.getModel()));
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                if (!predicate.test(plugin)) continue;
                result.add(transformer.apply(plugin));
            }
        }
        return result;
    }
}

